<?php
// بدء الجلسة
session_start();

// التحقق مما إذا كان المستخدم مسجلاً للدخول
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: superadminlogin.php");
    exit;
}
// جلب معرف المستخدم من الجلسة
$iduser = $_SESSION["iduser"];
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Supervisor ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
  <style>
body{font-family:Tahoma,Arial}
table{border-collapse:collapse;width:100%}
th,td{border:1px solid #ddd;padding:6px;text-align:center}
th{background:#f3f5fb}
.badge{display:inline-block;padding:2px 6px;border-radius:10px;font-size:11px}
.badge.red{background:#f8d7da;color:#721c24}
.badge.orange{background:#fff3cd;color:#856404}
.badge.green{background:#d4edda;color:#155724}
.growth.red{background:#f8d7da}
.growth.green{background:#d4edda}
.small{font-size:12px;color:#666}
.head-sticky thead th{position:sticky;top:0;z-index:2}
.controls{margin:8px 0}
.kpi-bar{height:8px;background:#e9ecef;border-radius:4px;overflow:hidden}
.kpi-fill{height:100%;background:#7a70fa}
</style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
<?php include 'superadminheader.php'; ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
      <?php include 'supersidepanle.php'; ?>
      <!-- search form -->
     <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
        <?php include 'navemenusuper.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Weekly PT KPIS Of Our Team </a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Weekly Part Time KPIS Team Details</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
  <!-- #region -->

<br>
  <div class="col-md-12">
<?php
/********* إعداد الاتصال *********/
$host     = 'localhost:3306';
$dbname   = 'acesaudi_site';
$username = 'acesaudi_usr';
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username, $password, [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
} catch (PDOException $e) { die("DB Error: " . $e->getMessage()); }

function h($v){ return htmlspecialchars((string)($v ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

/* استخراج أول رقم (ساعات) من نص worktime مثل: "Full Time AM 8 hours" -> 8 */
function extractWorkHours(?string $worktime): ?float {
    if ($worktime === null) return null;
    if (preg_match('/(\d+(?:\.\d+)?)/', $worktime, $m)) return (float)$m[1];
    return null;
}

/********* مُدخلات *********/
$year      = isset($_GET['year']) ? (int)$_GET['year'] : (int)date('Y');
$fulltime  = isset($_GET['fulltime_only']);          // users.worktime = 'Full Time AM 8 hours'
$ids_raw   = trim($_GET['specialist_ids'] ?? '');    // "324,173"
$export    = isset($_GET['export']);

$MONTHS = [1=>'Jan',2=>'Feb',3=>'March',4=>'April',5=>'May',6=>'June',7=>'July',8=>'Aug',9=>'Sep',10=>'Oct',11=>'Nov',12=>'Dec'];
$MONTHLY_TARGET_HOURS = 170.0; // الهدف الشهري الثابت لكل أخصائي

/********* Helpers *********/
function parseIdList($raw){
    $out=[]; if($raw!==''){ foreach(explode(',',$raw) as $id){ $id=trim($id); if($id!==''&&ctype_digit($id)) $out[]=(int)$id; } }
    return $out;
}
$ids = parseIdList($ids_raw);

/* ==== 1) شروط الاستعلام الفرعي على bookings (alias b) ==== */
$subWhere  = ["YEAR(b.booking_date)=?", "TRIM(COALESCE(b.bookingstatus,'')) IN ('مكتمل','محجوز')"];
$subParams = [$year];

if (!empty($ids)) {
    $in = implode(',', array_fill(0, count($ids), '?'));
    $subWhere[] = "b.spesilstid IN ($in)";
    $subParams  = array_merge($subParams, $ids);
}
$subWhereSql = 'WHERE '.implode(' AND ', $subWhere);

/* ==== 2) الاستعلام الفرعي: حساب دقائق كل موعد ==== */
$subSql = "
  SELECT
    b.spesilstid,
    COALESCE(NULLIF(b.spclistsname,''), '') AS spclistsname,
    b.booking_date,
    CASE
      WHEN b.session_duration IS NOT NULL AND b.session_duration > 0
        THEN b.session_duration
      WHEN b.end_time IS NOT NULL AND b.time_slot IS NOT NULL
        THEN GREATEST(0, TIMESTAMPDIFF(MINUTE, CONCAT(b.booking_date,' ',b.time_slot), CONCAT(b.booking_date,' ',b.end_time)))
      ELSE 45
    END AS session_minutes
  FROM bookings b
  $subWhereSql
";

/* ==== 3) شرط خارجي اختياري على users (alias u) ==== */
$outerWhere  = [];
$outerParams = [];
if ($fulltime) {
    $outerWhere[] = "TRIM(COALESCE(u.worktime,''))='Full Time AM 8 hours'";
}
$outerWhereSql = $outerWhere ? ('WHERE '.implode(' AND ', $outerWhere)) : '';

/* ==== 4) الاستعلام النهائي مع Pivot شهري ==== */
$monthSums = [];
foreach (array_keys($MONTHS) as $m) {
    $monthSums[] = "SUM(CASE WHEN MONTH(b2.booking_date)=$m THEN b2.session_minutes ELSE 0 END) AS m$m";
}
$monthSumsSql = implode(",\n  ", $monthSums);

$sql = "
SELECT
  b2.spesilstid AS specialist_id,
  COALESCE(NULLIF(b2.spclistsname,''), u.fullarabicname, 'غير محدد') AS specialist_name,
  u.worktime,
  $monthSumsSql,
  SUM(b2.session_minutes) AS minutes_year
FROM ( $subSql ) b2
LEFT JOIN users u ON u.iduser = b2.spesilstid
$outerWhereSql
GROUP BY b2.spesilstid, specialist_name, u.worktime
ORDER BY minutes_year DESC, specialist_name ASC
";

/* ==== 5) تنفيذ ==== */
$params = array_merge($subParams, $outerParams);
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

/********* تجهيز بيانات العرض *********/
$data = [];
$totals_per_month = array_fill(1,12,0.0);

foreach ($rows as $r){
    $spec = [
        'id'          => $r['specialist_id'],
        'name'        => $r['specialist_name'],
        'work'        => $r['worktime'],
        'work_hours'  => extractWorkHours($r['worktime']),   // 👈 ساعات العمل من نص worktime
        'months'      => [],
        'year_minutes'=> (float)$r['minutes_year'],
        'year_hours'  => ((float)$r['minutes_year'])/60.0,
        'growth'      => 0.0
    ];
    $lastMonthWithHours = 0; $lastVal = 0.0;

    foreach ($MONTHS as $m => $label){
        $min  = (float)($r["m$m"] ?? 0);
        $hrs  = $min / 60.0;
        $kpi  = $MONTHLY_TARGET_HOURS>0 ? ($hrs/$MONTHLY_TARGET_HOURS)*100.0 : 0.0;

        $spec['months'][$m] = ['hours'=>$hrs,'kpi'=>$kpi];
        $totals_per_month[$m] += $hrs;

        if ($hrs > 0) { $lastMonthWithHours = $m; $lastVal = $hrs; }
    }

    // Growth: آخر شهر مقابل السابق له
    if ($lastMonthWithHours > 1) {
        $prevHrs = $spec['months'][$lastMonthWithHours-1]['hours'] ?? 0.0;
        if ($prevHrs > 0) {
            $spec['growth'] = (($lastVal - $prevHrs)/$prevHrs)*100.0;
        } else {
            $spec['growth'] = $lastVal > 0 ? 100.0 : 0.0;
        }
    } else {
        $spec['growth'] = 0.0;
    }

    $data[] = $spec;
}

usort($data, fn($a,$b) => $b['year_hours'] <=> $a['year_hours']);

/********* Export Excel (مع عمود ساعات العمل) *********/
if ($export) {
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header("Content-Disposition: attachment; filename=\"annual_kpi_{$year}.xls\"");
    echo "<table border='1' style='text-align:center;font-family:Tahoma'>";
    echo "<tr><th>#</th><th>Specialist</th><th>Worktime (hrs)</th>";
    foreach ($MONTHS as $m=>$lab) echo "<th>{$lab} (hrs)</th>";
    echo "<th>Total (hrs)</th><th>Growth %</th></tr>";
    $i=1;
    foreach ($data as $row){
        echo "<tr>";
        echo "<td>".($i++)."</td>";
        echo "<td>".h($row['name'])."</td>";
        echo "<td>".($row['work_hours']!==null ? number_format($row['work_hours'],1) : '')."</td>";
        foreach ($MONTHS as $m=>$lab){
            echo "<td>".number_format($row['months'][$m]['hours'],1)."</td>";
        }
        echo "<td>".number_format($row['year_hours'],1)."</td>";
        echo "<td>".number_format($row['growth'],1)."%</td>";
        echo "</tr>";
    }
    // إجمالي شهري
    echo "<tr style='font-weight:bold;background:#f3f5fb'><td colspan='3'>Totals</td>";
    foreach ($MONTHS as $m=>$lab) echo "<td>".number_format($totals_per_month[$m],1)."</td>";
    echo "<td></td><td></td></tr>";
    echo "</table>";
    exit;
}
?>

<form method="get" class="controls" style="text-align: center;">
  السنة
  <select name="year" class="form-control">
    <?php for($y=date('Y')-2;$y<=date('Y')+1;$y++): ?>
      <option value="<?= $y ?>" <?= $y==$year?'selected':''; ?>><?= $y ?></option>
    <?php endfor; ?>
  </select><br>
   الأخصائيين (اختياري) <input type="text" name="specialist_ids" value="<?= h($ids_raw) ?>" placeholder="324,173" class="form-control"> <br>
  <label style="margin:0 8px;">
    <input type="checkbox" name="fulltime_only" value="1" <?= $fulltime?'checked':''; ?>> دوام كامل فقط<br>
  </label><br><br>
  <button type="submit" class="btn btn-primary">تحديث</button>
  <button type="submit" name="export" value="1" class="btn btn-success">تصدير ملف إكسل</button> <br><br>

  <div class="col-md-12">
          <div class="box box-info box-solid">
            <div class="box-header with-border">
              <h3 class="box-title">الهدف الشهري لكل أخصائي = <b><?= number_format($MONTHLY_TARGET_HOURS,1) ?> ساعة</b> (42.5 ساعة/أسبوع × ~4 أسابيع)</h3>

              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                </button>
              </div>
              <!-- /.box-tools -->
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              يقوم النظام بإحتساب التارجت الشهري لكل أخصائي تلقائياً و يقوم بعمل مؤشر نسبة أيقونة لتقدم مؤشر أداء الأخصائي
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>

</form>

<table class="head-sticky">
  <thead>
    <tr>
      <th>#</th>
      <th>الأخصائي</th>
      <th>ساعات العمل</th> <!-- العمود الجديد -->
      <?php foreach($MONTHS as $m=>$lab): ?>
        <th><?= $lab ?><br><span class="small">hrs • KPI%</span></th>
      <?php endforeach; ?>
      <th>Total (hrs)</th>
      <th>Growth</th>
    </tr>
  </thead>
  <tbody>
    <?php if(!$data): ?>
      <tr><td colspan="<?= 3 + count($MONTHS) + 2 ?>">لا توجد بيانات</td></tr>
    <?php else: $i=1; foreach($data as $row): 
          $gcls = ($row['growth']>=0)?'green':'red';
    ?>
      <tr>
        <td><?= $i++ ?></td>
        <td><?= h($row['name']) ?><?= $row['work']?' <div class="small">'.h($row['work']).'</div>':'' ?></td>
        <td><?= $row['work_hours']!==null ? number_format($row['work_hours'],1) : '—' ?></td>
        <?php foreach($MONTHS as $m=>$lab):
              $hrs = $row['months'][$m]['hours'];
              $kpi = $row['months'][$m]['kpi'];
              $cls = ($kpi>=100)?'green':(($kpi>=80)?'orange':'red');
        ?>
          <td>
            <?= number_format($hrs,1) ?>
            <div class="badge <?= $cls ?>"><?= number_format($kpi,0) ?>%</div>
            <div class="kpi-bar"><div class="kpi-fill" style="width:<?= max(0,min(100,$kpi)) ?>%"></div></div>
          </td>
        <?php endforeach; ?>
        <td><?= number_format($row['year_hours'],1) ?></td>
        <td class="growth <?= $gcls ?>"><?= ($row['growth']>=0?'+':'').number_format($row['growth'],1) ?>%</td>
      </tr>
    <?php endforeach; endif; ?>
  </tbody>
  <tfoot>
    <tr style="font-weight:bold;background:#f3f5fb">
      <td colspan="3">Totals</td>
      <?php foreach($MONTHS as $m=>$lab): ?>
        <td><?= number_format($totals_per_month[$m],1) ?></td>
      <?php endforeach; ?>
      <td></td><td></td>
    </tr>
  </tfoot>
</table>


</div>

            <!-- /.box-body -->
          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
