<?php
// تشغيل الأخطاء أثناء التطوير
error_reporting(E_ALL);
ini_set('display_errors', 1);

// تحقق من المدخلات
if (
    empty($_POST['from_date']) ||
    empty($_POST['to_date']) ||
    empty($_POST['bookingstatus']) ||
    (empty($_POST['spesilstid']) && empty($_POST['spechilstid']))
) {
    http_response_code(400);
    exit('الرجاء تعبئة جميع الحقول المطلوبة.');
}

// إصلاح اختلاف اسم الحقل لو موجود
$spesilstid = isset($_POST['spesilstid']) ? $_POST['spesilstid'] : $_POST['spechilstid'];

$from  = $_POST['from_date'];   // YYYY-MM-DD
$to    = $_POST['to_date'];     // YYYY-MM-DD
$status= $_POST['bookingstatus'];

// اتصال القاعدة (حسب الصورة: acesaudi_site)
$mysqli = @new mysqli("localhost:3306", "acesaudi_usr", "tabfyv-6xiFry-noczak", "acesaudi_site");
if ($mysqli->connect_errno) {
    http_response_code(500);
    exit("فشل الاتصال بقاعدة البيانات: " . $mysqli->connect_error);
}
$mysqli->set_charset("utf8");

// الاستعلام — ترتيب حسب التاريخ ثم الوقت تنازليًا
$sql = "
SELECT
    id, patient_name, typeservice, time_slot, room_id, period,
    session_duration, bookingstatus, patient_id, booking_date
FROM bookings
WHERE booking_date BETWEEN ? AND ?
  AND bookingstatus = ?
  AND spesilstid = ?
ORDER BY booking_date DESC, time_slot DESC
";

$stmt = $mysqli->prepare($sql);
if (!$stmt) {
    http_response_code(500);
    exit("فشل التحضير للاستعلام: " . $mysqli->error);
}
// كلهم نصوص حسب هيكلة الجدول (spesilstid varchar)
$stmt->bind_param("ssss", $from, $to, $status, $spesilstid);
if (!$stmt->execute()) {
    http_response_code(500);
    exit("فشل تنفيذ الاستعلام: " . $stmt->error);
}
$result = $stmt->get_result();

// احصائيات بسيطة
$total = $result->num_rows;

// طباعة النتائج
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>نتائج الفلترة</title>
<style>
  body{font-family:Tahoma, Arial; padding:20px}
  .kpis{display:flex; gap:12px; margin-bottom:16px}
  .kpi{background:#f3f3f8; padding:10px 14px; border-radius:10px}
  table{width:100%; border-collapse:collapse}
  th,td{border:1px solid #e5e5e5; padding:8px; text-align:center}
  th{background:#fafafa}
  .label{display:inline-block; padding:3px 6px; border-radius:4px; background:#28a745; color:#fff; font-size:12px}
</style>
</head>
<body>

<div class="kpis">
  <div class="kpi">من: <b><?=htmlspecialchars($from)?></b></div>
  <div class="kpi">إلى: <b><?=htmlspecialchars($to)?></b></div>
  <div class="kpi">الحالة: <b><?=htmlspecialchars($status)?></b></div>
  <div class="kpi">المعالج (spesilstid): <b><?=htmlspecialchars($spesilstid)?></b></div>
  <div class="kpi">الإجمالي: <b><?=number_format($total)?></b></div>
</div>

<table>
  <tr>
    <th width="10%">Appointment NO.</th>
    <th width="20%">Patient Name</th>
    <th width="20%">Service</th>
    <th width="10%">Start Time</th>
    <th width="10%">Room ID</th>
    <th width="10%">Period</th>
    <th width="10%">Duration Session</th>
    <th width="10%">Status</th>
    <th width="10%">Patient ID</th>
    <th width="20%">Booking Date</th>
  </tr>
  <?php if ($total > 0): ?>
    <?php while($row = $result->fetch_assoc()): ?>
      <tr>
        <td><?=htmlspecialchars($row['id'])?></td>
        <td><?=htmlspecialchars($row['patient_name'])?></td>
        <td><?=htmlspecialchars($row['typeservice'])?></td>
        <td><?=htmlspecialchars($row['time_slot'])?></td>
        <td><?=htmlspecialchars($row['room_id'])?></td>
        <td><?=htmlspecialchars($row['period'])?></td>
        <td><?=htmlspecialchars($row['session_duration'])?></td>
        <td><span class="label"><?=htmlspecialchars($row['bookingstatus'])?></span></td>
        <td><?=htmlspecialchars($row['patient_id'])?></td>
        <td><?=htmlspecialchars($row['booking_date'])?></td>
      </tr>
    <?php endwhile; ?>
  <?php else: ?>
      <tr><td colspan="10">لا توجد نتائج ضمن المعايير المحددة</td></tr>
  <?php endif; ?>
</table>

</body>
</html>
<?php
$stmt->close();
$mysqli->close();
