<?php
// ajax/filterkpis_ajax.php
header('Content-Type: application/json; charset=utf-8');

error_reporting(E_ALL);
ini_set('display_errors', 1);

// تحقق من المدخلات
if (
    empty($_POST['from_date']) ||
    empty($_POST['to_date']) ||
    empty($_POST['bookingstatus']) ||
    empty($_POST['spesilstid'])
) {
    echo json_encode(['ok'=>false, 'message'=>'الرجاء تعبئة جميع الحقول المطلوبة.']); exit;
}

$from   = $_POST['from_date'];     // YYYY-MM-DD
$to     = $_POST['to_date'];       // YYYY-MM-DD
$status = $_POST['bookingstatus']; // نص عربي
$specId = $_POST['spesilstid'];    // varchar(50) حسب الجدول

// اتصال القاعدة (حسب لقطة الشاشة: acesaudi_site)
$mysqli = @new mysqli("localhost:3306", "acesaudi_usr", "tabfyv-6xiFry-noczak", "acesaudi_site");
if ($mysqli->connect_errno) {
    echo json_encode(['ok'=>false, 'message'=>'فشل الاتصال بقاعدة البيانات: '.$mysqli->connect_error]); exit;
}
$mysqli->set_charset("utf8mb4");

// الاستعلام مرتب تاريخ/وقت تنازلي
$sql = "
SELECT
    id, patient_name, typeservice, time_slot, room_id, period,
    session_duration, bookingstatus, patient_id, booking_date
FROM bookings
WHERE booking_date BETWEEN ? AND ?
  AND bookingstatus = ?
  AND spesilstid = ?
ORDER BY booking_date DESC, time_slot DESC
";

$stmt = $mysqli->prepare($sql);
if (!$stmt) {
    echo json_encode(['ok'=>false, 'message'=>'فشل التحضير للاستعلام: '.$mysqli->error]); exit;
}
$stmt->bind_param("ssss", $from, $to, $status, $specId);
if (!$stmt->execute()) {
    echo json_encode(['ok'=>false, 'message'=>'فشل تنفيذ الاستعلام: '.$stmt->error]); exit;
}
$result = $stmt->get_result();
$total  = $result ? $result->num_rows : 0;

// بناء الجدول HTML
ob_start();
?>
<table class="table table-bordered">
  <tr>
    <th width="10%">Appointment NO.</th>
    <th width="20%">Patient Name</th>
    <th width="20%">Service</th>
    <th width="10%">Start Time</th>
    <th width="10%">Room ID</th>
    <th width="10%">Period</th>
    <th width="10%">Duration Session</th>
    <th width="10%">Status</th>
    <th width="10%">Patient ID</th>
    <th width="20%">Booking Date</th>
  </tr>
  <?php if ($total > 0): ?>
    <?php while($row = $result->fetch_assoc()): ?>
      <tr>
        <td><?=htmlspecialchars($row['id'])?></td>
        <td><?=htmlspecialchars($row['patient_name'])?></td>
        <td><?=htmlspecialchars($row['typeservice'])?></td>
        <td><?=htmlspecialchars($row['time_slot'])?></td>
        <td><?=htmlspecialchars($row['room_id'])?></td>
        <td><?=htmlspecialchars($row['period'])?></td>
        <td><?=htmlspecialchars($row['session_duration'])?></td>
        <td><span class="label"><?=htmlspecialchars($row['bookingstatus'])?></span></td>
        <td><?=htmlspecialchars($row['patient_id'])?></td>
        <td><?=htmlspecialchars($row['booking_date'])?></td>
      </tr>
    <?php endwhile; ?>
  <?php else: ?>
      <tr><td colspan="10">لا توجد نتائج ضمن المعايير المحددة</td></tr>
  <?php endif; ?>
</table>
<?php
$table_html = ob_get_clean();

$stmt->close();
$mysqli->close();

echo json_encode([
  'ok' => true,
  'total' => $total,
  'table_html' => $table_html
]);
