<?php
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// اتصال
$have_external_conn = false;
if (file_exists(__DIR__.'/conn.php')) {
  include __DIR__.'/conn.php';
  if (isset($conn) && $conn instanceof mysqli) $have_external_conn = true;
}
if (!$have_external_conn) {
  $conn = new mysqli('localhost','acesaudi_usr','tabfyv-6xiFry-noczak','acesaudi_site');
  if ($conn->connect_error) { http_response_code(500); die('DB connection failed'); }
}
$conn->set_charset('utf8mb4');

// مدخلات
$q  = trim($_GET['q'] ?? '');
$insurancecompanyid = trim($_GET['insurancecompanyid'] ?? ''); // اختياري

header('Content-Type: application/json; charset=utf-8');

if ($q === '') { echo json_encode(['results'=>[]], JSON_UNESCAPED_UNICODE); exit; }

$likeAny   = '%'.$q.'%';
$likeStart = $q.'%';

// تطبيع الكود: إزالة المسافات/الشرطات/الـ _ وتحويل لكابيتال
$codeNorm = strtoupper(str_replace([' ','-','_'], '', $q));

$sql = "SELECT
          service_id,
          insurancecompanyid,
          insurancecopmanyname,
          SERVICE_TYPE,
          SERVICE_CODE,
          NON_STANDARD_CODE,
          service_name_ar,
          service_name_en,
          NON_STANDARD_DESC,
          UNIT_PRICE,
          specialty,
          FACTOR
        FROM insuranceservices
        WHERE (
          service_name_ar      LIKE ?
          OR service_name_en   LIKE ?
          OR SERVICE_CODE      LIKE ?
          OR NON_STANDARD_CODE LIKE ?
          OR NON_STANDARD_DESC LIKE ?
          OR specialty         LIKE ?
        )";

$params = [$likeAny,$likeAny,$likeAny,$likeAny,$likeAny,$likeAny];
$types  = "ssssss";

if ($insurancecompanyid !== '') {
  $sql .= " AND (insurancecompanyid = ? OR insurancecopmanyname = ?)";
  $params[] = $insurancecompanyid;
  $params[] = $insurancecompanyid;
  $types   .= "ss";
}

/* ترتيب ذكي:
   0) مطابقة تامة للكود بعد التطبيع
   1) يبدأ بالاسم
   2) يبدأ بالكود
   3) الباقي
*/
$sql .= " ORDER BY
  CASE
    WHEN UPPER(REPLACE(REPLACE(REPLACE(IFNULL(SERVICE_CODE,''),'-',''),' ','') ,'_','')) = ? THEN 0
    WHEN UPPER(REPLACE(REPLACE(REPLACE(IFNULL(NON_STANDARD_CODE,''),'-',''),' ','') ,'_','')) = ? THEN 0
    WHEN service_name_ar    LIKE ? THEN 1
    WHEN service_name_en    LIKE ? THEN 1
    WHEN SERVICE_CODE       LIKE ? THEN 2
    WHEN NON_STANDARD_CODE  LIKE ? THEN 2
    ELSE 3
  END,
  LENGTH(IFNULL(service_name_ar, service_name_en)),
  service_id
  LIMIT 20";

$params[] = $codeNorm;  // تام على SERVICE_CODE
$params[] = $codeNorm;  // تام على NON_STANDARD_CODE
$params[] = $likeStart; // يبدأ بالاسم (ar)
$params[] = $likeStart; // يبدأ بالاسم (en)
$params[] = $likeStart; // يبدأ بالكود القياسي
$params[] = $likeStart; // يبدأ بالكود غير القياسي
$types   .= "ssssss";

$stmt = $conn->prepare($sql);
if (!$stmt) { http_response_code(500); echo json_encode(['error'=>'prepare failed']); exit; }
$stmt->bind_param($types, ...$params);
$stmt->execute();
$res = $stmt->get_result();

$out = [];
while ($r = $res->fetch_assoc()) {
  $out[] = [
    'service_id' => (int)$r['service_id'],
    'name_ar'    => $r['service_name_ar'],
    'name_en'    => $r['service_name_en'],
    'price'      => (float)$r['UNIT_PRICE'],
    'code'       => $r['SERVICE_CODE'],
    'non_code'   => $r['NON_STANDARD_CODE'],
    'desc'       => $r['NON_STANDARD_DESC'],
    'type'       => $r['SERVICE_TYPE'],
    'specialty'  => $r['specialty'],
    'factor'     => $r['FACTOR'],
    'payer_id'   => $r['insurancecompanyid'],
    'payer_name' => $r['insurancecopmanyname'],
  ];
}
$stmt->close();

echo json_encode(['results'=>$out], JSON_UNESCAPED_UNICODE);
