<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام حجز مواعيد المرضى</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            direction: rtl;
            margin: 0;
            padding: 20px;
        }
        h1 {
            text-align: center;
        }
        .form-container {
            max-width: 600px;
            margin: 0 auto;
            background: #f9f9f9;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        select, input[type="text"], input[type="time"], input[type="date"] {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        button {
            background-color: #4CAF50;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        .availability-list {
            margin-top: 20px;
        }
        .availability-list select {
            width: 80%;
        }
    </style>
</head>
<body>

<h1>نظام حجز مواعيد المرضى</h1>

<div class="form-container">
    <form id="booking-form">
        <label for="date">التاريخ:</label>
        <input type="date" id="date" name="date" required>

        <label for="section">القسم:</label>
        <select id="section" name="section" required>
            <option value="section_1">الفترة الأولى (7:00 - 12:00)</option>
            <option value="section_2">الفترة الثانية (13:00 - 18:00)</option>
            <option value="section_op">الفترة الثالثة (OP 12:00 - 22:00)</option>
            <option value="section_op1">الفترة الرابعة (OP1 18:00 - 22:00)</option>
        </select>

        <label for="room">الغرفة:</label>
        <select id="room" name="room" required>
            <!-- سيتم ملؤها ديناميكيًا -->
        </select>

        <label for="appointment_time">وقت الموعد:</label>
        <input type="time" id="appointment_time" name="appointment_time" required>

        <label for="patient_name">اسم المريض:</label>
        <input type="text" id="patient_name" name="patient_name" required>

        <button type="submit">حجز الموعد</button>
    </form>

    <div class="availability-list" id="availability-list">
        <!-- سيتم عرض الأوقات المتاحة هنا -->
    </div>
</div>

<script>
    // جلب الأوقات المتاحة لكل قسم وغرفة
    document.getElementById('section').addEventListener('change', function() {
        let section = this.value;
        let date = document.getElementById('date').value;
        if (date) {
            fetchAvailableSlots(section, date);
        }
    });

    // دالة لجلب الأوقات المتاحة من الخادم عبر AJAX
    function fetchAvailableSlots(section, date) {
        fetch(`get_available_slots.php?section=${section}&date=${date}`)
            .then(response => response.json())
            .then(data => {
                updateRoomSelect(data.rooms);
                updateAvailabilityList(data.slots);
            })
            .catch(error => console.error('Error:', error));
    }

    // دالة لتحديث الغرف المتاحة
    function updateRoomSelect(rooms) {
        const roomSelect = document.getElementById('room');
        roomSelect.innerHTML = ''; // إعادة تعيين الغرف
        rooms.forEach(room => {
            let option = document.createElement('option');
            option.value = room;
            option.textContent = `غرفة ${room}`;
            roomSelect.appendChild(option);
        });
    }

    // دالة لتحديث قائمة الأوقات المتاحة
    function updateAvailabilityList(slots) {
        const availabilityList = document.getElementById('availability-list');
        availabilityList.innerHTML = ''; // إعادة تعيين الأوقات المتاحة

        if (slots.length === 0) {
            availabilityList.innerHTML = '<p>لا توجد أوقات متاحة في هذا القسم حالياً.</p>';
        } else {
            let list = '<ul>';
            slots.forEach(slot => {
                list += `<li>الوقت: ${slot.time} - غرفة: ${slot.room}</li>`;
            });
            list += '</ul>';
            availabilityList.innerHTML = list;
        }
    }

    // إرسال البيانات إلى الخادم لحجز الموعد
    document.getElementById('booking-form').addEventListener('submit', function(event) {
        event.preventDefault(); // منع إرسال النموذج الافتراضي

        let formData = new FormData(this);
        fetch('book_appointment.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(data => alert(data))
        .catch(error => console.error('Error:', error));
    });

    // عند تحميل الصفحة، جلب الأوقات المتاحة للقسم الافتراضي (الفترة الأولى)
    fetchAvailableSlots('section_1', new Date().toISOString().split('T')[0]);
</script>

</body>
</html>
