<?php
// إعداد الاتصال بقاعدة البيانات
$host = "localhost:3306";
$dbname = "acesaudi_site";
$username = "acesaudi_usr";
$password = 'tabfyv-6xiFry-noczak';

$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// استقبال الفلاتر
$fromDate = $_GET['from'] ?? date('Y-m-d');
$toDate = $_GET['to'] ?? date('Y-m-d', strtotime('+7 days'));
$room = $_GET['room'] ?? '';
$patientname = $_GET['patientname'] ?? '';

// إعداد الاستعلام
$query = "SELECT * FROM bookings WHERE bookingstatus = 'متوفر' AND booking_date BETWEEN :from AND :to";
if (!empty($room)) {
    $query .= " AND room_id = :room";
}
$query .= " ORDER BY booking_date ASC, time_slot ASC";

try {
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':from', $fromDate);
    $stmt->bindParam(':to', $toDate);
    if (!empty($room)) {
        $stmt->bindParam(':room', $room);
    }
    $stmt->execute();
    $sessions = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("خطأ في الاستعلام: " . $e->getMessage());
}

// تحويل أسماء الأيام إلى العربية
$days_ar = [
    'Saturday' => 'السبت',
    'Sunday' => 'الأحد',
    'Monday' => 'الإثنين',
    'Tuesday' => 'الثلاثاء',
    'Wednesday' => 'الأربعاء',
    'Thursday' => 'الخميس',
    'Friday' => 'الجمعة',
];
?>
<?php include 'sessionheaderrecption.php'; ?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">
      <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <title>الفترات المتاحة</title>
    <style>
        body { background-color: #f8f9fa; font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease; }
        input[type="text"], input[type="date"] { padding: 5px; width: 250px; margin-bottom: 10px; }
        button { padding: 10px 20px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; }
        button:hover { background-color: #0056b3; }
        .slot-btn { display: inline-block; padding: 10px; background: #d4edda; border: 1px solid #28a745; border-radius: 5px; margin: 5px; cursor: pointer; direction: rtl;}
        .slot-btn input { display: none; }
        .slot-btn:hover { background: #c3e6cb; }
        .form-section { margin-bottom: 30px; }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">

<div class="wrapper">


<?php include 'receptionheader.php'; ?>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'receptionsidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenureception.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains ppatient_name content -->
  <div class="content-wrapper">
    <!-- Content Header (Ppatient_name header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="receptiondashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Search By Appoiment</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title" style="font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease;">Result Appoiment Update - حالة تحديث الموعد  </h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">

            <div class="col-md-12" style="text-align: center;">

            <?php
// إعداد الاتصال بقاعدة البيانات
$host = "localhost:3306";
$dbname = "acesaudi_site";
$username = "acesaudi_usr";
$password = 'tabfyv-6xiFry-noczak';

$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// استقبال البيانات من POST
$patient_name     = $_POST['patient_name'] ?? '';
$patient_id       = $_POST['patient_id'] ?? '';
$session_duration = $_POST['session_duration'] ?? '';
$service_id       = $_POST['service_id'] ?? '';
$spesilstid       = $_POST['spesilstid'] ?? '';
$userupsated      = $_POST['userupsated'] ?? '';
$appid            = $_POST['appid'] ?? '';
$old_booking_date = $_POST['bookingdate'] ?? '';
$old_day_name     = $_POST['dayNameArabic'] ?? '';
$old_time_slot    = '';
$booking_id       = $_POST['booking_id'] ?? '';

echo "<pre>";
print_r($_POST);
echo "</pre>";

if (!$patient_id || !$service_id || !$booking_id || !$old_booking_date) {
    die("❌ البيانات غير مكتملة، الرجاء التأكد من إرسال جميع الحقول المطلوبة.");
}

// استعلام للحصول على بيانات الموعد الجديد
$stmt = $pdo->prepare("SELECT * FROM bookings WHERE id = :id");
$stmt->execute([':id' => $booking_id]);
$new_booking = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$new_booking) {
    die("❌ الموعد الجديد غير موجود.");
}

$new_booking_date = $new_booking['booking_date'];
$new_time_slot    = $new_booking['time_slot'];
$new_end_time     = $new_booking['end_time'];
$new_day_name_en  = date('l', strtotime($new_booking_date));
$old_day_name_en  = date('l', strtotime($old_booking_date));

// حساب الفرق بين الأيام (مثلاً من Tuesday إلى Thursday = +2)
$daysMap = ['Sunday'=>0,'Monday'=>1,'Tuesday'=>2,'Wednesday'=>3,'Thursday'=>4,'Friday'=>5,'Saturday'=>6];
$day_diff = $daysMap[$new_day_name_en] - $daysMap[$old_day_name_en];

if ($day_diff === 0 && $old_time_slot === $new_time_slot) {
    die("⚠️ لا يوجد تغيير في اليوم أو الوقت");
}

// استعلام للحصول على الفترة القديمة
$stmt2 = $pdo->prepare("SELECT time_slot FROM bookings WHERE id = :id");
$stmt2->execute([':id' => $appid]);
$row = $stmt2->fetch(PDO::FETCH_ASSOC);
$old_time_slot = $row['time_slot'] ?? '';

if (!$old_time_slot) {
    die("❌ لم يتم العثور على الفترة القديمة.");
}

// تحديث كل المواعيد المستقبلية المشابهة
$updateQuery = "
    UPDATE bookings
    SET booking_date = DATE_ADD(booking_date, INTERVAL :day_diff DAY),
        time_slot = :new_time_slot,
        end_time = :new_end_time
    WHERE patient_id = :patient_id
      AND service_id = :service_id
      AND DAYNAME(booking_date) = :old_day_name_en
      AND time_slot = :old_time_slot
      AND booking_date >= :old_booking_date
";

$stmt3 = $pdo->prepare($updateQuery);
$stmt3->execute([
    ':day_diff' => $day_diff,
    ':new_time_slot' => $new_time_slot,
    ':new_end_time' => $new_end_time,
    ':patient_id' => $patient_id,
    ':service_id' => $service_id,
    ':old_day_name_en' => $old_day_name_en,
    ':old_time_slot' => $old_time_slot,
    ':old_booking_date' => $old_booking_date
]);

$count = $stmt3->rowCount();

if ($count > 0) {
    echo "✅ تم تعديل {$count} من المواعيد المتكررة بنجاح";
} else {
    echo "⚠️ لم يتم تعديل أي موعد. تحقق من الشروط أو أن المواعيد غير موجودة بعد";
}
?>

            </div>
                   </div>

</div>


</body>
</html>

