<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>حجز مواعيد العيادة</title>

    <!-- ربط jQuery و jQuery UI لاضافة التقويم و timepicker -->
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-timepicker/1.13.1/jquery.timepicker.min.css">

    <style>
        body {
            font-family: Arial, sans-serif;
            direction: rtl;
            text-align: right;
            padding: 20px;
        }

        form {
            margin-bottom: 20px;
        }

        label {
            margin-right: 10px;
        }

        input, select, button {
            padding: 8px;
            margin: 5px;
        }

        #errorMessage {
            color: red;
            display: none;
        }

        #calendar {
            width: 100%;
            max-width: 400px;
            margin: 20px auto;
        }
    </style>
</head>
<body>

<h2>حجز موعد للعيادة</h2>

<form id="appointmentForm" action="book_appointment.php" method="POST">
    <label for="patient_name">اسم المريض:</label>
    <input type="text" id="patient_name" name="patient_name" required><br>

    <label for="date">التاريخ:</label>
    <input type="text" id="date" name="date" required readonly><br>

    <label for="appointment_time">الوقت:</label>
    <input type="text" id="appointment_time" name="appointment_time" required><br>

    <label for="section">القسم:</label>
    <select id="section" name="section">
        <option value="morning">الصباحية</option>
        <option value="afternoon">الظهيرة</option>
        <option value="op">OP</option>
    </select><br>

    <label for="room">الغرفة:</label>
    <input type="number" id="room" name="room" required><br>

    <button type="submit" id="submitButton" disabled>حجز الموعد</button>

    <div id="errorMessage">
        <p>هذه الغرفة غير متاحة في هذا الوقت. يرجى اختيار وقت آخر.</p>
    </div>
</form>

<div id="calendar"></div>

<!-- ربط jQuery و jQuery UI و Timepicker -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-timepicker/1.13.1/jquery.timepicker.min.js"></script>

<script>
    // عند تحميل الصفحة
    $(document).ready(function () {
        // تفعيل التقويم
        $("#date").datepicker({
            dateFormat: 'yy-mm-dd',  // تنسيق التاريخ
            minDate: 0,  // لا يسمح بتحديد تاريخ في الماضي
            onSelect: function (dateText, inst) {
                $('#submitButton').prop('disabled', true);  // تعطيل زر الإرسال حتى يتم التحقق من التوافر
                checkAvailability();  // التحقق من التوافر عندما يختار المستخدم تاريخًا
            }
        });

        // تفعيل Timepicker لاختيار الوقت
        $('#appointment_time').timepicker({
            timeFormat: 'HH:mm',  // تنسيق الوقت
            interval: 15,  // كل 15 دقيقة
            minTime: '07:00am',  // وقت البدء
            maxTime: '10:00pm',  // وقت النهاية
            dynamic: false,  // عدم تغيير الوقت عند تمرير الماوس
            dropdown: true,  // إظهار الوقت في قائمة منسدلة
            scrollbar: true  // إظهار شريط التمرير
        });

        // استماع لتغيير الحقول الأخرى
        $("#appointmentForm").on("change", function () {
            checkAvailability();  // التحقق من التوافر عند تغيير الحقول
        });

        // دالة للتحقق من توافر الموعد
        function checkAvailability() {
            const date = $("#date").val();
            const time = $("#appointment_time").val();
            const room = $("#room").val();

            if (date && time && room) {
                $.ajax({
                    type: 'POST',
                    url: 'check_availability.php',
                    data: {
                        date: date,
                        time: time,
                        room: room
                    },
                    success: function (response) {
                        if (response.trim() === 'available') {
                            $("#errorMessage").hide();
                            $('#submitButton').prop('disabled', false);  // تمكين زر الإرسال
                        } else {
                            $("#errorMessage").show();
                            $('#submitButton').prop('disabled', true);  // تعطيل زر الإرسال
                        }
                    }
                });
            }
        }
    });
</script>

</body>
</html>
