<?php
// helper للتأمين
if (!function_exists('e')) {
  function e($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
}

// 1) التقاط رقم الهوية من الرابط
$customerId = isset($_GET['customerid']) ? trim($_GET['customerid']) : '';

?>
<div class="tab-pane" id="insuranceclaims">
  <div class="box-body table-responsive no-padding">
    <?php if ($customerId === ''): ?>
      <div class="alert alert-warning" style="margin:15px">
        ❗ الرجاء تمرير رقم الهوية عبر البراميتر <b>customerid</b> في الرابط.
      </div>
    <?php else: ?>
      <?php
      // 2) استعلام شامل: المطالبة + المستفيد + التغطية + التصنيف + تفاصيل الفواتير (مجمعة)
      $sql = "
        SELECT 
            ci.PROVCLAIMNO,
            ci.BENEFICIARYID,
            b.FULLNAME,
            ci.COVERAGEID,
            c.POLICYNUMBER,
            TRIM(
              CASE 
                WHEN c.POLICYHOLDER LIKE '%-%' THEN SUBSTRING_INDEX(c.POLICYHOLDER, '-', -1)
                ELSE c.POLICYHOLDER
              END
            ) AS POLICYHOLDER,
            ccg.COVERAGE_CLASS,                 -- قد يكون متعدد القيم (مجمّع نصيًا)
            ci.BILLABLEPERIODSTART,
            ci.BILLABLEPERIODEND,
            inv.INVOICENO,
            inv.INVOICE_TOTAL                   -- مجموع NET لكل فاتورة
        FROM NPHIES_CLAIMINFO ci
        JOIN (
            SELECT PROVCLAIMNO, INVOICENO, SUM(NET) AS INVOICE_TOTAL
            FROM NPHIES_CLAIMITEM
            GROUP BY PROVCLAIMNO, INVOICENO
        ) inv
          ON inv.PROVCLAIMNO = ci.PROVCLAIMNO
        LEFT JOIN NPHIES_BENEFICIARY b 
          ON b.BENEFICIARYID = ci.BENEFICIARYID
        LEFT JOIN NPHIES_COVERAGE c 
          ON c.COVERAGEID = ci.COVERAGEID
        LEFT JOIN (
            SELECT COVERAGEID, GROUP_CONCAT(DISTINCT VALUE ORDER BY VALUE SEPARATOR ', ') AS COVERAGE_CLASS
            FROM NPHIES_COVERAGE_CLASS
            GROUP BY COVERAGEID
        ) ccg
          ON ccg.COVERAGEID = c.COVERAGEID
        WHERE ci.BENEFICIARYID = :customerid
        ORDER BY ci.BILLABLEPERIODSTART DESC, ci.PROVCLAIMNO, inv.INVOICENO
      ";

      $st = $pdo->prepare($sql);
      $st->execute([':customerid' => $customerId]);
      $rows = $st->fetchAll();

      // 3) تجميع النتائج في PHP: كل مطالبة تحتوي على مجموعة فواتير
      $claims = [];
      $grandTotal = 0;
      $customerName = '';

      foreach ($rows as $r) {
        $claimNo = $r['PROVCLAIMNO'];
        if (!isset($claims[$claimNo])) {
          $claims[$claimNo] = [
            'PROVCLAIMNO'         => $claimNo,
            'BENEFICIARYID'       => $r['BENEFICIARYID'],
            'FULLNAME'            => $r['FULLNAME'],
            'COVERAGEID'          => $r['COVERAGEID'],
            'POLICYNUMBER'        => $r['POLICYNUMBER'],
            'POLICYHOLDER'        => $r['POLICYHOLDER'],
            'COVERAGE_CLASS'      => $r['COVERAGE_CLASS'],
            'BILLABLEPERIODSTART' => $r['BILLABLEPERIODSTART'],
            'BILLABLEPERIODEND'   => $r['BILLABLEPERIODEND'],
            'invoices'            => [],
            'claim_total'         => 0.0,
          ];
        }
        $invNo  = $r['INVOICENO'] === null || $r['INVOICENO'] === '' ? '—' : $r['INVOICENO'];
        $invTot = (float)$r['INVOICE_TOTAL'];

        $claims[$claimNo]['invoices'][] = ['no' => $invNo, 'total' => $invTot];
        $claims[$claimNo]['claim_total'] += $invTot;

        $customerName = $r['FULLNAME'] ?: $customerName;
        $grandTotal  += $invTot;
      }
      ?>

      <div style="padding:15px">
        <h4 style="margin:0 0 10px">مطالبات العميل</h4>
        <div class="text-muted" style="margin-bottom:10px">
          رقم الهوية: <b><?= e($customerId) ?></b>
          <?php if ($customerName): ?> — الاسم: <b><?= e($customerName) ?></b><?php endif; ?>
        </div>
      </div>

      <?php if (empty($claims)): ?>
        <div class="callout callout-info" style="margin:15px">
          لا توجد مطالبات لهذا العميل.
        </div>
      <?php else: ?>
        <table class="table table-hover table-striped">
          <thead>
            <tr>
              <th style="width:60px">#</th>
              <th>رقم المطالبة</th>
              <th>اسم المستفيد</th>
              <th>رقم الوثيقة</th>
              <th>صاحب الوثيقة</th>
              <th>تصنيف التغطية</th>
              <th>بداية الفترة</th>
              <th>نهاية الفترة</th>
              <th>عدد الفواتير</th>
              <th style="text-align:right">إجمالي المطالبة</th>
              <th>تفاصيل الفواتير</th>
            </tr>
          </thead>
          <tbody>
            <?php 
            $i = 1;
            foreach ($claims as $c): 
              $invoiceCount = count($c['invoices']);
            ?>
              <tr>
                <td><?= $i++ ?></td>
                <td><?= e($c['PROVCLAIMNO']) ?></td>
                <td><?= e($c['FULLNAME']) ?></td>
                <td><?= e($c['POLICYNUMBER']) ?></td>
                <td><?= e($c['POLICYHOLDER']) ?></td>
                <td><?= e($c['COVERAGE_CLASS']) ?></td>
                <td><?= e($c['BILLABLEPERIODSTART']) ?></td>
                <td><?= e($c['BILLABLEPERIODEND']) ?></td>
                <td><?= $invoiceCount ?></td>
                <td style="text-align:right"><?= number_format($c['claim_total'], 2) ?></td>
                <td>
                  <details>
                    <summary>عرض الفواتير</summary>
                    <table class="table table-condensed" style="margin:8px 0">
                      <thead>
                        <tr>
                          <th style="width:140px">رقم الفاتورة</th>
                          <th style="text-align:right">إجمالي الفاتورة</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php foreach ($c['invoices'] as $inv): ?>
                          <tr>
                            <td><?= e($inv['no']) ?></td>
                            <td style="text-align:right"><?= number_format($inv['total'], 2) ?></td>
                          </tr>
                        <?php endforeach; ?>
                      </tbody>
                    </table>
                  </details>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
          <tfoot>
            <tr>
              <td colspan="9" style="text-align:left"><b>المجموع الكلي لجميع المطالبات</b></td>
              <td style="text-align:right"><b><?= number_format($grandTotal, 2) ?></b></td>
              <td></td>
            </tr>
          </tfoot>
        </table>
      <?php endif; ?>
    <?php endif; ?>
  </div>
</div>
