<?php
// sessionheaderrecption.php يمكن تضمينه إذا كنت تستخدم جلسات للوصول المحمي
include 'sessionheaderrecption.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$host = "localhost:3306";
$dbname = "acesaudi_site";
$username = "acesaudi_usr";
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

$selected_slots = $_POST['selected_slots'] ?? [];
$patient_id = $_POST['patient_id'] ?? '';
$session_duration = 45; // مدة الجلسة الافتراضية
$daterigestred = date('Y-m-d H:i:s');
$userupsated = 1; // يمكن تعديلها لاحقًا حسب نظام المستخدمين

if (empty($selected_slots) || empty($patient_id)) {
    die("<div class='alert alert-danger'>خطأ: لم يتم تحديد جلسات أو رقم المستفيد.</div>");
}

$total_updated = 0;

foreach ($selected_slots as $slot_id) {
    $stmt = $pdo->prepare("SELECT * FROM bookings WHERE id = ?");
    $stmt->execute([$slot_id]);
    $booking = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$booking) continue;

    $update = $pdo->prepare("UPDATE bookings SET
        patient_id = :patient_id,
        bookingstatus = 'محجوز',
        session_duration = :session_duration,
        daterigestred = :daterigestred,
        userupsated = :userupsated
        WHERE id = :id");

    $update->execute([
        ':patient_id' => $patient_id,
        ':session_duration' => $session_duration,
        ':daterigestred' => $daterigestred,
        ':userupsated' => $userupsated,
        ':id' => $slot_id
    ]);

    if ($update->rowCount()) {
        $total_updated++;
    }
}

?>
<?php include 'sessionheaderrecption.php'; ?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
  <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">
      <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <title>تحديد الفترات</title>
    <style>
        body { font-family: Tahoma; background: #f0f0f0; }
        label, input { display: block; margin: 5px 0; font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease; font-size: large; }
        .slots { margin: 15px 0; }
        .slot { background: #d4edda; padding: 10px; margin: 5px; border-radius: 5px; border: 1px solid #28a745; display: inline-block; }
        .slot input { margin-left: 5px; font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease; font-size: large; }
        button { padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; margin-top: 20px; }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">

<div class="wrapper">


<?php include 'receptionheader.php'; ?>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'receptionsidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenureception.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains ppatient_name content -->
  <div class="content-wrapper">
    <!-- Content Header (Ppatient_name header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="receptiondashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Search By Appoiment</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title" style="font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease;">Filtiration Appoiments Info - فلترة الفترات حسب التاريخ وعدد الجلسات</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">

            <div class="col-md-12" style="text-align: center;">

<div class="container text-center" style="margin-top: 50px;">
    <?php if ($total_updated > 0): ?>
        <div class="alert alert-success">
            ✅ تم تأكيد حجز عدد <strong><?= $total_updated ?></strong> جلسة بنجاح.
        </div>
    <?php else: ?>
        <div class="alert alert-warning">
            ⚠️ لم يتم حجز أي جلسة.
        </div>
    <?php endif; ?>

    <a href="smartcheckavilability.php" class="btn btn-primary">🔙 العودة لاختيار فترات أخرى</a>
</div>


</body>
</html>
