<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>إنشاء فاتورة</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<style>
body{background:#f4f6fb; font-family:Tajawal, Tahoma, Arial;}
.container-box{max-width:1300px; margin:24px auto; background:#fff; border-radius:12px; box-shadow:0 8px 22px rgba(0,0,0,.07); overflow:visible;}
.toolbar{display:flex; justify-content:space-between; gap:10px; padding:12px; border-bottom:1px solid #e9eef7; background:#f7fbfe}
.toolbar .btn{border-radius:8px}
.section{padding:16px 18px}
.card-like{background:#f9fbff; border:1px solid #e6eefc; border-radius:10px; padding:14px}
.form-control, .form-select{border-radius:8px}
.table thead th{background:#f7f7fb; position:sticky; top:0; z-index:1}
.table td, .table th{vertical-align:middle}
.total-box{border:1px dashed #d3d9e8; border-radius:10px; padding:12px; background:#fcfdff}
.total-box .row > div{padding:6px 0}
.badge-soft{background:#edf2ff; color:#3f51b5; border:1px solid #d6e0ff}
/* Autocomplete */
.ac-menu{position:absolute; inset-inline:0 auto; top:100%; z-index:9999; background:#fff; border:1px solid #e6eefc; border-top:none; border-radius:0 0 8px 8px; max-height:260px; overflow:auto; box-shadow:0 8px 18px rgba(0,0,0,.06)}
.ac-menu{position:absolute; top:100%; inset-inline:0 auto; z-index:9999;}
.ac-item{padding:8px 10px; cursor:pointer; display:flex; justify-content:space-between; gap:8px}
.ac-item:hover,.ac-item.active{background:#f4f8ff}
.ac-item .l{display:flex; flex-direction:column}
.ac-item .t{font-weight:600}
.ac-item .s{font-size:12px; color:#6b7a90}
</style>
</head>
<body>

<?php
/** createinvoice.php (fixed & clean) */
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
error_reporting(E_ALL);
ini_set('display_errors', 1);

/* ===== DB ===== */
$have_external_conn = false;
if (file_exists(__DIR__.'/conn.php')) {
  include __DIR__.'/conn.php';
  if (isset($conn) && $conn instanceof mysqli) $have_external_conn = true;
}
if (!$have_external_conn) {
  $conn = new mysqli('localhost','acesaudi_usr','tabfyv-6xiFry-noczak','acesaudi_site');
  if ($conn->connect_error) die('DB connection failed: '.$conn->connect_error);
}
$conn->set_charset('utf8mb4');

/* ===== Ensure tables ===== */
$conn->query("
CREATE TABLE IF NOT EXISTS insurance_invoices (
  id               INT AUTO_INCREMENT PRIMARY KEY,
  invoice_no       VARCHAR(32) NOT NULL,
  invoice_date     DATE NOT NULL,
  issue_date       DATE NULL,
  due_date         DATE NULL,
  payment_terms    INT NULL,
  currency         VARCHAR(8) DEFAULT 'SAR',
  beneficiaryid    VARCHAR(64) NULL,
  documentid       VARCHAR(64) NULL,
  patient_name     VARCHAR(255) NULL,
  orderid          VARCHAR(64) NULL,
  payer_nphies_id  VARCHAR(100) NULL,
  subtotal         DECIMAL(18,2) DEFAULT 0,
  discount_total   DECIMAL(18,2) DEFAULT 0,
  tax_total        DECIMAL(18,2) DEFAULT 0,
  copayment_total  DECIMAL(18,2) DEFAULT 0,
  grand_total      DECIMAL(18,2) DEFAULT 0,
  notes            TEXT NULL,
  created_at       DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

$conn->query("
CREATE TABLE IF NOT EXISTS insurance_invoice_items (
  id            INT AUTO_INCREMENT PRIMARY KEY,
  invoice_id    INT NOT NULL,
  service_id    INT NULL,
  item_desc     VARCHAR(255) NOT NULL,
  item_note     VARCHAR(400) NULL,
  qty           DECIMAL(18,3) DEFAULT 1,
  unit_price    DECIMAL(18,2) DEFAULT 0,
  discount_pct  DECIMAL(9,2) DEFAULT 0,
  tax_pct       DECIMAL(9,2) DEFAULT 0,
  line_net      DECIMAL(18,2) DEFAULT 0,
  line_tax      DECIMAL(18,2) DEFAULT 0,
  line_total    DECIMAL(18,2) DEFAULT 0,
  copayment     DECIMAL(18,2) DEFAULT 0,
  FOREIGN KEY (invoice_id) REFERENCES insurance_invoices(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

/* ===== Helpers ===== */
function esc($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
function gen_invoice_no(mysqli $c): string {
  $r = $c->query("SELECT MAX(CAST(invoice_no AS UNSIGNED)) AS mx FROM insurance_invoices");
  $mx = ($r && ($row=$r->fetch_assoc()) && $row['mx']) ? (int)$row['mx'] : 0;
  return str_pad((string)($mx+1), 5, '0', STR_PAD_LEFT);
}
/* رقم فاتورة من جدول qrcode */
function gen_invoice_no_from_qrcode(mysqli $c): string {
    $sql = "SELECT COALESCE(MAX(idinvoice), 0) AS last_id FROM qrcode";
    $r   = $c->query($sql);
    $mx  = ($r && ($row = $r->fetch_assoc()) && $row['last_id']) ? (int)$row['last_id'] : 0;
    return (string)($mx + 1); // زيادة واحد على آخر رقم
}


/* ===== GET ===== */
$orderid            = trim($_GET['orderid'] ?? '');
$customerid         = trim($_GET['customerid'] ?? '');
$insurancecompanyid = trim($_GET['insurancecompanyid'] ?? '');

/* ===== Beneficiary ===== */
$B = [];
if ($customerid !== '') {
  $sql = "SELECT * FROM NPHIES_BENEFICIARY WHERE BENEFICIARYID = ? OR DOCUMENTID = ? LIMIT 1";
  $st = $conn->prepare($sql);
  $st->bind_param("ss", $customerid, $customerid);
  $st->execute();
  $B = $st->get_result()->fetch_assoc() ?: [];
  $st->close();
}
/* infer payer if not passed */
if ($insurancecompanyid === '' && !empty($B['BENEFICIARYID'])) {
  $sql = "SELECT PAYERNPHIESID FROM NPHIES_COVERAGE
          WHERE BENEFICIARYID = ?
          ORDER BY IFNULL(EXPIRYDATE,'2999-12-31') DESC, COVERAGEID DESC LIMIT 1";
  $st = $conn->prepare($sql);
  $st->bind_param("s", $B['BENEFICIARYID']);
  $st->execute();
  if ($r = $st->get_result()->fetch_assoc()) $insurancecompanyid = (string)$r['PAYERNPHIESID'];
  $st->close();
}

/* ===== Save ===== */
/* ===== Save ===== */
$msg = '';
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['save_invoice'])) {
  $invoice_no    = trim($_POST['invoice_no'] ?? gen_invoice_no_from_qrcode($conn));
  $invoice_date  = trim($_POST['invoice_date'] ?? date('Y-m-d'));
  $issue_date    = trim($_POST['issue_date'] ?? $invoice_date);
  $payment_terms = (int)($_POST['payment_terms'] ?? 0);
  $due_date      = trim($_POST['due_date'] ?? $invoice_date);
  $currency      = trim($_POST['currency'] ?? 'SAR');
  $beneficiaryid = trim($_POST['beneficiaryid'] ?? '');
  $documentid    = trim($_POST['documentid'] ?? '');
  $patient_name  = trim($_POST['patient_name'] ?? '');
  $orderid_post  = trim($_POST['orderid'] ?? '');
  $payer_nphies  = trim($_POST['payer_nphies_id'] ?? '');
  $notes         = trim($_POST['notes'] ?? '');

  $service_id   = $_POST['service_id']   ?? [];
  $item_desc    = $_POST['item_desc']    ?? [];
  $item_note    = $_POST['item_note']    ?? [];
  $qty          = $_POST['qty']          ?? [];
  $unit_price   = $_POST['unit_price']   ?? [];
  $discount_pct = $_POST['discount_pct'] ?? [];
  $tax_pct      = $_POST['tax_pct']      ?? [];
  $copayment    = $_POST['copayment']    ?? [];

  $subtotal=0; $discount_total=0; $tax_total=0; $grand_total=0; $copayment_total=0;
  $lines = [];
  $n = max(count($item_desc), count($qty));
  for ($i=0; $i<$n; $i++) {
    $desc = trim($item_desc[$i] ?? '');
    if ($desc==='') continue;
    $sid   = (int)($service_id[$i] ?? 0);
    $note  = trim($item_note[$i] ?? '');
    $q     = (float)str_replace(',','',$qty[$i] ?? 1);
    $price = (float)str_replace(',','',$unit_price[$i] ?? 0);
    $discP = (float)str_replace(',','',$discount_pct[$i] ?? 0);
    $taxP  = (float)str_replace(',','',$tax_pct[$i] ?? 0);
    $cop   = (float)str_replace(',','',$copayment[$i] ?? 0);

    $line_gross = $q * $price;
    $line_disc  = $line_gross * ($discP/100);
    $line_net   = $line_gross - $line_disc;
    $line_tax   = $line_net * ($taxP/100);
    $line_total = $line_net + $line_tax;

    $subtotal        += $line_net;
    $discount_total  += $line_disc;
    $tax_total       += $line_tax;
    $grand_total     += $line_total;
    $copayment_total += $cop;

    $lines[] = compact('sid','desc','note','q','price','discP','taxP','line_net','line_tax','line_total','cop');
  }

  // أدوات مساعدة صغيرة
$to_dt = function($v){
  if(!$v) return null;
  $v = str_replace('T',' ',$v);
  if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$v)) $v .= ' 00:00:00';
  if (preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}$/',$v)) $v .= ':00';
  $ts = strtotime($v); return $ts ? date('Y-m-d H:i:s', $ts) : null;
};
$nf = function($x){ return number_format((float)$x, 2, '.', ''); };

// تلخيص اسم الخدمة من البنود (اختياري)
$service_names = [];
if (is_array($lines)) {
  foreach ($lines as $ln) {
    $txt = trim((string)($ln['desc'] ?? $ln['code'] ?? ''));
    if ($txt !== '') $service_names[] = mb_substr($txt, 0, 100);
  }
}
$servicename = mb_substr(implode(', ', array_slice(array_unique($service_names), 0, 6)), 0, 500);

// JSON للبنود
$items_json = json_encode($lines ?: [], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);

// حقول مطلوبة/افتراضية
$idqrcode         = trim($_GET['orderid'] ?? '');;   // رقم/كود الفاتورة
$customerid       = (string)($beneficiaryid ?: $documentid ?: '');      // معرّف العميل
$idcustomer       = (string)($documentid ?: $beneficiaryid ?: '');      // رقم هوية/ملف
$customername     = (string)($patient_name ?? '');
$mobile           = (string)($mobile ?? '');                            // إن كان لديك متغير للهاتف
$insurancecomane  = (string)($payer_name ?? '');                        // اسم شركة التأمين (إن وجد)
$insurancecoid    = (string)($payer_nphies ?? '');                      // PAYER NPHIES ID
$invoicestatus    = (string)($invoicestatus ?? 'new');
$userconfirmed    = (string)($userconfirmed ?? 'Finance');
$timeadded        = date('Y-m-d H:i:s');

$issue_dt         = $to_dt($issue_date) ?: $timeadded;
$due_dt           = $to_dt($due_date)   ?: $issue_dt;
$payment_terms    = (string)($payment_terms ?? '');
$currency         = (string)($currency ?? 'SAR');
$payer_nphies_id  = (string)($payer_nphies ?? '');

// الأرقام
$subtotal_d       = (float)($subtotal ?? 0);
$discount_total_d = (float)($discount_total ?? 0);
$tax_total_d      = (float)($tax_total ?? 0);
$copayment_total_d= (float)($copayment_total ?? 0);
$grand_total_d    = (float)($grand_total ?? ($subtotal_d - $discount_total_d + $tax_total_d));

// الأعمدة النصية الثلاثة الظاهرة بالصورة (string)
$totalamountwvat_s = $nf($grand_total_d); // استخدمه كـ (الإجمالي)، عدّله إن رغبت
$s_vat_s          = $nf($tax_total_d);   // قيمة الضريبة
$amountwat_s      = $nf($subtotal_d);    // صافي قبل الضريبة

// ===== INSERT إلى جدول qrcode =====
$sql = "INSERT INTO `qrcode`
        (`idqrcode`,`customerid`,`totalamountwvat`,`vat`,`amountwvat`,`timeadded`,
         `invoicestatus`,`userconfirmed`,`idcustomer`,`customername`,`servicename`,`mobile`,
         `insuranseconame`,`insurancecoid`,`discount_total`,`copayment_total`,`items`,
         `issue_date`,`due_date`,`payment_terms`,`currency`,`payer_nphies_id`,
         `subtotal`,`grand_total`,`notes`)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

$st = $conn->prepare($sql);
if (!$st) die('فشل التحضير (qrcode): '.esc($conn->error));

// 25 بارامترًا: 14 نص + 2 رقم + 6 نص + 2 رقم + 1 نص  => سلسلة الأنواع:
$types = "ssssssssssssssddssssssdds";

$notes_s = (string)($notes ?? '');

if (!$st->bind_param(
  $types,
  $idqrcode, $customerid, $totalamountwvat_s, $s_vat_s, $amountwat_s, $timeadded,
  $invoicestatus, $userconfirmed, $idcustomer, $customername, $servicename, $mobile,
  $insurancecomane, $insurancecoid, $discount_total_d, $copayment_total_d, $items_json,
  $issue_dt, $due_dt, $payment_terms, $currency, $payer_nphies_id,
  $subtotal_d, $grand_total_d, $notes_s
)) {
  die('فشل bind_param (qrcode): '.esc($st->error));
}

if (!$st->execute()) {
  die('خطأ حفظ qrcode: '.esc($st->error));
}

$qrcode_id = $st->insert_id;  // المفتاح التلقائي idinvoice
$st->close();

// بإمكانك الإكمال بعد ذلك بإدراج البنود في insurance_invoice_items كما هو لديك…


  // إدراج رأس الفاتورة
  $sql = "INSERT INTO insurance_invoices
          (invoice_no, invoice_date, issue_date, due_date, payment_terms, currency,
           beneficiaryid, documentid, patient_name, orderid, payer_nphies_id,
           subtotal, discount_total, tax_total, copayment_total, grand_total, notes)
          VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
  $types = "ssssissssssddddds";
  $st = $conn->prepare($sql);
  $st->bind_param(
    $types,
    $invoice_no, $invoice_date, $issue_date, $due_date, $payment_terms, $currency,
    $beneficiaryid, $documentid, $patient_name, $orderid_post, $payer_nphies,
    $subtotal, $discount_total, $tax_total, $copayment_total, $grand_total, $notes
  );
  if (!$st->execute()) die('خطأ حفظ الفاتورة: '.esc($st->error));
  $invoice_id = $st->insert_id;
  $st->close();

  // إدراج البنود
  if (!is_array($lines) || empty($lines)) {
    die('لا توجد بنود لإدراجها.');
  }

  // (اختياري) احذف أي بنود سابقة لنفس الفاتورة لتفادي التكرار
$del = $conn->prepare("DELETE FROM insurance_invoice_items WHERE invoice_id=?");
if ($del) { $tmp_id = (int)$invoice_id; $del->bind_param("i", $tmp_id); $del->execute(); $del->close(); }

// تجهيز الـ INSERT حسب الأعمدة الظاهرة بالصورة
$sql = "INSERT INTO insurance_invoice_items
          (invoice_id, item_desc, qty, unit_price, discount_pct, tax_pct,
           line_net, line_tax, line_total, copayment)
        VALUES (?,?,?,?,?,?,?,?,?,?)";
$st = $conn->prepare($sql);
if (!$st) die('فشل التحضير: '.esc($conn->error));

/*
  الأنواع: i = int, s = string, d = double
  1 int + 1 string + 8 double = 10 أحرف
*/
$types_items = "isdddddddd";

// متغيرات الربط (قيم افتراضية)
$invoice_id_i   = (int)$invoice_id;
$item_desc_s    = '';
$qty_d          = 0.0;
$unit_price_d   = 0.0;
$discount_pct_d = 0.0;
$tax_pct_d      = 0.0;
$line_net_d     = 0.0;
$line_tax_d     = 0.0;
$line_total_d   = 0.0;
$copayment_d    = 0.0;

if (!$st->bind_param(
      $types_items,
      $invoice_id_i, $item_desc_s, $qty_d, $unit_price_d, $discount_pct_d, $tax_pct_d,
      $line_net_d, $line_tax_d, $line_total_d, $copayment_d
)) {
  die('فشل bind_param: '.esc($st->error));
}

// تأكد أن $lines مصفوفة
$lines = is_array($lines) ? $lines : [];

foreach ($lines as $ln) {
  // الوصف: خذه من desc أو code كبديل
  $item_desc_s = (string)($ln['desc'] ?? '');
  if ($item_desc_s === '' && isset($ln['code'])) {
    $item_desc_s = (string)$ln['code'];
  }

  // أرقام أساسية
  $qty_d          = max(0, (float)($ln['q']      ?? 0));
  $unit_price_d   = max(0, (float)($ln['price']  ?? 0));
  $discount_pct_d = max(0, (float)($ln['discP']  ?? 0));
  $tax_pct_d      = max(0, (float)($ln['taxP']   ?? 0));

  // احسب الإجماليات إن لم تُرسل، وإلا استخدم المرسل
  if (!isset($ln['line_net']) || !isset($ln['line_tax']) || !isset($ln['line_total'])) {
    $line_net_d   = round($qty_d * $unit_price_d * (1 - $discount_pct_d / 100), 2);
    $line_tax_d   = round($line_net_d * ($tax_pct_d / 100), 2);
    $line_total_d = round($line_net_d + $line_tax_d, 2);
  } else {
    $line_net_d   = (float)$ln['line_net'];
    $line_tax_d   = (float)$ln['line_tax'];
    $line_total_d = (float)$ln['line_total'];
  }

  $copayment_d = (float)($ln['cop'] ?? 0);

  if (!$st->execute()) {
    die('خطأ حفظ البنود: '.esc($st->error));
  }
}

$st->close();

// رسالة نجاح
$msg = 'تم حفظ الفاتورة بنجاح. رقم الفاتورة: '.esc($invoice_no).' (ID='.(int)$invoice_id.')';
echo '';
}

/* ===== Prefill ===== */
$patient_fullname = $B ? ($B['FULLNAME'] ?: trim(($B['FIRSTNAME'] ?? '').' '.($B['MIDDLENAME'] ?? '').' '.($B['LASTNAME'] ?? ''))) : '';
$beneficiaryid    = $B['BENEFICIARYID'] ?? '';
$documentid       = $B['DOCUMENTID'] ?? '';
$gender           = $B['GENDER'] ?? '';
 $CONTACTNUMBER    = $B['CONTACTNUMBER'] ?? '';
$invoice_no_prefill = gen_invoice_no_from_qrcode($conn);
?>

<form method="post" id="invoiceForm" action="digitalinvoice/digitalqrcode/confirmincuranceinvoice.php">
<input type="hidden" name="payer_nphies_id" id="payer_nphies_id" value="<?=esc($insurancecompanyid)?>">
<div class="container-box">

  <!-- Toolbar -->
  <div class="toolbar">
    <div class="btn-group">
      
      <button type="submit" name="save_invoice" class="btn btn-success" formaction="digitalinvoice/digitalqrcode/confirmincuranceinvoice.php">حفظ دون طباعة</button>

   <!--   <button type="button" class="btn btn-primary" onclick="passInvoice()">اعتماد الفاتورة الضريبية</button>
      <button type="button" class="btn btn-outline-secondary" onclick="window.print()">معاينة الفاتورة</button> -->
    </div>
    <div>
      <span class="badge badge-soft">الطلب # <?=esc($orderid)?></span>
      <?php if ($beneficiaryid): ?><span class="badge badge-soft">Beneficiary: <?=esc($beneficiaryid)?></span><?php endif; ?>
      <?php if ($documentid): ?><span class="badge badge-soft">ID: <?=esc($documentid)?></span><?php endif; ?>
      <?php if ($insurancecompanyid): ?><span class="badge badge-soft">Payer: <?=esc($insurancecompanyid)?></span><?php endif; ?>
    </div>
  </div>

  <!-- Invoice header -->
  <div class="section">
    <div class="row g-3">
      <div class="col-md-6">
        <div class="card-like h-100">
          <div class="row g-3">
            <div class="col-md-4"><label class="form-label">رقم الفاتورة</label>
              <input class="form-control" name="invoice_no" value="<?= esc($invoice_no_prefill) ?>" required></div>
            <div class="col-md-4"><label class="form-label">تاريخ الفاتورة</label>
              <input type="date" class="form-control" name="invoice_date" value="<?=esc(date('Y-m-d'))?>" required></div>
            <div class="col-md-4"><label class="form-label">تاريخ الإصدار</label>
              <input type="date" class="form-control" name="issue_date" value="<?=esc(date('Y-m-d'))?>"></div>
            <div class="col-md-4"><label class="form-label">شروط الدفع (أيام)</label>
              <input type="number" min="0" class="form-control" name="payment_terms" id="payment_terms" value="0"></div>
            <div class="col-md-4"><label class="form-label">تاريخ الاستحقاق</label>
              <input type="date" class="form-control" name="due_date" id="due_date" value="<?=esc(date('Y-m-d'))?>"></div>
            <div class="col-md-4"><label class="form-label">العملة</label>
              <select class="form-select" name="currency"><option value="SAR">SAR</option></select></div>
            <div class="col-12"><label class="form-label">ملاحظات</label>
              <input class="form-control" name="notes" placeholder="ملاحظات إضافية (مواطن فاتورة ضريبية صفرية)"></div>
          </div>
        </div>
      </div>

      <!-- Patient card -->
      <div class="col-md-6">
        <div class="card-like h-100">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <div class="fw-bold">المستفيد *</div>
            <a href="#" onclick="return false;">تعديل البيانات</a>
          </div>
          <div class="row g-3">
            <div class="col-md-8"><input class="form-control" name="patient_name" value="<?=esc($patient_fullname)?>" placeholder="اسم المستفيد" required></div>
            <div class="col-md-4">
              <input class="form-control" name="mobile" value="<?=esc($CONTACTNUMBER)?>" placeholder="جوال المستفيد" required>
            </div>
            
            <div class="col-md-4"><label class="form-label">رقم الهوية</label>
              <input class="form-control" name="beneficiaryid" value="<?=esc($beneficiaryid)?>"></div>
            <div class="col-md-4"><label class="form-label">رقم الملف الموحد</label>
              <input class="form-control" name="documentid" value="<?=esc($documentid)?>"></div>
            <div class="col-md-4"><label class="form-label">رقم الطلب</label>
              <input class="form-control" name="orderid" value="<?=esc($orderid)?>"></div>

          <div class="col-md-12">
            <label class="form-label">شركة التأمين</label><br>
              <select name="payer_name" style="line-height: 68px;height: 36px;width: 100%;">
                <option value="شركة الدرع العربي للتأمين" name="payer_name">شركة الدرع العربي للتأمين</option>
                <option value="شركة بوبا للتأمين" name="payer_name">شركة بوبا للتأمين</option>
                <option value="شركة ميد غلف للتأمين" name="payer_name">شركة ميد غلف للتأمين</option>
                <option value=" شركة التعاونية للتأمين" name="payer_name">شركة التعاونية للتأمين</option>
                <option value="شركة ملاذ للتأمين" name="payer_name">شركة ملاذ للتأمين</option>
                <option value="شركة الصقر للتأمين" name="payer_name">شركة الصقر للتأمين</option>
                <option value="شركة تكافل الراجحي للتأمين" name="payer_name">شركة تكافل الراجحي للتأمين</option>
                <option value="شركة ملاذ للتأمين" name="payer_name">شركة ملاذ للتأمين</option>
                <option value="شركة اتحاد الخليج للتأمين" name="payer_name">شركة اتحاد الخليج للتأمين</option>
                <option value="شركة التأمين التعاوني للتأمين" name="payer_name">شركة التأمين التعاوني للتأمين</option>
                <option value="الشركة الخليجية العامة للتأمين التعاوني" name="payer_name">الشركة الخليجية العامة للتأمين التعاوني</option>
                <option value="الشركة العناية الشاملة للتأمين" name="payer_name">الشركة العناية الشاملة للتأمين </option>
              </select>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Items table -->
  <div class="section">
    <div class="table-responsive">
      <table class="table table-bordered align-middle" id="itemsTable">
        <thead>
          <tr>
            <th style="width:40px"></th>
            <th style="min-width:220px">اسم البند (بحث بالاسم/الكود)</th>
            <th style="min-width:160px">الوصف</th>
            <th style="width:100px">الكمية</th>
            <th style="width:140px">سعر الوحدة</th>
            <th style="width:100px">الخصم %</th>
            <th style="width:100px">الضريبة %</th>
            <th style="width:150px">Copayment</th>
            <th style="width:160px">الإجمالي</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><button type="button" class="btn btn-sm btn-outline-danger" onclick="removeRow(this)">–</button></td>
            <td class="ac-wrap" style="position:relative;">
  <input class="form-control service-autocomplete" name="item_desc[]" placeholder="اكتب اسم/كود الخدمة" autocomplete="off">
  <input type="hidden" name="service_id[]">
  <div class="ac-menu" style="display:none;"></div>
</td>

            <td><input class="form-control item-note" name="item_note[]" placeholder="الوصف (اختياري)"></td>
            <td><input type="number" step="0.001" min="0" class="form-control qty" name="qty[]" value="1"></td>
            <td><input type="number" step="0.01"  min="0" class="form-control unit_price" name="unit_price[]" value="0"></td>
            <td><input type="number" step="0.01"  min="0" class="form-control discount_pct" name="discount_pct[]" value="0"></td>
            <td><input type="number" step="0.01"  min="0" class="form-control tax_pct" name="tax_pct[]" value="0"></td>
            <td><input type="number" step="0.01"  min="0" class="form-control copayment" name="copayment[]" value="0"></td>
            <td class="line_total text-nowrap">0.00</td>
          </tr>
        </tbody>
      </table>
    </div>

    <div class="d-flex justify-content-between">
      <button type="button" class="btn btn-outline-primary" onclick="addRow()">إضافة</button>
      <div class="total-box" style="min-width:320px">
        <div class="row">
          <div class="col-6">الإجمالي (قبل الضريبة)</div><div class="col-6 text-end"><span id="subtotal">0.00</span></div>
          <div class="col-6">إجمالي الخصم</div><div class="col-6 text-end"><span id="discount_total">0.00</span></div>
          <div class="col-6">إجمالي الضريبة</div><div class="col-6 text-end"><span id="tax_total">0.00</span></div>
          <div class="col-6 fw-bold">الإجمالي</div><div class="col-6 text-end fw-bold"><span id="grand_total">0.00</span></div>
          <div class="col-6">Copayment Total</div><div class="col-6 text-end"><span id="copayment_total">0.00</span></div>
        </div>
      </div>
    </div>
  </div>

</div>
</form>

<?php if ($msg): ?>
  <div class="container mt-3"><div class="alert alert-success"><?=esc($msg)?></div></div>
<?php endif; ?>

<script>
/* ===== Dates ===== */
const terms = document.getElementById('payment_terms');
const due   = document.getElementById('due_date');
const invDate = document.querySelector('input[name="invoice_date"]');
function recomputeDue(){ const d = new Date(invDate.value || new Date()); const t = parseInt(terms.value||0,10); d.setDate(d.getDate()+t); due.value = d.toISOString().slice(0,10); }
terms.addEventListener('input', recomputeDue); invDate.addEventListener('change', recomputeDue);

/* ===== Math ===== */
function toNum(v){ return parseFloat(v||0) || 0; }
function fmt(v){ return (Math.round(v*100)/100).toFixed(2); }
function recalc(){
  let subtotal=0, discount_total=0, tax_total=0, grand_total=0, copayment_total=0;
  document.querySelectorAll('#itemsTable tbody tr').forEach(tr=>{
    const q   = toNum(tr.querySelector('.qty').value);
    const up  = toNum(tr.querySelector('.unit_price').value);
    const dp  = toNum(tr.querySelector('.discount_pct').value);
    const tp  = toNum(tr.querySelector('.tax_pct').value);
    const cop = toNum(tr.querySelector('.copayment').value);
    const gross = q*up, disc=gross*(dp/100), net=gross-disc, tax=net*(tp/100), total=net+tax;
    subtotal+=net; discount_total+=disc; tax_total+=tax; grand_total+=total; copayment_total+=cop;
    tr.querySelector('.line_total').textContent = fmt(total);
  });
  document.getElementById('subtotal').textContent=fmt(subtotal);
  document.getElementById('discount_total').textContent=fmt(discount_total);
  document.getElementById('tax_total').textContent=fmt(tax_total);
  document.getElementById('grand_total').textContent=fmt(grand_total);
  document.getElementById('copayment_total').textContent=fmt(copayment_total);
}
function addRow(){
  const tr = document.querySelector('#itemsTable tbody tr').cloneNode(true);
  tr.querySelectorAll('input').forEach(i=>{
    if (i.name==='item_desc[]' || i.name==='item_note[]') i.value='';
    else if (i.classList.contains('qty')) i.value = 1;
    else i.value = 0;
  });
  tr.querySelector('.line_total').textContent = '0.00';
  document.querySelector('#itemsTable tbody').appendChild(tr);
  hookRow(tr);
  recalc();
}
function removeRow(btn){
  const tbody=document.querySelector('#itemsTable tbody');
  if (tbody.rows.length>1){ btn.closest('tr').remove(); recalc(); }
}

/* ===== Autocomplete ===== */
const SERVICE_API = 'api/search_services.php'; // عدّل المسار إن كان في مجلد آخر
const payerFilter = document.getElementById('payer_nphies_id')?.value.trim() || '';
const MIN_CHARS   = 1;
const AC_DEBUG    = false;                                   // اجعله true لترى Logs

function escHtml(s){ return (s||'').replace(/[&<>"']/g,m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m])); }

function setupAutocomplete(input){
  const wrap = input.closest('.ac-wrap') || input.parentElement;
  let menu = wrap.querySelector('.ac-menu');
  if (!menu){ menu = document.createElement('div'); menu.className='ac-menu'; wrap.appendChild(menu); }

  const row   = input.closest('tr');
  const hid   = row.querySelector('input[name="service_id[]"]');
  const note  = row.querySelector('.item-note');
  const price = row.querySelector('.unit_price');

  let timer=null, idx=-1, items=[];

  function hide(){ menu.style.display='none'; menu.innerHTML=''; idx=-1; }
  function show(){ menu.style.display='block'; }
  function highlight(){
    menu.querySelectorAll('.ac-item').forEach((d,i)=>d.classList.toggle('active', i===idx));
    const a = menu.querySelector('.ac-item.active'); if (a) a.scrollIntoView({block:'nearest'});
  }
  function render(list){
    items = list || [];
    if (!items.length){ hide(); return; }
    menu.innerHTML = items.map((it,i)=>`
      <div class="ac-item" data-i="${i}">
        <div class="l">
          <div class="t">${escHtml(it.name_ar || it.name_en || it.code || '—')}</div>
          <div class="s">
            ${it.name_en?escHtml(it.name_en):''}
            ${it.code?' • '+escHtml(it.code):''}
            ${it.non_code?' • '+escHtml(it.non_code):''}
            ${it.specialty?' • '+escHtml(it.specialty):''}
          </div>
        </div>
        <div class="r s">${Number(it.price||0).toFixed(2)}</div>
      </div>`).join('');
    show();
    idx = 0;                     // اختر أول عنصر تلقائيًا
    highlight();
  }
  function pick(i){
    const it = items[i]; if (!it) return;
    input.value = it.name_ar || it.name_en || it.code || '';
    if (hid)   hid.value   = it.service_id || '';
    if (price) price.value = Number(it.price||0).toFixed(2);
    if (note)  note.value  = it.desc || it.name_en || '';
    hide(); if (typeof recalc === 'function') recalc();
  }

  async function triggerSearch(q){
    try{
      // المحاولة 1: مع فلتر شركة التأمين (لو موجود)
      let url = `${SERVICE_API}?q=${encodeURIComponent(q)}${payerFilter?`&insurancecompanyid=${encodeURIComponent(payerFilter)}`:''}`;
      let res = await fetch(url); let js = await res.json();
      if (AC_DEBUG) console.log('AC query (with payer):', url, js);

      // المحاولة 2 (fallback): بدون فلتر الشركة إذا رجع صفر نتائج
      if ((!js.results || !js.results.length) && payerFilter){
        url = `${SERVICE_API}?q=${encodeURIComponent(q)}`;
        res = await fetch(url); js = await res.json();
        if (AC_DEBUG) console.log('AC fallback (no payer):', url, js);
      }
      render(js.results || []);
    }catch(e){
      if (AC_DEBUG) console.error('AC error', e);
      hide();
    }
  }

  input.addEventListener('input', ()=>{
    const q = input.value.trim();
    if (hid) hid.value = '';
    if (q.length < MIN_CHARS){ hide(); return; }
    clearTimeout(timer);
    timer = setTimeout(()=> triggerSearch(q), 150);
  });

  // ابدأ بحثًا عند التركيز إن كان هناك نص بالحقل
  input.addEventListener('focus', ()=>{
    const q = input.value.trim();
    if (q.length >= MIN_CHARS) triggerSearch(q);
  });

  input.addEventListener('keydown', (e)=>{
    const open = (menu.style.display === 'block');
    if (!open) return;
    const max = menu.querySelectorAll('.ac-item').length - 1;
    if (e.key === 'ArrowDown'){ idx = Math.min(max, idx+1); highlight(); e.preventDefault(); }
    else if (e.key === 'ArrowUp'){ idx = Math.max(0, idx-1); highlight(); e.preventDefault(); }
    else if (e.key === 'Enter' || e.key === 'Tab'){ if (idx>=0){ pick(idx); e.preventDefault(); } }
    else if (e.key === 'Escape'){ hide(); }
  });

  menu.addEventListener('mousedown', (e)=>{
    const el = e.target.closest('.ac-item'); if (el) pick(parseInt(el.dataset.i,10));
  });

  document.addEventListener('click', (e)=>{ if (!wrap.contains(e.target)) hide(); });
}

// اربط الصف الموجود حاليًا وأي صف يُضاف لاحقًا
function hookRow(tr){
  ['qty','unit_price','discount_pct','tax_pct','copayment'].forEach(cls=>{
    tr.querySelector('.'+cls).addEventListener('input', recalc);
  });
  const inp = tr.querySelector('.service-autocomplete'); if (inp) setupAutocomplete(inp);
}
document.querySelectorAll('#itemsTable tbody tr').forEach(hookRow);

/* ===== تمرير جميع بيانات الفاتورة كـ JSON ===== */
function toNum(v){ return parseFloat((v??'').toString().replace(/,/g,'')) || 0; }
function fmt(v){ return (Math.round(v*100)/100).toFixed(2); }

function gatherInvoiceData(){
  const f = document.getElementById('invoiceForm');
  const get = n => (f.querySelector(`[name="${n}"]`)?.value ?? '').trim();

  // رأس الفاتورة
  const inv = {
    invoice_no:     get('invoice_no'),
    invoice_date:   get('invoice_date'),
    issue_date:     get('issue_date'),
    due_date:       get('due_date'),
    payment_terms:  toNum(get('payment_terms')),
    currency:       get('currency'),
    beneficiaryid:  get('beneficiaryid'),
    documentid:     get('documentid'),
    patient_name:   get('patient_name'),
    orderid:        get('orderid'),
    payer_nphies_id:get('payer_nphies_id'),
    payer_name:     get('company'),     // من القائمة المنسدلة
    notes:          get('notes')
  };

  // البنود
  const items = [];
  let subtotal=0, discount_total=0, tax_total=0, grand_total=0, copayment_total=0;

  document.querySelectorAll('#itemsTable tbody tr').forEach(tr=>{
    const desc   = tr.querySelector('[name="item_desc[]"]')?.value?.trim() || '';
    if (!desc) return; // تجاهل الصف الخالي

    const item = {
      service_id:   toNum(tr.querySelector('[name="service_id[]"]')?.value),
      item_desc:    desc,
      item_note:    tr.querySelector('[name="item_note[]"]')?.value?.trim() || '',
      qty:          toNum(tr.querySelector('[name="qty[]"]')?.value),
      unit_price:   toNum(tr.querySelector('[name="unit_price[]"]')?.value),
      discount_pct: toNum(tr.querySelector('[name="discount_pct[]"]')?.value),
      tax_pct:      toNum(tr.querySelector('[name="tax_pct[]"]')?.value),
      copayment:    toNum(tr.querySelector('[name="copayment[]"]')?.value)
    };

    const gross = item.qty * item.unit_price;
    const disc  = gross * (item.discount_pct/100);
    const net   = gross - disc;
    const tax   = net * (item.tax_pct/100);
    const total = net + tax;

    item.line_net   = +fmt(net);
    item.line_tax   = +fmt(tax);
    item.line_total = +fmt(total);

    subtotal        += net;
    discount_total  += disc;
    tax_total       += tax;
    grand_total     += total;
    copayment_total += item.copayment;

    items.push(item);
  });

  const totals = {
    subtotal:        +fmt(subtotal),
    discount_total:  +fmt(discount_total),
    tax_total:       +fmt(tax_total),
    grand_total:     +fmt(grand_total),
    copayment_total: +fmt(copayment_total),
    vat_rate:        subtotal>0 ? ((tax_total/subtotal*100).toFixed(2)+'%') : ''
  };

  return { invoice: inv, items, totals };
}

// يرسل البيانات إلى سكربت الاستقبال (POST JSON)
async function passInvoice(){
  const payload = gatherInvoiceData();

  // تحقّق بسيط
  if (!payload.items.length){
    alert('لا يوجد بنود في الفاتورة لتمريرها.');
    return;
  }

  try{
    const res = await fetch('pass_invoice.php', {
      method:'POST',
      headers:{'Content-Type':'application/json; charset=utf-8'},
      body: JSON.stringify(payload)
    });
    const js = await res.json();
    if (js.ok){
      alert('تم تمرير البيانات بنجاح ✅\nرقم الفاتورة: ' + (payload.invoice.invoice_no||''));
      // مثال: فتح صفحة معاينة وتمرير رقم الفاتورة عبر GET
      // window.location.href = 'preview_invoice.php?no=' + encodeURIComponent(payload.invoice.invoice_no);
    }else{
      alert('تعذر تمرير البيانات: ' + (js.error||''));
    }
  }catch(e){
    console.error(e);
    alert('خطأ شبكة أثناء تمرير البيانات.');
  }
}

/* (اختياري) زر للنسخ إلى الحافظة أثناء التطوير */
// window.copyInvoiceJSON = () => navigator.clipboard.writeText(JSON.stringify(gatherInvoiceData(), null, 2));

</script>
</body>
</html>
