<?php
// إعداد الاتصال بقاعدة البيانات
$host = "localhost:3306";
$dbname = "acesaudi_site";
$username = "acesaudi_usr";
$password = 'tabfyv-6xiFry-noczak';

$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// أيام الأسبوع بالعربية
$days_ar = [
    'Saturday' => 'السبت',
    'Sunday' => 'الأحد',
    'Monday' => 'الإثنين',
    'Tuesday' => 'الثلاثاء',
    'Wednesday' => 'الأربعاء',
    'Thursday' => 'الخميس',
    'Friday' => 'الجمعة',
];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $month = intval($_POST['month']);
    $year = intval($_POST['year']);
    $room_id = $_POST['room_id'];
    $service_type = $_POST['service_type']; 
    $spclistsname = $_POST['spclistsname']; 
    $period = $_POST['period']; 
    $session_duration = $_POST['session_duration'];
    $spesilstid = $_POST['spesilstid']; 
    $userupsated = $_POST['userupsated'];

    if ($month < 1 || $month > 12 || $year < 2020) {
        die("❌ يرجى إدخال شهر وسنة صحيحة.");
    }

    $start_date = "{$year}-" . str_pad($month, 2, "0", STR_PAD_LEFT) . "-01";
    $end_date = date("Y-m-t", strtotime($start_date));

    // الفترات اليومية
    $slots = [
        ['07:15:00', '08:00:00'],
        ['08:00:00', '08:45:00'],
        ['08:45:00', '09:15:00'],
        ['09:15:00', '10:00:00'],
        ['10:00:00', '10:45:00'],
        ['10:45:00', '11:00:00'],
        ['11:00:00', '11:45:00'],
    ];

    $date = new DateTime($start_date);
    $end = new DateTime($end_date);

    $count = 0;
    while ($date <= $end) {
        $date_str = $date->format("Y-m-d");
        $day_name_en = $date->format("l");
        $day_name_ar = $days_ar[$day_name_en] ?? $day_name_en;

        foreach ($slots as $slot) {
            $stmt = $pdo->prepare("INSERT INTO bookings 
                (booking_date, dayname, time_slot, end_time, bookingstatus, room_id, typeservice, spclistsname, period, session_duration, spesilstid, userupsated)
                VALUES 
                (:booking_date, :dayname, :time_slot, :end_time, 'متوفر', :room_id, :typeservice, :spclistsname, :period, :session_duration, :spesilstid, :userupsated)");
            $stmt->execute([
                ':booking_date' => $date_str,
                ':dayname' => $day_name_ar,
                ':time_slot' => $slot[0],
                ':end_time' => $slot[1],
                ':room_id' => $room_id,
                ':typeservice' => $service_type, 
                ':spclistsname' => $spclistsname,
                ':period' => $period, 
                ':session_duration' => $session_duration,
                ':spesilstid' => $spesilstid, 
                ':userupsated' => $userupsated,
            ]);
            $count++;
        }

        $date->modify('+1 day');
    }

    echo "✅ تم إدخال {$count} فترة في الشهر المحدد بنجاح.";
}
?>


<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>توليد الفترات حسب الشهر</title>
</head>
<body style="direction: rtl; font-family: Tahoma;">
    <h2>توليد الفترات لمدة شهر</h2>
    <form method="POST">
        <label>الشهر (1 إلى 12): <input type="number" name="month" value="8" required></label><br><br>
        <label>السنة: <input type="number" name="year" value="2026" required></label><br><br>
        <label>رقم الغرفة: <input type="text" name="room_id" value="A101" required></label><br><br>
        <label>كود الجلسة: <input type="text" name="service_type" value="ABA" required></label><br><br>
        <label>الأخصائي: <input type="text" name="spclistsname" value="عبدالله الأحمد" required></label><br><br> 
        <label>نوع الخدمة: <input type="text" name="period" value="OP1" required></label><br><br> 
        <label>مدة الفترة: <input type="text" name="session_duration" value="45" required readonly></label><br><br> 
        <label> رقم الأخصائي: <input type="text" name="spesilstid" value="286" required></label><br><br>  
        <label> رقم مستخدم النظام: <input type="text" name="userupsated" value="1" readonly required></label><br><br>
        <button type="submit">توليد الفترات</button>
    </form>
</body>
</html>
