<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | CRM</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
  <style>
        .btn-primary { background:#4CAF50; color:#fff; border-color:#4CAF50; }
        .btn-link { text-decoration: none; margin-right: 10px; }
        .err { background:#ffecec; color:#c00; padding:10px; border:1px solid #f5c2c2; margin-bottom:10px; }
        .muted { color:#666; font-size: 90%; }
    </style>
   
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

<?php include 'financeheader.php'; ?>
 
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'financesidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenufinance.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Edit Insurance Compaies Contract</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Edit Insurance Compaies Contract</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
             
          <?php
/**
 * edit_company.php — Update only (no CSRF)
 * - صفحة واحدة: GET تعرض النموذج، POST تحدّث السجل وتعرض رسالة نجاح.
 * - تعتمد mysqli + prepared statements.
 * - بدون أي redirection لتفادي مشاكل الهيدر.
 */

mb_internal_encoding('UTF-8');
error_reporting(E_ALL);
ini_set('display_errors', '1');

// اجعل mysqli ترمي استثناءات واضحة لتسهيل التشخيص
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// ===== 1) الاتصال بقاعدة البيانات =====
$have_external_conn = false;
if (file_exists(__DIR__ . '/conn.php')) {
    include __DIR__ . '/conn.php';
    if (isset($conn) && $conn instanceof mysqli) {
        $have_external_conn = true;
    }
}

if (!$have_external_conn) {
    // عدّل القيم أدناه لتطابق خادمك
    $servername = "localhost:3306";
    $username   = "acesaudi_usr";
    $password   = "tabfyv-6xiFry-noczak";
    $dbname     = "acesaudi_site";
    $conn = new mysqli($servername, $username, $password, $dbname);
    $conn->set_charset("utf8mb4");
}

// ===== 2) دوال مساعدة =====
function h($s) { return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function num_float($src, $default = 0.0) {
    $v = $_POST[$src] ?? null;
    if ($v === null || $v === '') return (float)$default;
    // إزالة فواصل الآلاف إن وجدت
    $v = str_replace(',', '', $v);
    return is_numeric($v) ? (float)$v : (float)$default;
}
function num_int($src, $default = 0) {
    $v = $_POST[$src] ?? null;
    if ($v === null || $v === '') return (int)$default;
    return (int)$v;
}

// ===== 3) جلب المعرّف =====
$id = 0;
if (isset($_GET['id']))  $id = (int)$_GET['id'];
if (isset($_POST['id'])) $id = (int)$_POST['id'];
if ($id <= 0) { die("معرّف غير صالح."); }

$err = '';
$ok  = false;

try {
    // ===== 4) عند POST: تحديث السجل =====
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $en_name  = trim($_POST['insurancecompanyname'] ?? '');
        $ar_name  = trim($_POST['insurancecomarname']   ?? '');
        $discount = num_float('discount', 0);
        $reject   = num_float('regectedpercentage', 0); // ← اسم الحقل/العمود الصحيح
        $early    = num_float('earlypaypers', 0);
        $size     = num_int  ('sizeworkpers', 0);

        if ($en_name === '' && $ar_name === '') {
            $err = "يجب إدخال اسم الشركة (عربي أو إنجليزي).";
        } else {
            $sql = "UPDATE insurancecompanies
                       SET insurancecompanyname = ?,
                           insurancecomarname  = ?,
                           discount             = ?,
                           regectedpercentage   = ?,
                           earlypaypers         = ?,
                           sizeworkpers         = ?
                     WHERE insurancecompanyid   = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param('ssdddii', $en_name, $ar_name, $discount, $reject, $early, $size, $id);
            $stmt->execute();
            // ملاحظة: حتى لو لم تتغير القيم (affected_rows=0) فهذا ليس خطأ.
            $ok = true;
        }
    }

    // ===== 5) جلب السجل لعرضه في النموذج =====
    $sql = "SELECT insurancecompanyid, insurancecompanyname, insurancecomarname,
                   discount, regectedpercentage, earlypaypers, sizeworkpers, registreddate
            FROM insurancecompanies
            WHERE insurancecompanyid = ?
            LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res->fetch_assoc();
    if (!$row) { die("السجل غير موجود."); }

    // إن حصل خطأ إدخال، نُعيد إظهار ما أرسله المستخدم؛ وإلا نعرض القيم الأصلية
    $val_en   = $_POST['insurancecompanyname'] ?? $row['insurancecompanyname'];
    $val_ar   = $_POST['insurancecomarname']   ?? $row['insurancecomarname'];
    $val_disc = $_POST['discount']             ?? $row['discount'];
    $val_rej  = $_POST['regectedpercentage']   ?? $row['regectedpercentage'];
    $val_ea   = $_POST['earlypaypers']         ?? $row['earlypaypers'];
    $val_sz   = $_POST['sizeworkpers']         ?? $row['sizeworkpers'];
    $val_dt   = $row['registreddate'];

} catch (mysqli_sql_exception $e) {
    $err = "خطأ قاعدة البيانات: " . $e->getMessage();
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>تحديث شركة التأمين</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
 body{font-family:Tahoma,Arial;line-height:1.9}
 .notice{padding:12px;border-radius:8px;margin-bottom:16px}
 .ok{background:#e6ffed;border:1px solid #b7ebc6;color:#096d2a}
 .err{background:#fff1f0;border:1px solid #ffa39e;color:#a8071a}
 .row{display:flex;gap:12px}
 .col{flex:1}
 label{display:block;margin-top:6px}
 .form-control{width:100%;padding:10px;border:1px solid #ccc;border-radius:6px;margin:6px 0}
 .btn{padding:10px 16px;border-radius:8px;border:0;cursor:pointer}
 .btn-primary{background:#007bff;color:#fff}
 .btn-link{background:transparent;color:#007bff;text-decoration:none}
</style>
</head>
<body>

<h2 style="text-align:center;">تحديث بيانات شركة التأمين #<?php echo h($id); ?></h2>

<?php if ($ok): ?>
    <div class="notice ok" style="text-align: center;">تم حفظ التعديلات بنجاح.</div>
<?php endif; ?>

<?php if (!empty($err)): ?>
    <div class="notice err"><?php echo h($err); ?></div>
<?php endif; ?>

<form method="post" action="" style="text-align: center;">
    <input type="hidden" name="id" value="<?php echo h($id); ?>">

    <label>اسم الشركة (EN)</label>
    <input type="text" name="insurancecompanyname" value="<?php echo h($val_en ?? ''); ?>" class="form-control" placeholder="AlRajhi Takaful">

    <label>اسم الشركة (AR)</label>
    <input type="text" name="insurancecomarname" value="<?php echo h($val_ar ?? ''); ?>" class="form-control" placeholder="تكافل الراجحي">

    <div class="row">
        <div class="col">
            <label>نسبة الخصم </label>
            <input type="number" step="0.01" min="0" name="discount" value="<?php echo h($val_disc ?? '0'); ?>" class="form-control">
        </div>
        <div class="col">
            <label>نسبة الرفض </label>
            <!-- تأكد أن عمودك اسمه regectedpercentage -->
            <input type="number" step="0.01" min="0" name="regectedpercentage" value="<?php echo h($val_rej ?? '0'); ?>" class="form-control">
        </div>
    </div>

    <div class="row">
        <div class="col">
            <label>نسبة الدفع المبكر </label>
            <input type="number" step="0.01" min="0" name="earlypaypers" value="<?php echo h($val_ea ?? '0'); ?>" class="form-control">
        </div>
        <div class="col">
            <label>حجم العمل</label>
            <input type="number" step="1" min="0" name="sizeworkpers" value="<?php echo h($val_sz ?? '0'); ?>" class="form-control">
        </div>
    </div>

    <label>تاريخ التسجيل</label>
    <input type="text" value="<?php echo h($val_dt ?? ''); ?>" readonly class="form-control">

    <p style="margin-top:16px;text-align:center;">
        <button type="submit" class="btn btn-primary">حفظ التعديلات</button> <br>
        <a href="financecontract.php" class="btn btn-link">العودة للقائمة</a>
    </p>
</form>
<br><br>
</body>
</html>
<?php
// اغلاق الاتصال
if (isset($conn) && $conn instanceof mysqli) { $conn->close(); }

     ?>


    </div>

    </div>
  
      

            <!-- /.box-body -->
          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
