<?php
/* ===== تصدير XLSX عبر PhpSpreadsheet (لا تطبع أي شيء قبل الهيدر) ===== */
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');

/* اتصال DB (يجب ألا يطبع conn.php أي شيء إطلاقًا) */
require_once __DIR__ . '/conn.php';

/* PhpSpreadsheet */
require_once __DIR__ . '/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

/* فلاتر */
$date_from = isset($_GET['date_from']) ? trim($_GET['date_from']) : '';
$date_to   = isset($_GET['date_to'])   ? trim($_GET['date_to'])   : '';

/* استعلام موحّد */
function get_invoices_stmt(mysqli $conn, string $date_from, string $date_to): mysqli_stmt {
    $where  = " WHERE 1=1 ";
    $types  = "";
    $params = [];

    if ($date_from !== '') { $where .= " AND DATE(`timeadded`) >= ? "; $types .= "s"; $params[] = $date_from; }
    if ($date_to   !== '') { $where .= " AND DATE(`timeadded`) <= ? "; $types .= "s"; $params[] = $date_to; }

    $sql = "SELECT
                `idinvoice`,`customername`,`customerid`,`vat`,
                `totalamountwvat`,`invoicestatus`,`userconfirmed`,
                `idcustomer`,`timeadded`
            FROM `qrcode`
            {$where}
            ORDER BY `timeadded` DESC";

    $stmt = $conn->prepare($sql);
    if (!$stmt) { http_response_code(500); die('DB prepare error: '.$conn->error); }
    if ($types !== "") { $stmt->bind_param($types, ...$params); }
    if (!$stmt->execute()) { http_response_code(500); die('DB execute error: '.$stmt->error); }
    return $stmt;
}

/* اجلب البيانات إلى مصفوفة (متوافق مع بيئات بلا mysqlnd) */
function fetch_all_assoc(mysqli_stmt $stmt): array {
    $rows = [];
    if (method_exists($stmt, 'get_result')) {
        $res = $stmt->get_result();
        if ($res) $rows = $res->fetch_all(MYSQLI_ASSOC);
    } else {
        $meta = $stmt->result_metadata();
        $row = []; $bind = []; $fields = [];
        while ($f = $meta->fetch_field()) {
            $fields[] = $f->name;
            $row[$f->name] = null;
            $bind[] = &$row[$f->name];
        }
        call_user_func_array([$stmt, 'bind_result'], $bind);
        while ($stmt->fetch()) { $rows[] = array_map(fn($v)=>$v, $row); }
    }
    return $rows;
}

/* لا أي مخرجات قبل الهيدر */
while (function_exists('ob_get_level') && ob_get_level() > 0) { @ob_end_clean(); }

/* جهّز البيانات */
$stmt = get_invoices_stmt($conn, $date_from, $date_to);
$data = fetch_all_assoc($stmt);
$stmt->close();

/* بناء الملف */
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$spreadsheet->getDefaultStyle()->getFont()->setName('Arial')->setSize(11);
$sheet->setRightToLeft(true);

/* عناوين الأعمدة */
$headers = [
    'A1' => 'رقم الفاتورة',
    'B1' => 'اسم المستفيد',
    'C1' => 'مصدر الفاتورة',
    'D1' => 'إجمالي المبلغ',
    'E1' => 'حالة الفاتورة',
    'F1' => 'التاريخ والوقت',
    'G1' => 'رابط العرض (PDF)',
    'H1' => 'رابط التحميل (PDF)',
    'I1' => 'تحصيل الفاتورة',
];
foreach ($headers as $cell => $text) { $sheet->setCellValue($cell, $text); }

/* تعبئة الصفوف */
$base = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://')
      . ($_SERVER['HTTP_HOST'] ?? 'localhost')
      . rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? ''), '/\\') . '/';

$rowNum = 2;
foreach ($data as $r) {
    $id = (int)$r['idinvoice'];
    $pdf  = $base . "digitalinvoice/digitalqrcode/invoices/invoice_{$id}.pdf";
    $dl   = $pdf;
    $conf = $base . "confirmincome.php?idinvoice=" . urlencode((string)$id);

    $sheet->setCellValue("A{$rowNum}", $id);
    $sheet->setCellValue("B{$rowNum}", (string)$r['customername']);
    $sheet->setCellValue("C{$rowNum}", (string)$r['userconfirmed']);
    $sheet->setCellValueExplicit("D{$rowNum}", (float)$r['totalamountwvat'], \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_NUMERIC);
    $sheet->setCellValue("E{$rowNum}", (string)$r['invoicestatus']);
    $sheet->setCellValue("F{$rowNum}", (string)$r['timeadded']);
    $sheet->setCellValue("G{$rowNum}", $pdf);
    $sheet->setCellValue("H{$rowNum}", $dl);
    $sheet->setCellValue("I{$rowNum}", $conf);

    // تنسيق المبلغ كعملة بسيطة
    $sheet->getStyle("D{$rowNum}")->getNumberFormat()->setFormatCode('#,##0.00');

    // روابط قابلة للنقر
    $sheet->getCell("G{$rowNum}")->getHyperlink()->setUrl($pdf);
    $sheet->getCell("H{$rowNum}")->getHyperlink()->setUrl($dl);
    $sheet->getCell("I{$rowNum}")->getHyperlink()->setUrl($conf);

    $rowNum++;
}

/* تزيين الهيدر + حدود بسيطة */
$sheet->getStyle('A1:I1')->getFont()->setBold(true);
$sheet->freezePane('A2');
foreach (range('A','I') as $col) {
    $sheet->getColumnDimension($col)->setAutoSize(true);
}
$sheet->setTitle('Invoices');

/* إخراج XLSX */
$filename = 'invoices_'.date('Y-m-d_H-i-s').'.xlsx';

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'.$filename.'"');
header('Cache-Control: max-age=0');
header('Pragma: public');
header('Expires: 0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
