<?php
require_once('tcpdf/tcpdf.php');
include('conn.php');

// جمع الفلاتر من $_GET مثل الكود السابق
$where = [];
if (!empty($_GET['invoice'])) {
    $invoice = mysqli_real_escape_string($conn, $_GET['invoice']);
    $where[] = "`idinvoice` = '$invoice'";
}
if (!empty($_GET['customer'])) {
    $customer = mysqli_real_escape_string($conn, $_GET['customer']);
    $where[] = "`customername` LIKE '%$customer%'";
}
if (!empty($_GET['from_date'])) {
    $where[] = "`timeadded` >= '{$_GET['from_date']}'";
}
if (!empty($_GET['to_date'])) {
    $where[] = "`timeadded` <= '{$_GET['to_date']}'";
}
$where_sql = count($where) ? 'WHERE ' . implode(' AND ', $where) : '';
$sql = "SELECT * FROM qrcode $where_sql";
$result = mysqli_query($conn, $sql);

// إعداد PDF
$pdf = new TCPDF();
$pdf->AddPage();
$pdf->SetFont('aealarabiya', '', 12); // دعم العربية - تأكد من تركيب الخط

$html = '<h2 style="text-align:center;">التقرير الضريبي</h2>';
$html .= '<table border="1" cellpadding="5"><tr>
<th style="text-align:center;">رقم الفاتورة</th><th style="text-align:center;">المستفيد</th><th style="text-align:center;">الرقم الضريبي - الهوية</th><th style="text-align:center;">الخدمة</th><th style="text-align:center;">الأجمالي بدون ضريبة</th><th style="text-align:center;">الضريبة</th><th style="text-align:center;">الإجمالي</th><th style="text-align:center;">التاريخ</th></tr>';

$total_without_vat = $total_with_vat = $total_vat = 0;

while ($row = mysqli_fetch_assoc($result)) {
    $without_vat = $row['totalamountwvat'] / 115 * 100;
    $vat = $row['vat'];
    $with_vat = $row['totalamountwvat'];
    
    $total_without_vat += $without_vat;
    $total_vat += $vat;
    $total_with_vat += $with_vat;

    $html .= "<tr style='text-align:center;'>
        <td style='text-align:center;'>{$row['idinvoice']}</td>
        <td style='text-align:center;'>" . htmlspecialchars($row['customername'], ENT_QUOTES, 'UTF-8') . "</td>
        <td style='text-align:center;'>" . htmlspecialchars($row['idcustomer'], ENT_QUOTES, 'UTF-8') . "</td>
        <td style='text-align:center;'>" . htmlspecialchars($row['servicename'], ENT_QUOTES, 'UTF-8') . "</td>
        <td style='text-align:center;'>" . number_format($without_vat, 2) . "</td>
        <td style='text-align:center;'>" . number_format($vat, 2) . "</td>
        <td style='text-align:center;'>" . number_format($with_vat, 2) . "</td>
        <td style='text-align:center;'>{$row['timeadded']}</td>
    </tr>";
}

$html .= "<tr style='font-weight:bold;text-align:center;'>
<td colspan='2' style='text-align:center;'>المجاميع</td>
<td style='text-align:center;'></td>
<td style='text-align:center;'></td>
<td style='text-align:center;'></td>
<td style='text-align:center;'>" . number_format($total_without_vat, 2) . "</td>
<td style='text-align:center;'>" . number_format($total_vat, 2) . "</td>
<td style='text-align:center;'>" . number_format($total_with_vat, 2) . "</td>

</tr>";
$html .= "</table>";

$pdf->writeHTML($html, true, false, true, false, '');
$pdf->Output('invoice_report.pdf', 'I');
?>
