<?php
include 'db_connect.php';

$patient_id = isset($_GET['patient_id']) ? $_GET['patient_id'] : '';

$query = "SELECT * FROM bookings";
if ($patient_id) {
    $query .= " WHERE patient_id = ?";
}

$stmt = $conn->prepare($query);

if ($patient_id) {
    $stmt->bind_param("s", $patient_id);
}

$stmt->execute();
$result = $stmt->get_result();

$events = array();

while ($row = $result->fetch_assoc()) {
    $events[] = array(
        'id' => $row['id'],
        'title' => "موعد #" . $row['id'] . " | غرفة: " . $row['room_id'],
        'start' => $row['booking_date'] . " " . $row['time_slot'],
        'end' => $row['booking_date'] . " " . $row['end_time'],
        'patient_id' => $row['patient_id']
    );
}

echo json_encode($events);
?>
