<?php
include('conn.php');

date_default_timezone_set('Asia/Riyadh');

// استقبال البيانات من النموذج
$roomno = isset($_POST['roomno']) ? trim($_POST['roomno']) : '';
$period = isset($_POST['period']) ? trim($_POST['period']) : '';

// تعريف الفترات
$periods = [
    '12-22' => ['start' => '12:00', 'end' => '22:00'],
    '12:30-22' => ['start' => '12:30', 'end' => '22:00'],
    '18-22' => ['start' => '18:00', 'end' => '22:00'],
];

// التحقق من أن الفترة المختارة موجودة
if (!array_key_exists($period, $periods)) {
    echo "<div class='alert alert-danger'>الفترة غير صحيحة</div>";
    exit;
}

$start = $periods[$period]['start'];
$end = $periods[$period]['end'];

// استعلام SQL لإحضار الغرف المتاحة في هذه الفترة
$stmt = $conn->prepare("SELECT idroom, coderoom FROM rooms WHERE available_from <= ? AND available_to >= ? AND status = 'available' AND coderoom LIKE ?");
$likeRoom = "%$roomno%";
$stmt->bind_param("sss", $start, $end, $likeRoom);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo "<div class='row'>";
    while ($row = $result->fetch_assoc()) {
        echo '<div class="col-md-3 text-center">';
        echo '<a href="newappointmentsuperaba.php?roomno=' . $row["coderoom"] . '" class="btn btn-success btn-block" style="margin-bottom: 15px;">';
        echo '<i class="fa fa-calendar-plus-o"></i> الغرفة ' . $row["coderoom"] . '<br>الفترة: ' . $start . ' - ' . $end;
        echo '</a>';
        echo '</div>';
    }
    echo "</div>";
} else {
    echo "<div class='alert alert-warning text-center'>لا توجد غرف متاحة في هذه الفترة.</div>";
}

$stmt->close();
$conn->close();
?>
