<?php
include('conn.php');

// استلام مدخلات الفلترة
$bookingid = $_POST['bookingid'] ?? '';
$patient_name = $_POST['patient_name'] ?? '';
$patient_id = $_POST['patient_id'] ?? '';
$typeservice = $_POST['typeservice'] ?? '';
$bookingstatus = $_POST['bookingstatus'] ?? '';
$from_date = $_POST['from_date'] ?? '';
$to_date = $_POST['to_date'] ?? '';

// بناء شروط البحث
$where = [];

if (!empty($bookingid)) {
    $where[] = "`id` = '" . mysqli_real_escape_string($conn, $bookingid) . "'";
}
if (!empty($patient_name)) {
    $where[] = "`patient_name` LIKE '%" . mysqli_real_escape_string($conn, $patient_name) . "%'";
}
if (!empty($patient_id)) {
    $where[] = "`patient_id` = '" . mysqli_real_escape_string($conn, $patient_id) . "'";
}
if (!empty($typeservice)) {
    $where[] = "`typeservice` LIKE '%" . mysqli_real_escape_string($conn, $typeservice) . "%'";
}
if (!empty($bookingstatus)) {
    $where[] = "`bookingstatus` = '" . mysqli_real_escape_string($conn, $bookingstatus) . "'";
}
if (!empty($from_date) && !empty($to_date)) {
    $where[] = "`booking_date` BETWEEN '" . mysqli_real_escape_string($conn, $from_date) . "' AND '" . mysqli_real_escape_string($conn, $to_date) . "'";
}

$where_sql = '';
if (!empty($where)) {
    $where_sql = "WHERE " . implode(' AND ', $where);
}

// تنفيذ الاستعلام
$query = "SELECT * FROM bookings $where_sql ORDER BY id DESC";
$result = mysqli_query($conn, $query);

// عرض النتائج
$output = '';

if (mysqli_num_rows($result) > 0) {
    $output .= '
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th style="text-align: center;">رقم الموعد</th>
                <th style="text-align: center;">اسم المستفيد</th>
                <th style="text-align: center;">رقم الهوية</th>
                <th style="text-align: center;">الخدمة</th>
                
                <th style="text-align: center;">تاريخ الموعد</th>
                <th style="text-align: center;">الحالة</th>
                <th style="text-align: center;">رقم الغرفة</th>
                <th style="text-align: center;">يبدأ من وقت</th>
                <th style="text-align: center;">ينتهي عند ساعة</th>
                <th style="text-align: center;">عرض</th>
            </tr>
        </thead>
        <tbody>
    ';

    while ($row = mysqli_fetch_assoc($result)) {
        $output .= '
            <tr>
                <td>' . htmlspecialchars($row['id']) . '</td>
                <td>' . htmlspecialchars($row['patient_name']) . '</td>
                <td>' . htmlspecialchars($row['patient_id']) . '</td>
                <td>' . htmlspecialchars($row['typeservice']) . '</td>
                
                <td>' . htmlspecialchars($row['booking_date']) . '</td>
                <td>' . htmlspecialchars($row['bookingstatus']) . '</td>
                <td>' . htmlspecialchars($row['room_id']) . '</td>
                <td>' . htmlspecialchars($row['time_slot']) . '</td>
                <td>' . htmlspecialchars($row['end_time']) . '</td>
                <td>
     <a href="receptionreshcauldeappoiment.php?customerid=' . urlencode($row['patient_id']) . '&appid=' . urlencode($row['id']) . '&patientname=' . urlencode($row['patient_name']) . '&serviceid=' . urlencode($row['service_id']) . '&typeservice=' . urlencode($row['typeservice']) . '" class="btn btn-sm btn-primary">
                     عرض
                    </a>
                </td>
            </tr>
        ';
    }

    $output .= '</tbody></table>';
} else {
    $output .= '<div class="alert alert-warning" role="alert">لا توجد مواعيد مطابقة للبحث.</div>';
}

// طباعة النتائج
echo $output;

?>
