<?php
require 'config.php';

$sql = "SELECT id, typeservice AS title, booking_date, time_slot, end_time, room_id FROM bookings";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$events = [];

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $events[] = [
        'id' => $row['id'],
        'title' => "🔹 [" . $row['id'] . "] " . $row['room_id'] . " : غرفة - " . $row['title'], // إضافة رقم الموعد ورقم الغرفة
        'start' => $row['booking_date'] . 'T' . $row['time_slot'],
        'end' => $row['booking_date'] . 'T' . $row['end_time'],
        'room_id' => $row['room_id'] // إرسال رقم الغرفة كمعلومة إضافية
    ];
}

echo json_encode($events);
?>
