<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | CRM</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
  <style>
        a.btn {padding: 4px 8px; text-decoration: none; border-radius: 4px;}
        .edit {background: #06970C; color: white;}
        .delete {background: #f44336; color: white;}
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

<?php include 'financeheader.php'; ?>
 
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'financesidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenufinance.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Insurance Compaies Contract</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Insurance Compaies Contract</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
             
      <?php
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');

// ===== الاتصال بقاعدة البيانات =====
$servername = "localhost:3306";
$username   = "acesaudi_usr";
$password   = "tabfyv-6xiFry-noczak";
$dbname     = "acesaudi_site";

$conn = new mysqli($servername, $username, $password, $dbname);
$conn->set_charset("utf8mb4");

if ($conn->connect_error) {
    die("فشل الاتصال: " . $conn->connect_error);
}

// ===== حذف سجل (إن وُجد) =====
if (isset($_GET['delete'])) {
    $id = (int) $_GET['delete'];
    $conn->query("DELETE FROM insurancecompanies WHERE insurancecompanyid = $id");
    header("Location: insurance_companies.php");
    exit;
}

// ===== جلب البيانات =====
$sql = "SELECT insurancecompanyid, insurancecompanyname, insurancecomarname,
               discount, regectedpercentage, earlypaypers, sizeworkpers, registreddate
        FROM insurancecompanies
        ORDER BY registreddate DESC";
$res = $conn->query($sql);
$companies = [];
if ($res) {
    while ($row = $res->fetch_assoc()) {
        $companies[] = $row;
    }
}

// ===== في حال طلب التصدير إلى إكسل =====
if (isset($_GET['export']) && $_GET['export'] === 'excel') {
    // تحضير صفوف التصدير
    $rows = [];
    $rows[] = [
        '#','اسم الشركة بالأنجليزي','اسم الشركة بالعربي',
        'نسبة الخصم','نسبة الرفض','نسبة الدفع المبكر',
        'نسبة حجم العمل','تاريخ التسجيل'
    ];
    foreach ($companies as $r) {
        $rows[] = [
            (int)$r['insurancecompanyid'],
            $r['insurancecompanyname'],
            $r['insurancecomarname'],
            $r['discount'],
            $r['regectedpercentage'],
            $r['earlypaypers'],
            $r['sizeworkpers'],
            $r['registreddate'],
        ];
    }

    // إن وُجد PhpSpreadsheet نخرج XLSX، وإلا نصدر XLS تقليدي
    $hasPhpSpreadsheet = false;
    if (file_exists(__DIR__ . '/vendor/autoload.php')) {
        require_once __DIR__ . '/vendor/autoload.php';
        if (class_exists(\PhpOffice\PhpSpreadsheet\Spreadsheet::class)) $hasPhpSpreadsheet = true;
    }

    if ($hasPhpSpreadsheet) {
        // ----- تصدير XLSX -----
        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet()->setTitle('Insurance Companies');

        $r = 1;
        foreach ($rows as $row) {
            $c = 1;
            foreach ($row as $cell) {
                $sheet->setCellValueByColumnAndRow($c, $r, $cell);
                $c++;
            }
            $r++;
        }
        $sheet->getStyle('A1:H1')->getFont()->setBold(true);
        foreach (range('A','H') as $col) $sheet->getColumnDimension($col)->setAutoSize(true);

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; charset=utf-8');
        header('Content-Disposition: attachment; filename="insurance_companies.xlsx"');
        header('Cache-Control: max-age=0');
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit;
    } else {
        // ----- FallBack: XLS (جدول HTML) -----
        header('Content-Type: application/vnd.ms-excel; charset=utf-8');
        header('Content-Disposition: attachment; filename="insurance_companies.xls"');

        echo "<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />";
        echo "<table border='1' style='text-align:center; font-family:Tahoma;'>";
        // العناوين
        echo "<tr>";
        foreach ($rows[0] as $th) {
            echo "<th>" . htmlspecialchars($th, ENT_QUOTES, 'UTF-8') . "</th>";
        }
        echo "</tr>";
        // البيانات
        for ($i=1; $i<count($rows); $i++) {
            echo "<tr>";
            foreach ($rows[$i] as $cell) {
                echo "<td>" . htmlspecialchars((string)$cell, ENT_QUOTES, 'UTF-8') . "</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
        exit;
    }
}
?>
<!-- ===== واجهة العرض ===== -->
<h3 style="text-align: center;">اتفاقيات شركات التأمين</h3>
<br>
<!-- زر التصدير إلى Excel -->
<form method="get" action="export_insurance_companies.php" style="text-align:center; margin-bottom:10px;">
  <button type="submit" name="export" value="excel" class="btn btn-success">
    <i class="fa fa-file-excel-o"></i> تصدير إلى Excel
  </button>
</form>

<table class="table table-bordered" style="text-align: center;">
    <tr>
        <th style="text-align: center;">#</th>
        <th style="text-align: center;">اسم الشركة بالأنجليزي</th>
        <th style="text-align: center;">اسم الشركة بالعربي</th>
        <th style="text-align: center;">نسبة الخصم</th>
        <th style="text-align: center;">نسبة الرفض</th>
        <th style="text-align: center;">نسبة الدفع المبكر</th>
        <th style="text-align: center;">نسبة حجم العمل</th>
        <th style="text-align: center;">تاريخ التسجيل</th>
        <th style="text-align: center;">إجراءات</th>
    </tr>
    <?php foreach($companies as $row): ?>
    <tr>
        <td><?= (int)$row['insurancecompanyid'] ?></td>
        <td><?= htmlspecialchars($row['insurancecompanyname'], ENT_QUOTES, 'UTF-8') ?></td>
        <td><?= htmlspecialchars($row['insurancecomarname'], ENT_QUOTES, 'UTF-8') ?></td>
        <td><?= htmlspecialchars($row['discount'], ENT_QUOTES, 'UTF-8') ?></td>
        <td><?= htmlspecialchars($row['regectedpercentage'], ENT_QUOTES, 'UTF-8') ?></td>
        <td><?= htmlspecialchars($row['earlypaypers'], ENT_QUOTES, 'UTF-8') ?></td>
        <td><?= htmlspecialchars($row['sizeworkpers'], ENT_QUOTES, 'UTF-8') ?></td>
        <td><?= htmlspecialchars($row['registreddate'], ENT_QUOTES, 'UTF-8') ?></td>
        <td>
            <a class="btn edit" href="edit_company.php?id=<?= (int)$row['insurancecompanyid'] ?>">تعديل</a>
            <!-- <a class="btn delete" href="?delete=<?= (int)$row['insurancecompanyid'] ?>" onclick="return confirm('هل أنت متأكد من الحذف؟')">حذف</a> -->
        </td>
    </tr>
    <?php endforeach; ?>
</table>
<?php $conn->close(); ?>


            <!-- /.box-body -->
          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
