<?php
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');

/* ===== اتصال DB ===== */
include 'conn.php';

/* ===== فلاتر التاريخ ===== */
$date_from = isset($_GET['date_from']) ? trim($_GET['date_from']) : '';
$date_to   = isset($_GET['date_to'])   ? trim($_GET['date_to'])   : '';

/* ===== استعلام موحد للجدول/التصدير ===== */
function get_invoices_stmt(mysqli $conn, string $date_from, string $date_to): mysqli_stmt {
    $where = " WHERE 1=1 ";
    $types = "";
    $params = [];

    if ($date_from !== '') { $where .= " AND DATE(`timeadded`) >= ? "; $types .= "s"; $params[] = $date_from; }
    if ($date_to   !== '') { $where .= " AND DATE(`timeadded`) <= ? "; $types .= "s"; $params[] = $date_to; }

    $sql = "SELECT
                `idinvoice`,`customername`,`customerid`,`vat`,
                `totalamountwvat`,`invoicestatus`,`userconfirmed`,
                `idcustomer`,`timeadded`
            FROM `qrcode`
            {$where}
            ORDER BY `timeadded` DESC";
    $stmt = $conn->prepare($sql);
    if ($types !== "") { $stmt->bind_param($types, ...$params); }
    $stmt->execute();
    return $stmt;
}

/* ===== تصدير CSV من الخادم ===== */
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    $stmt = get_invoices_stmt($conn, $date_from, $date_to);
    $res  = $stmt->get_result();

    header('Content-Type: text/csv; charset=utf-8');
    $fname = 'invoices_' . date('Y-m-d_H-i-s') . '.csv';
    header('Content-Disposition: attachment; filename="'.$fname.'"');

    $out = fopen('php://output', 'w');
    fputcsv($out, ['Invoice NO','Name','Issued User','Total Amount','Status','Time & Date','View','Download','Bill Collection']);
    while ($row = $res->fetch_assoc()) {
        $id = (int)$row['idinvoice'];
        $pdf = "digitalinvoice/digitalqrcode/invoices/invoice_{$id}.pdf";
        $confirm = "confirmincome.php?idinvoice=" . urlencode($id);
        fputcsv($out, [
            $row['idinvoice'],
            $row['customername'],
            $row['userconfirmed'],
            $row['totalamountwvat'],
            $row['invoicestatus'],
            $row['timeadded'],
            $pdf,
            $pdf,
            $confirm
        ]);
    }
    fclose($out);
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | Dashboard</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- DataTables + Buttons (Bootstrap 3 skin) -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap.min.css">

  <style>
    .filters { margin:10px 0 15px; }
    .filters .form-group { margin-right:10px; }
    .dt-buttons { margin-bottom:10px; }
    th, td { text-align:center; }
    .label { display:inline-block; min-width:80px; }
  </style>

  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <?php include 'financeheader.php'; ?>

  <aside class="main-sidebar">
    <section class="sidebar">
      <?php include 'financesidepanle.php'; ?>
      <?php include 'searchform.php'; ?>
      <?php include 'navemenufinance.php'; ?>
    </section>
  </aside>

  <div class="content-wrapper">
    <section class="content-header">
      <h1><small></small></h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Invoices</a></li>
      </ol>
    </section>

    <section class="content">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Invoices Info Center</h3>
          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>

        <div class="box-body">
          <div class="box">
            <div class="box-header">
              <!-- فورم الفلاتر -->
              <form class="form-inline filters" method="get">

              <div class="col-md-4">
                 <div class="form-group">
                  <input type="date" name="date_to" class="form-control" style="width: 400px;"
                         value="<?= htmlspecialchars($date_to, ENT_QUOTES, 'UTF-8') ?>">
                         <label>إلى تاريخ</label>
                </div>
                </div>

                <div class="col-md-4">
                 <div class="form-group">
                  <input type="date" name="date_from" class="form-control" style="width: 400px;"
                         value="<?= htmlspecialchars($date_from, ENT_QUOTES, 'UTF-8') ?>">
                         <label>من تاريخ</label>
                </div>
                </div>
               
                
       
               <div class="col-md-4" style="align-items: center;align-content: center;text-align: center;">
                 <button type="submit" class="btn btn-primary"><i class="fa fa-filter"></i> تطبيق الفلتر</button>
                <a href="?" class="btn btn-default"><i class="fa fa-undo"></i> إزالة الفلتر</a>
                <!-- يصدر CSV من الخادم مع نفس الفلاتر 
                <button type="submit" name="export" value="csv" class="btn btn-success">
                  <i class="fa fa-file-excel-o"></i> تصدير CSV (خادم)
                </button>-->
              </form>

              
            </div>
            </div>

            <div class="box-body">
              <div id="example1_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
                <div class="row">
                  <div class="col-sm-12">

                    <table id="example1" class="table table-bordered table-striped dataTable" role="grid">
                      <thead>
                        <tr role="row">
                          <th>Invoice NO.<br>رقم الفاتورة</th>
                          <th>Name<br>المستفيد</th>
                          <th>Issuied User<br>مصدر الفاتورة</th>
                          <th>Total Amount<br>اجمالي المبلغ</th>
                          <th>Status<br>حالة الفاتورة</th>
                          <th>Time & Date<br>الوقت و التاريخ</th>
                          <th>View<br>عرض</th>
                          <th>Download<br>تحميل الفاتورة</th>
                          <th>Bill Collection<br>تحصيل الفاتورة</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                          $stmt = get_invoices_stmt($conn, $date_from, $date_to);
                          $res  = $stmt->get_result();
                          while ($row = $res->fetch_assoc()):
                            $idinvoice  = (int)$row['idinvoice'];
                            $pdfPath    = "digitalinvoice/digitalqrcode/invoices/invoice_{$idinvoice}.pdf";
                            $confirmUrl = "confirmincome.php?idinvoice=" . urlencode($idinvoice);
                        ?>
                        <tr role="row">
                          <td><?= $idinvoice ?></td>
                          <td><?= htmlspecialchars($row['customername'], ENT_QUOTES, 'UTF-8') ?></td>
                          <td><?= htmlspecialchars($row['userconfirmed'], ENT_QUOTES, 'UTF-8') ?></td>
                          <td><?= htmlspecialchars($row['totalamountwvat'], ENT_QUOTES, 'UTF-8') ?></td>
                          <td><span class="label label-success"><?= htmlspecialchars($row['invoicestatus'], ENT_QUOTES, 'UTF-8') ?></span></td>
                          <td><?= htmlspecialchars($row['timeadded'], ENT_QUOTES, 'UTF-8') ?></td>
                          <td>
                            <a href="<?= $pdfPath ?>" target="_blank" class="btn bg-navy margin">
                              <i class="fa fa-folder-open"></i> View PDF
                            </a>
                          </td>
                          <td>
                            <a href="<?= $pdfPath ?>" class="btn bg-navy margin"
                               style="background-color:#605ca8!important;color:#fff;"
                               download="invoice_<?= $idinvoice ?>.pdf">
                              <i class="fa fa-file-pdf-o"></i> Download PDF
                            </a>
                          </td>
                          <td>
                            <a href="<?= $confirmUrl ?>" class="btn bg-navy margin"
                               style="background-color:rgb(17,172,133)!important;color:#fff;">
                              <i class="fa fa-check-circle"></i> Confirm Income
                            </a>
                          </td>
                        </tr>
                        <?php endwhile; ?>
                      </tbody>
                    </table>

                  </div>
                </div>
              </div>
            </div><!-- /.box-body -->
          </div>
        </div><!-- /.box-body -->

        <div class="box-footer">
        </div>
      </div><!-- /.box -->
    </section>
  </div><!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <aside class="control-sidebar control-sidebar-dark">
    <!-- (نفس محتوى الكنترول سايدبار عندك) -->
    <div class="tab-content">
      <div class="tab-pane" id="control-sidebar-home-tab"></div>
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <div class="tab-pane" id="control-sidebar-settings-tab"></div>
    </div>
  </aside>
  <div class="control-sidebar-bg"></div>
</div><!-- /.wrapper -->

<!-- سكربتات القالب الأساسية -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script src="bootstrap/js/bootstrap.min.js"></script>
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<script src="plugins/fastclick/fastclick.js"></script>
<script src="dist/js/app.min.js"></script>
<script src="dist/js/demo.js"></script>

<!-- DataTables + Buttons (Bootstrap 3) -->
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap.min.js"></script>

<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>

<script>
$(function () {
  $('#example1').DataTable({
    // ترتيب افتراضي على عمود التاريخ (العمود السادس = index 5)
    order: [[5, 'desc']],
    // تخطيط الأزرار + البحث + الصفحة
    dom: "<'row'<'col-sm-6'B><'col-sm-6'f>>" +
         "<'row'<'col-sm-12'tr>>" +
         "<'row'<'col-sm-5'i><'col-sm-7'p>>",
    buttons: [
      {
        extend: 'excelHtml5',
        className: 'btn btn-success',
        title: 'invoices_' + new Date().toISOString().slice(0,10),
        exportOptions: { columns: ':visible' },
        text: '<i class="fa fa-file-excel-o"></i> تصدير Excel '
      }
    ],
    language: {
      url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/ar.json'
    }
  });
});
</script>
</body>
</html>
