<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>البحث عن موعد متاح</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">البحث عن موعد متاح</h4>
        </div>
        <div class="card-body">
            <form method="POST">
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="roomno">رقم الغرفة</label>
                        <input type="text" class="form-control" id="roomno" name="roomno" placeholder="أدخل رقم الغرفة" value="<?php echo isset($_POST['roomno']) ? htmlspecialchars($_POST['roomno']) : ''; ?>">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="period">اختر الفترة</label>
                        <select class="form-control" id="period" name="period">
                            <option value="">-- اختر الفترة --</option>
                            <option value="12-22" <?php if(isset($_POST['period']) && $_POST['period'] == '12-22') echo 'selected'; ?>>12:00 - 22:00</option>
                            <option value="12:30-22" <?php if(isset($_POST['period']) && $_POST['period'] == '12:30-22') echo 'selected'; ?>>12:30 - 22:00</option>
                            <option value="18-22" <?php if(isset($_POST['period']) && $_POST['period'] == '18-22') echo 'selected'; ?>>18:00 - 22:00</option>
                        </select>
                    </div>
                </div>
                <button type="submit" class="btn btn-success btn-block">بحث</button>
            </form>
        </div>
    </div>

    <div class="mt-4">
<?php
include('conn.php');

date_default_timezone_set('Asia/Riyadh');

$roomno = isset($_POST['roomno']) ? trim($_POST['roomno']) : '';
$period = isset($_POST['period']) ? trim($_POST['period']) : '';

$periods = [
    '12-22' => ['start' => '12:00', 'end' => '22:00'],
    '12:30-22' => ['start' => '12:30', 'end' => '22:00'],
    '18-22' => ['start' => '18:00', 'end' => '22:00'],
];

if (!empty($period)) {
    if (!array_key_exists($period, $periods)) {
        echo "<div class='alert alert-danger'>الفترة غير صحيحة</div>";
    } else {
        $start = $periods[$period]['start'];
        $end = $periods[$period]['end'];

        $stmt = $conn->prepare("SELECT idroom, coderoom FROM rooms WHERE available_from <= ? AND available_to >= ? AND status = 'available' AND coderoom LIKE ?");
        $likeRoom = "%$roomno%";
        $stmt->bind_param("sss", $start, $end, $likeRoom);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            echo "<div class='row'>";
            while ($row = $result->fetch_assoc()) {
                echo '<div class="col-md-3 text-center">';
                echo '<a href="newappointmentsuperaba.php?roomno=' . $row["coderoom"] . '" class="btn btn-success btn-block" style="margin-bottom: 15px;">';
                echo '<i class="fa fa-calendar-plus-o"></i> الغرفة ' . $row["coderoom"] . '<br>الفترة: ' . $start . ' - ' . $end;
                echo '</a>';
                echo '</div>';
            }
            echo "</div>";
        } else {
            echo "<div class='alert alert-warning text-center'>لا توجد غرف متاحة في هذه الفترة</div>";
        }

        $stmt->close();
    }
}

$conn->close();
?>
    </div>
</div>
</body>
</html>
