<?php
require_once('tcpdf/tcpdf.php');

// الاتصال بقاعدة البيانات
$conn = new mysqli("localhost:3306", "acesaudi_usr", 'tabfyv-6xiFry-noczak', "acesaudi_site");
$conn->set_charset("utf8");

if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['idcustomer'])) {
    $id = $_POST['idcustomer'];
    $stmt = $conn->prepare("SELECT id, patient_name, typeservice, room_id, booking_date, time_slot, bookingstatus, notes, end_time FROM bookings WHERE patient_id = ? ORDER BY daterigestred");
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // استخراج اسم المستفيد من أول صف
        $firstRow = $result->fetch_assoc();
        $patientName = $firstRow['patient_name'] ?? '---';
        $result->data_seek(0); // إعادة المؤشر لبداية النتائج

        // إعداد PDF
        $pdf = new TCPDF();
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Clinic System');
        $pdf->SetTitle('Appointment Report');
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);
        $pdf->SetFont('aealarabiya', '', 14);
        $pdf->AddPage();

        // CSS + HTML Header
        $html = "
        <style>
            table {
                border-collapse: collapse;
                width: 100%;
                direction: rtl;
                font-size: 14px;
            }
            th {
                background-color: #d3e0ea;
                color: #000;
                font-weight: bold;
                border: 1px solid #999;
                padding: 6px;
                text-align: center;
            }
            td {
                border: 1px solid #999;
                padding: 5px;
                text-align: center;
            }
            tr:nth-child(even) {
                background-color: #f9f9f9;
            }
            .title {
                text-align: center;
                font-size: 18px;
                font-weight: bold;
                margin-bottom: 10px;
            }
            .idinfo {
                text-align: right;
                font-size: 14px;
                margin-bottom: 10px;
            }
        </style>

        <div class='title'>تقرير وجدول المواعيد للمستفيد</div>
        <div class='idinfo'><strong>" . htmlspecialchars($id) . ": رقم الهوية</strong> | <strong>" . htmlspecialchars($patientName) . " : اسم المستفيد</strong><br></div>

        <table>
            <thead>
                <tr>
                    <th>التاريخ</th>
                    <th>اليوم</th>
                    <th>من الساعة</th>
                    <th>إلى الساعة</th>
                    <th>نوع الخدمة</th>
                    <th>رقم الغرفة</th>
                    <th>الحالة</th>
                    <th>ملاحظات</th>
                </tr>
            </thead>
            <tbody>
        ";

        // ترجمة الأيام للعربية
        $daysArabic = [
            'Saturday'  => 'السبت',
            'Sunday'    => 'الأحد',
            'Monday'    => 'الاثنين',
            'Tuesday'   => 'الثلاثاء',
            'Wednesday' => 'الأربعاء',
            'Thursday'  => 'الخميس',
            'Friday'    => 'الجمعة',
        ];

        while ($row = $result->fetch_assoc()) {
            $date = $row['booking_date'];
            $dayNameEnglish = date('l', strtotime($date));
            $dayArabic = $daysArabic[$dayNameEnglish] ?? 'غير معروف';

            $html .= "<tr>
                        <td>{$date}</td>
                        <td>{$dayArabic}</td>
                        <td>{$row['time_slot']}</td>
                        <td>{$row['end_time']}</td>
                        <td>{$row['typeservice']}</td>
                        <td>{$row['room_id']}</td>
                        <td>{$row['bookingstatus']}</td>
                        <td>{$row['notes']}</td>
                      </tr>";
        }

        $html .= "</tbody></table>";

        $pdf->writeHTML($html, true, false, true, false, '');
        $pdf->Output('appointments.pdf', 'I');
    } else {
        echo "لا توجد مواعيد متاحة لهذا الرقم.";
    }
} else {
    echo "يرجى إدخال رقم هوية صحيح.";
}
?>
