
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Admin ACE | Admin</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the prole_id via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
<?php include 'headeradmin.php'; ?>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'sidebaruserpanel.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenu.php'; ?>

    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains prole_id content -->
  <div class="content-wrapper">
    <!-- Content Header (Prole_id header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">New User</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Add A new User</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
      
            <div class="box-header">
              <h3 class="box-title"> Please Fllow the All Fileds In Below Form</h3>
            </div>
            <!-- /.box-header -->
           <div class="content">
               <div class="row">



<!-- ✅ نموذج الفلترة -->
<form method="POST" style="margin:20px; direction:rtl;">
    <label>اسم المستفيد:</label>
    <input type="text" name="name" placeholder="اكتب اسم المستفيد">

    <label>رقم الملف:</label>
    <input type="text" name="patient_id" placeholder="اكتب رقم الملف">

    <label>الشهر:</label>
    <select name="month">
        <option value="">-- اختر --</option>
        <?php for ($m=1; $m<=12; $m++) echo "<option value='$m'>$m</option>"; ?>
    </select>

    <label>السنة:</label>
    <select name="year">
        <option value="">-- اختر --</option>
        <?php for ($y=date('Y'); $y>=2000; $y--) echo "<option value='$y'>$y</option>"; ?>
    </select>

    <label>من تاريخ:</label>
    <input type="date" name="from_date">

    <label>إلى تاريخ:</label>
    <input type="date" name="to_date">

    <br><br>
    <button type="submit" name="search">🔍 بحث</button>
    <button type="submit" name="export">📄 تصدير PDF</button>
</form>
          <?php
          ob_clean(); // تنظيف المخرجات
ob_start(); // بدء التخزين المؤقت

require_once('tcpdf/tcpdf.php');
// الاتصال بقاعدة البيانات
$conn = new mysqli("localhost", "acesaudi_usr", 'tabfyv-6xiFry-noczak', "acesaudi_site");
$conn->set_charset("utf8");
function getArabicDayName($date) {
    $dayName = date('l', strtotime($date));
    $arabicDays = [
        'Saturday' => 'السبت',
        'Sunday' => 'الأحد',
        'Monday' => 'الاثنين',
        'Tuesday' => 'الثلاثاء',
        'Wednesday' => 'الأربعاء',
        'Thursday' => 'الخميس',
        'Friday' => 'الجمعة'
    ];
    return $arabicDays[$dayName] ?? $dayName;
}
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name       = $_POST['name'] ?? '';
    $patient_id = $_POST['patient_id'] ?? '';
    $month      = $_POST['month'] ?? '';
    $year       = $_POST['year'] ?? '';
    $from_date  = $_POST['from_date'] ?? '';
    $to_date    = $_POST['to_date'] ?? '';
    $export     = isset($_POST['export']);

    $query = "SELECT patient_name, patient_id, typeservice, room_id, booking_date, time_slot, bookingstatus, notes 
              FROM bookings WHERE 1=1";
    $params = [];
    $types = '';
    if (!empty($name)) {
        $query .= " AND patient_name LIKE ?";
        $params[] = "%$name%";
        $types .= 's';
    }
    if (!empty($patient_id)) {
        $query .= " AND patient_id = ?";
        $params[] = $patient_id;
        $types .= 's';
    }
    if (!empty($month) && !empty($year)) {
        $query .= " AND MONTH(booking_date) = ? AND YEAR(booking_date) = ?";
        $params[] = $month;
        $params[] = $year;
        $types .= 'ii';
    }
    if (!empty($from_date) && !empty($to_date)) {
        $query .= " AND booking_date BETWEEN ? AND ?";
        $params[] = $from_date;
        $params[] = $to_date;
        $types .= 'ss';
    } elseif (!empty($from_date)) {
        $query .= " AND booking_date >= ?";
        $params[] = $from_date;
        $types .= 's';
    } elseif (!empty($to_date)) {
        $query .= " AND booking_date <= ?";
        $params[] = $to_date;
        $types .= 's';
    }
    $query .= " ORDER BY booking_date";

    $stmt = $conn->prepare($query);
    if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    if ($export) {
        // ✅ تصدير إلى PDF
        $pdf = new TCPDF();
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Clinic System');
        $pdf->SetTitle('Appointment Report');
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);
        $pdf->SetFont('aealarabiya', '', 14);
        $pdf->AddPage();
        $html = "
        <style>
            table {
                border-collapse: collapse;
                width: 100%;
                direction: rtl;
                font-size: 14px;
            }
            th {
                background-color: #d3e0ea;
                font-weight: bold;
                border: 1px solid #999;
                padding: 6px;
                text-align: center;
            }
            td {
                border: 1px solid #999;
                padding: 5px;
                text-align: center;
            }
            tr:nth-child(even) {
                background-color: #f9f9f9;
            }
            .title {
                text-align: center;
                font-size: 18px;
                font-weight: bold;
                margin-bottom: 10px;
            }
        </style>
        <div class='title'>تقرير وجدول المواعيد</div>
        <table>
            <thead>
                <tr>
                    <th>رقم الملف</th>
                    <th>اسم المستفيد</th>
                    <th>اليوم</th>
                    <th>التاريخ</th>
                    <th>من الساعة</th>
                    <th>إلى الساعة</th>
                    <th>نوع الخدمة</th>
                    <th>الغرفة</th>
                    <th>الحالة</th>
                    <th>الملاحظات</th>
                </tr>
            </thead>
            <tbody>";
        while ($row = $result->fetch_assoc()) {
            $dayArabic = getArabicDayName($row['booking_date']);
            $html .= "<tr>
                        <td>{$row['patient_id']}</td>
                        <td>{$row['patient_name']}</td>
                        <td>{$dayArabic}</td>
                        <td>{$row['booking_date']}</td>
                        <td>{$row['time_slot']}</td>
                        <td>{$row['time_slot']}</td>
                        <td>{$row['typeservice']}</td>
                        <td>{$row['room_id']}</td>
                        <td>{$row['bookingstatus']}</td>
                        <td>{$row['notes']}</td>
                      </tr>";
        }
        $html .= "</tbody></table>";
        $pdf->writeHTML($html, true, false, true, false, '');
        ob_end_clean(); // إلغاء المخرجات قبل إرسال PDF
        $pdf->Output('appointments_filtered.pdf', 'I');
        exit;
    } else {
        // عرض HTML مباشر (اختياري)
        echo "<h3>النتائج:</h3><table border='1' cellpadding='5' cellspacing='0' style='direction: rtl; text-align: center;'>
            <tr>
                <th>رقم الملف</th>
                <th>الاسم</th>
                <th>اليوم</th>
                <th>التاريخ</th>
                <th>الوقت</th>
                <th>الخدمة</th>
                <th>الغرفة</th>
                <th>الحالة</th>
                <th>ملاحظات</th>
            </tr>";
        while ($row = $result->fetch_assoc()) {
            $dayArabic = getArabicDayName($row['booking_date']);
            echo "<tr>
                    <td>{$row['patient_id']}</td>
                    <td>{$row['patient_name']}</td>
                    <td>{$dayArabic}</td>
                    <td>{$row['booking_date']}</td>
                    <td>{$row['time_slot']}</td>
                    <td>{$row['typeservice']}</td>
                    <td>{$row['room_id']}</td>
                    <td>{$row['bookingstatus']}</td>
                    <td>{$row['notes']}</td>
                  </tr>";
        }
        echo "</table>";
    }
}
?>
               </div>
               </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usrole_id
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>