<?php
// اتصال بقاعدة البيانات
$host = "localhost";
$user = "acesaudi_usr";
$password = 'tabfyv-6xiFry-noczak';
$database = "acesaudi_site";

$conn = new mysqli($host, $user, $password, $database);

if ($conn->connect_error) {
    die("فشل الاتصال بقاعدة البيانات: " . $conn->connect_error);
}

// التحقق من استلام المعاملات المطلوبة
if (!isset($_GET['section']) || !isset($_GET['date'])) {
    echo json_encode(["error" => "بيانات غير مكتملة"]);
    exit;
}

$section = $_GET['section'];
$date = $_GET['date'];

// استعلام لجلب الغرف المتاحة
$roomsQuery = "SELECT DISTINCT room_id FROM bookings WHERE booking_date = ? AND period = ? AND bookingstatus != 'confirmed';";
$stmtRooms = $conn->prepare($roomsQuery);
$stmtRooms->bind_param("ss", $date, $section);
$stmtRooms->execute();
$resultRooms = $stmtRooms->get_result();

$rooms = [];
while ($row = $resultRooms->fetch_assoc()) {
    $rooms[] = $row['room_id'];
}
$stmtRooms->close();

// استعلام لجلب الأوقات المتاحة لكل غرفة
$slotsQuery = "SELECT time_slot, room_id FROM bookings WHERE booking_date = ? AND period = ? AND bookingstatus != 'confirmed';";
$stmtSlots = $conn->prepare($slotsQuery);
$stmtSlots->bind_param("ss", $date, $section);
$stmtSlots->execute();
$resultSlots = $stmtSlots->get_result();

$slots = [];
while ($row = $resultSlots->fetch_assoc()) {
    $slots[] = [
        "time" => $row['time_slot'],
        "room" => $row['room_id']
    ];
}
$stmtSlots->close();

// إرجاع البيانات كتنسيق JSON
$response = [
    "rooms" => $rooms,
    "slots" => $slots
];

echo json_encode($response);

$conn->close();
?>
