<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام التقويم</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/5.11.3/main.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/5.11.3/main.min.js"></script>
</head>
<body>

<h2 style="text-align: center;">نظام إدارة المواعيد</h2>
<div id="calendar"></div>

<script>
    $(document).ready(function () {
        let calendarEl = document.getElementById('calendar');

        let calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            editable: true,
            events: 'fetch_events.php', // جلب المواعيد من قاعدة البيانات

            // تحديث الحدث عند السحب والإفلات
            eventDrop: function (info) {
                let id = info.event.id;
                let start = info.event.start.toISOString();
                let end = info.event.end ? info.event.end.toISOString() : start;

                $.ajax({
                    url: 'update_event.php',
                    type: 'POST',
                    data: { id: id, start: start, end: end },
                    success: function (response) {
                        alert("تم تحديث الموعد بنجاح");
                    },
                    error: function () {
                        alert("حدث خطأ أثناء التحديث");
                    }
                });
            }
        });

        calendar.render();
    });
</script>

</body>
</html>
