<?php
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

// ===== CSRF =====
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$CSRF = $_SESSION['csrf_token'];

// ===== DB Connection =====
$have_external_conn = false;
if (file_exists(__DIR__ . '/conn.php')) {
    include __DIR__ . '/conn.php';
    if (isset($conn) && $conn instanceof mysqli) { $have_external_conn = true; }
}
if (!$have_external_conn) {
    // عدّل هذه القيم إذا لم تستخدم conn.php
    $db_host = 'localhost';
    $db_user = 'acesaudi_site';
    $db_pass = 'tabfyv-6xiFry-noczak';
    $db_name = 'acesaudi_usr';
    $db_port = 3306;
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name, $db_port);
}
if ($conn->connect_error) { die('DB Error: ' . htmlspecialchars($conn->connect_error)); }
$conn->set_charset('utf8mb4');

// ===== Toggle Status Action =====
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'toggle') {
    if (!hash_equals($CSRF, $_POST['csrf'] ?? '')) {
        die('<h3 style="color:#b00">CSRF token غير صالح.</h3>');
    }
    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
    if ($id > 0) {
        // اجلب الحالة الحالية
        $cur = $conn->prepare("SELECT FACTOR FROM insuranceservices WHERE service_id=?");
        $cur->bind_param('i', $id);
        $cur->execute();
        $res = $cur->get_result();
        if ($row = $res->fetch_assoc()) {
            $new = ($row['FACTOR'] == 1) ? 0 : 1;
            $upd = $conn->prepare("UPDATE insuranceservices SET FACTOR=? WHERE service_id=?");
            $upd->bind_param('ii', $new, $id);
            $upd->execute();
            $_SESSION['flash_msg'] = ($upd->affected_rows >= 0) ? 'تم تحديث الحالة بنجاح.' : 'لم يتم التغيير.';
        } else {
            $_SESSION['flash_msg'] = 'الخدمة غير موجودة.';
        }
    }
    header('Location: ' . strtok($_SERVER['REQUEST_URI'], '?')); // رجوع لنفس الصفحة بدون بارامترات
    exit;
}

// ===== Filters & Pagination =====
$q          = trim($_GET['q'] ?? '');
$companyId  = trim($_GET['companyid'] ?? '');
$status     = trim($_GET['status'] ?? ''); // '', '1', '0'
$page       = max(1, (int)($_GET['page'] ?? 1));
$per_page   = 20;
$offset     = ($page - 1) * $per_page;

$where = [];
$params = [];
$types  = '';

if ($q !== '') {
    $where[] = "(insurancecopmanyname LIKE CONCAT('%', ?, '%') 
              OR insurancecompanyid LIKE CONCAT('%', ?, '%')
              OR SERVICE_CODE LIKE CONCAT('%', ?, '%')
              OR service_name_ar LIKE CONCAT('%', ?, '%')
              OR service_name_en LIKE CONCAT('%', ?, '%')
              OR specialty LIKE CONCAT('%', ?, '%'))";
    for ($i=0; $i<6; $i++) { $types .= 's'; $params[] = $q; }
}
if ($companyId !== '') {
    $where[] = "insurancecompanyid = ?";
    $types  .= 's';
    $params[] = $companyId;
}
if ($status === '0' || $status === '1') {
    $where[] = "FACTOR = ?";
    $types  .= 'i';
    $params[] = (int)$status;
}

$where_sql = $where ? ('WHERE ' . implode(' AND ', $where)) : '';

// ===== Count total =====
$sql_count = "SELECT COUNT(*) AS c FROM insuranceservices $where_sql";
$stmtc = $conn->prepare($sql_count);
if ($types) { $stmtc->bind_param($types, ...$params); }
$stmtc->execute();
$total = (int)$stmtc->get_result()->fetch_assoc()['c'];
$total_pages = max(1, (int)ceil($total / $per_page));

// ===== Fetch page =====
$sql = "SELECT service_id, insurancecompanyid, insurancecopmanyname, SERVICE_CODE, NON_STANDARD_CODE, SERVICE_TYPE,
               service_name_ar, service_name_en, NON_STANDARD_DESC, UNIT_PRICE, specialty, FACTOR
        FROM insuranceservices
        $where_sql
        ORDER BY service_id DESC
        LIMIT ? OFFSET ?";
$typesp = $types . 'ii';
$params_page = $params;
$params_page[] = $per_page;
$params_page[] = $offset;

$stmt = $conn->prepare($sql);
$stmt->bind_param($typesp, ...$params_page);
$stmt->execute();
$result = $stmt->get_result();

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function price_fmt($v){
    if ($v === null || $v === '') return '';
    if (is_numeric($v)) return number_format((float)$v, 2);
    return h($v);
}

// ===== UI =====
// ====== EXPORT TO EXCEL ======
if (isset($_GET['export']) && $_GET['export'] == '1') {

    header("Content-Type: application/vnd.ms-excel; charset=utf-8");
    header("Content-Disposition: attachment; filename=insuranceservices_" . date("Y-m-d_H-i-s") . ".xls");

    echo "<table border='1'>";
    echo "<tr>
            <th>#</th>
            <th>شركة التأمين</th>
            <th>رقم الشركة</th>
            <th>كود الخدمة</th>
            <th>الكود غير القياسي</th>
            <th>اسم الخدمة عربي</th>
            <th>اسم الخدمة إنجليزي</th>
            <th>السعر</th>
            <th>التخصص</th>
            <th>الحالة</th>
          </tr>";

    // نعيد تنفيذ نفس الاستعلام السابق لكن بدون LIMIT
    $sql_export = "SELECT service_id, insurancecompanyid, insurancecopmanyname, 
                          SERVICE_CODE, NON_STANDARD_CODE, service_name_ar, 
                          service_name_en, UNIT_PRICE, specialty, FACTOR
                   FROM insuranceservices
                   $where_sql
                   ORDER BY service_id DESC";

    $stmt_exp = $conn->prepare($sql_export);
    if ($types) {
        $stmt_exp->bind_param($types, ...$params);
    }
    $stmt_exp->execute();
    $data = $stmt_exp->get_result();

    while ($row = $data->fetch_assoc()) {

        $status_txt = ($row['FACTOR'] == 1) ? "مفعل" : "معطل";

        echo "<tr>";
        echo "<td>{$row['service_id']}</td>";
        echo "<td>".h($row['insurancecopmanyname'])."</td>";
        echo "<td>".h($row['insurancecompanyid'])."</td>";
        echo "<td>".h($row['SERVICE_CODE'])."</td>";
        echo "<td>".h($row['NON_STANDARD_CODE'])."</td>";
        echo "<td>".h($row['service_name_ar'])."</td>";
        echo "<td>".h($row['service_name_en'])."</td>";
        echo "<td>".price_fmt($row['UNIT_PRICE'])."</td>";
        echo "<td>".h($row['specialty'])."</td>";
        echo "<td>{$status_txt}</td>";
        echo "</tr>";
    }

    echo "</table>";
    exit;
}

?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>خدمات التأمين - عرض</title>
<style>
body{font-family:Tahoma,Arial;margin:20px}
.box{border:1px solid #ddd;border-radius:8px;padding:15px}
.table{width:100%;border-collapse:collapse}
.table th,.table td{border:1px solid #eee;padding:8px;vertical-align:top}
.table th{background:#f7f7f7}
.filters input,.filters select{padding:6px;margin-inline-end:6px}
.badge{display:inline-block;padding:2px 8px;border-radius:10px;font-size:12px}
.badge.ok{background:#e7f7ee;color:#0a7a3f;border:1px solid #bfe7cf}
.badge.no{background:#fdecec;color:#a32424;border:1px solid #f6caca}
.actions form{display:inline}
.pagination a, .pagination span{padding:6px 10px;border:1px solid #ddd;margin:2px;text-decoration:none;border-radius:6px}
.pagination .active{background:#333;color:#fff}
.flash{padding:8px 12px;background:#f6ffed;border:1px solid #b7eb8f;color:#135200;border-radius:6px;margin-bottom:10px}
</style>
</head>
<body>

<div class="box">
    <h2>قائمة خدمات التأمين</h2>

    <?php if (!empty($_SESSION['flash_msg'])): ?>
        <div class="flash"><?= h($_SESSION['flash_msg']); unset($_SESSION['flash_msg']); ?></div>
    <?php endif; ?>

    <form method="get" class="filters" style="margin-bottom:10px;">
        <input type="text" name="q" placeholder="بحث (كود/اسم/شركة/تخصص)" value="<?= h($q) ?>" style="width:30%;border-radius: 6px;">
        <input type="text" name="companyid" placeholder="رقم شركة التأمين" value="<?= h($companyId) ?>" style="width:30%;border-radius: 6px;">
        <select name="status">
            <option value="">كل الحالات</option>
            <option value="1" <?= $status==='1'?'selected':''; ?>>مفعل</option>
            <option value="0" <?= $status==='0'?'selected':''; ?>>معطل</option>
        </select>
        <button type="submit">تصفية</button>
        <a href="<?= h($_SERVER['PHP_SELF']); ?>">تفريغ الفلاتر</a>

         <!-- ✅ زر تصدير Excel -->
    <button type="submit" name="export" value="1" style="background:#28a745;color:white;padding:6px 12px;border-radius:6px;">
        تصدير Excel
    </button>

    </form>

    <div style="margin-bottom:8px">النتائج: <?= (int)$total ?> خدمة — صفحة <?= (int)$page ?> من <?= (int)$total_pages ?></div>

    <table class="table">
        <thead>
            <tr>
                <th>#</th>
                <th>شركة التأمين</th>
                <th>كود الخدمة</th>
                <th>اسم الخدمة (ع)</th>
                <th>اسم الخدمة (En)</th>
                <th>السعر</th>
                <th>الفئة</th>
                <th>الحالة</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
        <?php if ($result->num_rows === 0): ?>
            <tr><td colspan="9" style="text-align:center;color:#666">لا توجد بيانات مطابقة.</td></tr>
        <?php else: while($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?= (int)$row['service_id'] ?></td>
                <td>
                    <div><b><?= h($row['insurancecopmanyname']) ?></b></div>
                    <small>ID: <?= h($row['insurancecompanyid']) ?></small>
                </td>
                <td>
                    <div><b><?= h($row['SERVICE_CODE']) ?></b></div>
                    <small><?= h($row['NON_STANDARD_CODE']) ?></small>
                </td>
                <td><?= h($row['service_name_ar']) ?></td>
                <td><?= h($row['service_name_en']) ?></td>
                <td><?= price_fmt($row['UNIT_PRICE']) ?></td>
                <td><?= h($row['specialty']) ?></td>
                <td>
                    <?php if ((int)$row['FACTOR'] === 1): ?>
                        <span class="badge ok">مفعل</span>
                    <?php else: ?>
                        <span class="badge no">معطل</span>
                    <?php endif; ?>
                </td>
                <td class="actions">
                    <a href="service_edit.php?id=<?= (int)$row['service_id'] ?>">تعديل</a>

                    <form method="post" style="display:inline" onsubmit="return confirm('تأكيد تبديل الحالة؟');">
                        <input type="hidden" name="csrf" value="<?= h($CSRF) ?>">
                        <input type="hidden" name="action" value="toggle">
                        <input type="hidden" name="id" value="<?= (int)$row['service_id'] ?>">
                        
                    </form>
                </td>
            </tr>
        <?php endwhile; endif; ?>
        </tbody>
    </table>

    <div class="pagination" style="margin-top:12px">
        <?php
        $base = $_GET; unset($base['page']);
        $base_qs = http_build_query($base);
        $prefix = $_SERVER['PHP_SELF'] . ($base_qs ? ('?'.$base_qs.'&') : '?');
        for ($p=1; $p <= $total_pages; $p++):
            if ($p == $page) {
                echo '<span class="active">'.$p.'</span>';
            } else {
                echo '<a href="'.h($prefix.'page='.$p).'">'.$p.'</a>';
            }
        endfor;
        ?>
    </div>
</div>

</body>
</html>
