<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

// إعداد الاتصال بقاعدة البيانات
$host = 'localhost:3306';
$db   = 'acesaudi_site';
$user = 'acesaudi_usr';
$pass = 'tabfyv-6xiFry-noczak';
$charset = 'utf8mb4';

// الاتصال عبر PDO
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];
try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    die("خطأ في الاتصال: " . $e->getMessage());
}

// استقبال الفلاتر
$fromDate = $_GET['from'] ?? '';
$toDate   = $_GET['to']   ?? '';
$company  = $_GET['company'] ?? '';

$where   = [];
$params  = [];

if ($fromDate !== '' && $toDate !== '') {
    $where[] = "ci.BILLABLEPERIODSTART >= :fromDate AND ci.BILLABLEPERIODEND <= :toDate";
    $params[':fromDate'] = $fromDate;
    $params[':toDate']   = $toDate;
}
if ($company !== '') {
    $where[] = "c.POLICYHOLDER LIKE :company";
    $params[':company'] = "%$company%";
}
$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';

// جلب أسماء الشركات للقائمة
$companiesStmt = $pdo->query("SELECT DISTINCT POLICYHOLDER FROM NPHIES_COVERAGE WHERE POLICYHOLDER IS NOT NULL");
$companies = $companiesStmt->fetchAll(PDO::FETCH_COLUMN);

// الاستعلام الرئيسي
$sql = "
SELECT 
    ci.PROVCLAIMNO,
    ci.BENEFICIARYID,
    b.FULLNAME,
    ci.COVERAGEID,
    c.POLICYNUMBER,
    c.POLICYHOLDER,
    (SELECT cc.VALUE 
       FROM NPHIES_COVERAGE_CLASS cc 
      WHERE cc.COVERAGEID = c.COVERAGEID 
      LIMIT 1) AS COVERAGE_CLASS,
    ci.BILLABLEPERIODSTART,
    ci.BILLABLEPERIODEND,
    it.INVOICENO,
    it.CLAIM_TOTAL
FROM NPHIES_CLAIMINFO ci
JOIN (
    SELECT PROVCLAIMNO, INVOICENO, SUM(NET) AS CLAIM_TOTAL
    FROM NPHIES_CLAIMITEM
    GROUP BY PROVCLAIMNO, INVOICENO
) it ON it.PROVCLAIMNO = ci.PROVCLAIMNO
LEFT JOIN NPHIES_BENEFICIARY b ON ci.BENEFICIARYID = b.BENEFICIARYID
LEFT JOIN NPHIES_COVERAGE c    ON ci.COVERAGEID = c.COVERAGEID
$whereClause
ORDER BY ci.PROVCLAIMNO, it.INVOICENO
";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$results = $stmt->fetchAll();
$totalSum = array_sum(array_column($results, 'CLAIM_TOTAL'));

// ===== فرع التصدير إلى Excel (XLS) =====
if (isset($_GET['export']) && $_GET['export'] === 'excel') {
    // لا تطبع أي شيء قبل هذه الترويسات
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header('Content-Disposition: attachment; filename="claims_report_'.date('Y-m-d_His').'.xls"');

    // BOM لسلامة العربية
    echo "\xEF\xBB\xBF";
    echo "<meta charset='utf-8'>";

    echo "<table border='1' style='border-collapse:collapse;text-align:center;font-family:Tahoma'>";
    echo "<tr><th colspan='10' style='font-size:14px'>Claims Report by Service Period</th></tr>";
    echo "<tr><td colspan='10'>الفترة: ".($fromDate ?: '—')." إلى ".($toDate ?: '—')." — الشركة: ".($company ?: 'جميع الشركات')."</td></tr>";
    echo "<tr><td colspan='10'>&nbsp;</td></tr>";

    echo "<tr style='background:#e9f2ff'>";
    echo "<th>Claim No</th>";
    echo "<th>Invoice No</th>";
    echo "<th>Beneficiary Name</th>";
    echo "<th>Beneficiary No</th>";
    echo "<th>Doc No</th>";
    echo "<th>Work & Insurance Com</th>";
    echo "<th>Cover Type</th>";
    echo "<th>Date From</th>";
    echo "<th>Date To</th>";
    echo "<th>Total Amount</th>";
    echo "</tr>";

    if (!$results) {
        echo "<tr><td colspan='10'>لا توجد نتائج</td></tr>";
    } else {
        foreach ($results as $r) {
            echo "<tr>";
            echo "<td>".htmlspecialchars($r['PROVCLAIMNO'] ?? '')."</td>";
            echo "<td>".htmlspecialchars($r['INVOICENO'] ?? '')."</td>";
            echo "<td>".htmlspecialchars($r['FULLNAME'] ?? '')."</td>";
            echo "<td>".htmlspecialchars($r['BENEFICIARYID'] ?? '')."</td>";
            echo "<td>".htmlspecialchars($r['POLICYNUMBER'] ?? '')."</td>";
            echo "<td>".htmlspecialchars($r['POLICYHOLDER'] ?? '')."</td>";
            echo "<td>".htmlspecialchars($r['COVERAGE_CLASS'] ?? '')."</td>";
            echo "<td>".htmlspecialchars($r['BILLABLEPERIODSTART'] ?? '')."</td>";
            echo "<td>".htmlspecialchars($r['BILLABLEPERIODEND'] ?? '')."</td>";
            echo "<td>".number_format((float)($r['CLAIM_TOTAL'] ?? 0), 2)."</td>";
            echo "</tr>";
        }
        echo "<tr style='background:#f7f7f7;font-weight:bold'>";
        echo "<td colspan='9' style='text-align:right'>الإجمالي الكلي:</td>";
        echo "<td>".number_format((float)$totalSum, 2)."</td>";
        echo "</tr>";
    }
    echo "</table>";
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | Dashboard</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <style>
    body { font-family: Arial; background: #f8f8f8; }
    table { width: 100%; direction: rtl; border-collapse: collapse; background: white; }
    th, td { padding: 10px; border: 1px solid #ccc; text-align: center; }
    th { background: #eee; }
    .form-container, .buttons { margin-bottom: 20px; background: white; padding: 20px; border-radius: 10px; direction: rtl; }
    input[type="date"], button, select { padding: 10px; margin: 5px 0; width: 100%; }
    .buttons a { display:inline-block; margin-left:10px; }
  </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <?php include 'financeheader.php'; ?>
  <aside class="main-sidebar">
    <section class="sidebar">
      <?php include 'financesidepanle.php'; ?>
      <?php include 'searchform.php'; ?>
      <?php include 'navemenufinance.php'; ?>
    </section>
  </aside>

  <div class="content-wrapper">
    <section class="content-header">
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Claims</a></li>
      </ol>
    </section>

    <section class="content">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Calims Info Center</h3>
        </div>
        <div class="box-body">
          <div class="box">
            <div class="box-body">

              <h2 style="text-align:center;">Claims Report by Service Period - تقرير المطالبات لصاحب عمل معين حسب فترة الخدمة</h2>

              <div class="form-container">
                <form method="get">
                  <label>من تاريخ :</label>
                  <input type="date" name="from" value="<?= htmlspecialchars($fromDate ?? '') ?>">
                  <label>إلى تاريخ :</label>
                  <input type="date" name="to" value="<?= htmlspecialchars($toDate ?? '') ?>">
                  <label>اسم شركة صاحب العمل :</label>
                  <select name="company">
                    <option value="">-- جميع الشركات --</option>
                    <?php foreach ($companies as $c): ?>
                      <option value="<?= htmlspecialchars($c) ?>" <?= ($company === $c ? 'selected' : '') ?>>
                        <?= htmlspecialchars($c) ?>
                      </option>
                    <?php endforeach; ?>
                  </select>
                  <button type="submit" class="btn btn-block btn-primary btn-lg">عرض التقرير</button>
                </form>
              </div>

              <div class="buttons">
                <?php
                  // نبني رابط التصدير بنفس الفلاتر
                  $self = strtok($_SERVER['REQUEST_URI'], '?');
                  $qs = http_build_query(array_filter([
                      'from'    => $fromDate,
                      'to'      => $toDate,
                      'company' => $company,
                      'export'  => 'excel'
                  ], fn($v) => $v !== '' && $v !== null));
                ?>
                <a class="btn btn-success btn-lg" href="<?= htmlspecialchars($self . ($qs ? ('?' . $qs) : '?export=excel')) ?>">
                  <i class="fa fa-file-excel-o"></i> تصدير إلى Excel
                </a>
              </div>

              <?php if ($results): ?>
                <table>
                  <thead>
                    <tr>
                      <th>رقم المطالبة <br> Claim No</th>
                      <th>اسم المستفيد <br> Beneficiary Name</th>
                      <th>رقم الفاتورة <br> Invoice No</th>
                      <th>رقم المستفيد <br> Beneficiary No</th>
                      <th>رقم الوثيقة <br> Doc No</th>
                      <th>اسم صاحب العمل شركة التأمين <br> Work & Insurance Com</th>
                      <th>نوع التغطية <br> Cover Type</th>
                      <th>من تاريخ <br> Date From</th>
                      <th>إلى تاريخ <br> Date To</th>
                      <th>إجمالي المبلغ <br> Total Amount</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach ($results as $row): ?>
                      <tr>
                        <td><?= htmlspecialchars($row['PROVCLAIMNO'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['FULLNAME'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['INVOICENO'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['BENEFICIARYID'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['POLICYNUMBER'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['POLICYHOLDER'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['COVERAGE_CLASS'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['BILLABLEPERIODSTART'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['BILLABLEPERIODEND'] ?? '') ?></td>
                        <td><?= number_format((float)($row['CLAIM_TOTAL'] ?? 0), 2) ?> ريال</td>
                      </tr>
                    <?php endforeach; ?>
                    <tr style="background:#f0f0f0;font-weight:bold;">
                      <td colspan="9" style="text-align:left;">الإجمالي الكلي:</td>
                      <td><?= number_format((float)$totalSum, 2) ?> ريال</td>
                    </tr>
                  </tbody>
                </table>
              <?php else: ?>
                <p>لا توجد نتائج لهذه الفترة.</p>
              <?php endif; ?>

            </div>
          </div>
        </div>
      </div>
    </section>
  </div>

  <?php include 'footer.php'; ?>

  <aside class="control-sidebar control-sidebar-dark">
    <div class="tab-content"></div>
  </aside>
  <div class="control-sidebar-bg"></div>
</div>

<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script src="bootstrap/js/bootstrap.min.js"></script>
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<script src="plugins/fastclick/fastclick.js"></script>
<script src="dist/js/app.min.js"></script>
<script src="dist/js/demo.js"></script>
</body>
</html>
