<?php

//require_once __DIR__ . '/vendor/autoload.php';


// الاتصال بقاعدة البيانات
$host = 'localhost:3306';
$db   = 'acesaudi_site';
$user = 'acesaudi_usr';
$pass = 'tabfyv-6xiFry-noczak';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
];
$pdo = new PDO($dsn, $user, $pass, $options);

// الفلترة: تواريخ و IP
$from = $_GET['from'] ?? null;
$to = $_GET['to'] ?? null;
$ip = $_GET['ip'] ?? null;

// بناء الاستعلام
$query = "SELECT * FROM api_logs WHERE 1=1";
$params = [];

if ($from) {
    $query .= " AND request_time >= :from";
    $params[':from'] = $from . ' 00:00:00';
}
if ($to) {
    $query .= " AND request_time <= :to";
    $params[':to'] = $to . ' 23:59:59';
}
if ($ip) {
    $query .= " AND ip_address = :ip";
    $params[':ip'] = $ip;
}

$query .= " ORDER BY request_time DESC LIMIT 100"; // الحد الأعلى للعرض

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$logs = $stmt->fetchAll();

if (isset($_GET['download']) && $_GET['download'] === 'csv') {
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=api_logs.csv');

    $output = fopen('php://output', 'w');
    fputcsv($output, ['ID', 'Time', 'Provider ID', 'Patient Key', 'System Type', 'Response Code', 'Response Body', 'IP']);

    foreach ($logs as $log) {
        fputcsv($output, [
            $log['id'],
            $log['request_time'],
            $log['provider_id'],
            $log['patient_key'],
            $log['system_type'],
            $log['response_code'],
            substr($log['response_body'], 0, 500),
            $log['ip_address']
        ]);
    }
    fclose($output);
    exit;
}

?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>سجل طلبات API</title>
    <style>
        body { font-family: Arial; background: #f8f8f8; padding: 20px; direction: rtl; }
        table { border-collapse: collapse; width: 100%; background: white; }
        th, td { border: 1px solid #ccc; padding: 8px; font-size: 14px; }
        th { background: #eee; }
        form { margin-bottom: 20px; }
    </style>
</head>
<body>

<h2>سجل طلبات API</h2>

<?php
// عدد الطلبات الكلي
$totalCount = $pdo->query("SELECT COUNT(*) FROM api_logs")->fetchColumn();

// عدد طلبات اليوم
$today = date('Y-m-d');
$stmtToday = $pdo->prepare("SELECT COUNT(*) FROM api_logs WHERE DATE(request_time) = :today");
$stmtToday->execute([':today' => $today]);
$todayCount = $stmtToday->fetchColumn();
?>

<div style="margin-bottom: 15px;">
    <strong>إجمالي الطلبات:</strong> <?= $totalCount ?>
    &nbsp; | &nbsp;
    <strong>طلبات اليوم:</strong> <?= $todayCount ?>
    &nbsp; | &nbsp;
    <a href="?download=csv<?= $from ? '&from=' . $from : '' ?><?= $to ? '&to=' . $to : '' ?><?= $ip ? '&ip=' . $ip : '' ?>">📥 تحميل كـ CSV</a>
</div>


<form method="get">
    <label>من تاريخ: <input type="date" name="from" value="<?= htmlspecialchars($from) ?>"></label>
    <label>إلى تاريخ: <input type="date" name="to" value="<?= htmlspecialchars($to) ?>"></label>
    <label>IP المستخدم: <input type="text" name="ip" value="<?= htmlspecialchars($ip) ?>"></label>
    <button type="submit">فلترة</button>
</form>

<table>
    <thead>
        <tr>
            <th>#</th>
            <th>الوقت</th>
            <th>Provider ID</th>
            <th>Patient Key</th>
            <th>System Type</th>
            <th>كود الاستجابة</th>
            <th>الرد</th>
            <th>IP</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($logs as $log): ?>
            <tr>
                <td><?= $log['id'] ?></td>
                <td><?= $log['request_time'] ?></td>
                <td><?= $log['provider_id'] ?></td>
                <td><?= $log['patient_key'] ?></td>
                <td><?= $log['system_type'] ?></td>
                <td><?= $log['response_code'] ?></td>
                <td><pre><?= htmlspecialchars(substr($log['response_body'], 0, 200)) ?></pre></td>
                <td><?= $log['ip_address'] ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

</body>
</html>
