<?php
include 'conni.php';

// التحقق من وجود بيانات الإدخال
$date = isset($_POST['date']) ? $_POST['date'] : null;
$period = isset($_POST['period']) ? $_POST['period'] : null;

$slots = [];

if ($date && $period) {
    // استعلام لجلب الأوقات والغرف المتاحة بناءً على التاريخ والفترة
    $query = "
        SELECT room_id, time_slot
        FROM bookings
        WHERE booking_date = ? AND period = ? AND bookingstatus != 'confirmed';
    ";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("ss", $date, $period);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $slots[] = [
            "room" => $row['room_id'],
            "time" => $row['time_slot']
        ];
    }

    $stmt->close();
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام حجز مواعيد المرضى</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            direction: rtl;
            margin: 0;
            padding: 20px;
        }
        h1 {
            text-align: center;
        }
        .form-container {
            max-width: 600px;
            margin: 0 auto;
            background: #f9f9f9;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        select, input[type="date"], button {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        .availability-list {
            margin-top: 20px;
        }
        .slot-form {
            display: inline-block;
            margin: 5px;
        }
        .slot-button {
            display: inline-block;
            padding: 10px 20px;
            background: #4caf50;
            color: white;
            text-decoration: none;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .slot-button:hover {
            background: #45a049;
        }
    </style>
</head>
<body>

<h1>نظام حجز مواعيد المستفيدين لمركز التميز</h1>

<div class="form-container">
    <form method="POST" action="">
        <label for="date">التاريخ:</label>
        <input type="date" id="date" name="date" required value="<?= htmlspecialchars($date) ?>">

        <label for="period">الفترة:</label>
        <select id="period" name="period" required>
            <option value="" disabled <?= $period === null ? 'selected' : '' ?>>اختر الفترة</option>
            <option value="morning" <?= $period === 'morning' ? 'selected' : '' ?>>صباحية</option>
            <option value="afternoon" <?= $period === 'afternoon' ? 'selected' : '' ?>>مسائية</option>
        </select>

        <button type="submit">بحث</button>
    </form>

    <div class="availability-list">
        <?php if ($date && $period): ?>
            <?php if (count($slots) > 0): ?>
                <h3>الأوقات المتاحة:</h3>
                <?php foreach ($slots as $slot): ?>
                    <form class="slot-form" method="POST" action="book_slot.php">
                        <input type="hidden" name="date" value="<?= htmlspecialchars($date) ?>">
                        <input type="hidden" name="period" value="<?= htmlspecialchars($period) ?>">
                        <input type="hidden" name="room" value="<?= htmlspecialchars($slot['room']) ?>">
                        <input type="hidden" name="time" value="<?= htmlspecialchars($slot['time']) ?>">
                        <button type="submit" class="slot-button">
                            الغرفة: <?= htmlspecialchars($slot['room']) ?> - الوقت: <?= htmlspecialchars($slot['time']) ?>
                        </button>
                    </form>
                <?php endforeach; ?>
            <?php else: ?>
                <p>لا توجد غرف أو أوقات متاحة في هذا الوقت.</p>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

</body>
</html>
