<?php include 'sessionheaderrecption.php'; ?>
<?php
require_once 'dbase.php';

$beneficiaryId = $_GET['beneficiary_id'] ?? '';
$fromDate = $_GET['from_date'] ?? '';
$toDate = $_GET['to_date'] ?? '';
$eligibilityFilter = $_GET['eligibility'] ?? ''; // new

$responseData = [];
$error = '';

if ($beneficiaryId) {
    try {
        $pdo = getPDO();
        $query = "SELECT * FROM waseel_responses WHERE beneficiary_id = ?";
        $params = [$beneficiaryId];

        if ($fromDate && $toDate) {
            $query .= " AND DATE(created_at) BETWEEN ? AND ?";
            $params[] = $fromDate;
            $params[] = $toDate;
        }

        $query .= " ORDER BY created_at DESC";
        $stmt = $pdo->prepare($query);
        $stmt->execute($params);
        $allData = $stmt->fetchAll();

        // تطبيق الفلترة بناءً على حالة الاستحقاق
        foreach ($allData as $row) {
            $json = json_decode($row['response_body'], true);
            $siteEligibility = $json['siteEligibility'] ?? null;

            if ($eligibilityFilter === 'eligible' && $siteEligibility !== 'eligible') continue;
            if ($eligibilityFilter === 'not_eligible' && $siteEligibility === 'eligible') continue;

            $responseData[] = $row;
        }
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
 <title>Reception ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
  
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

 <?php include 'receptionheader.php'; ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
         <!-- Sidebar user panel -->
    <?php include 'receptionsidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenureception.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Eligibility Requests Transactions <?php include 'sessionid.php'; ?> </a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Advance Filter </h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body" style="text-align: center;">

            <h3 style="text-align: center;">تصفية الردود حسب رقم الهوية والتاريخ وحالة الاستحقاق</h3><br>
<form method="GET" style="text-align: center;">
     <div class="col-md-12">

     <div class="col-md-3">
      <label> رقم الهوية</label>
      <input type="text" name="beneficiary_id" value="<?= htmlspecialchars($beneficiaryId) ?>" required class="form-control">
     </div>

      <div class="col-md-3">
     <label>  من تاريخ </label>
     <input type="date" name="from_date" value="<?= htmlspecialchars($fromDate) ?>" class="form-control pull-right">
     </div>

     <div class="col-md-3">
          <label>  إلى تاريخ </label>
    <input type="date" name="to_date" value="<?= htmlspecialchars($toDate) ?>" class="form-control pull-right">
     </div>

     <div class="col-md-3">
     <label>حالة الاستحقاق</label>
    <select name="eligibility" class="form-control">
        <option value="">كل الحالات</option>
        <option value="eligible" <?= $eligibilityFilter === 'eligible' ? 'selected' : '' ?>>يحق له العلاج</option>
    </select>
     </div>

     </div>
     <div class="col-md-12"><br></div>

      <div class="col-md-12">
     <button type="submit" class="btn btn-block btn-primary">بحث</button>
      </div>
    
</form>

<div class="col-md-12"><br></div>

<?php if ($responseData): ?>
    <br><br>
    <table border="1" cellpadding="6" cellspacing="0" class="table table-bordered table-hover">
        <tr>
            <th style="text-align: center;">رقم الرد</th>
            <th style="text-align: center;">رقم هوية المستفيد</th>
            <th style="text-align: center;">تاريخ الرد</th>
            <th style="text-align: center;">كود الاستجابة</th>
            <th style="text-align: center;">حالة الطلب</th>
            <th style="text-align: center;">يحق له العلاج؟</th>
            <th style="text-align: center;">ارسال طلب إنشاء موافقة </th>
        </tr>
        <?php foreach ($responseData as $row): 
            $responseJson = json_decode($row['response_body'], true);
            $eligibility = $responseJson['siteEligibility'] ?? null;
            $status = $responseJson['status'] ?? 'غير معروف';
            $outcome = $responseJson['outcome'] ?? '';
        ?>
            <tr>
               <td><?= htmlspecialchars($row['id']) ?></td>
               <td><?= htmlspecialchars($row['beneficiary_id']) ?></td>
                <td><?= htmlspecialchars($row['created_at']) ?></td>
                <td><?= htmlspecialchars($row['response_code']) ?></td>
                <td><?= htmlspecialchars($status) ?> (<?= htmlspecialchars($outcome) ?>)</td>
                <td style="color:<?= ($eligibility === 'eligible') ? 'green' : 'red' ?>">
                    <?= ($eligibility === 'eligible') ? 'يحق له العلاج' : 'لا يحق له العلاج' ?>
                </td>
                <td>
                   <button class="btn btn-block btn-primary"><a href="preauthorizationrequest.php?beneficiary_id=<? echo  htmlspecialchars($row['beneficiary_id']) ?>&status=<?= htmlspecialchars($status) ?>&username=<? include 'sessionid.php'; ?>" style="color: white;"> <i class="fa fa-fw fa-envelope"></i> أرسال طلب موافقة علاجية </a></button>
                  
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
<?php elseif ($beneficiaryId): ?>
    <p>لا توجد ردود مرتبطة بهذا الرقم أو لا تطابق الفلاتر المحددة</p>
<?php endif; ?>

<?php if ($error): ?>
    <p style="color:red"><?= htmlspecialchars($error) ?></p>
<?php endif; ?>



            
          </div>
             
             </div>

               
             
            </div>

          



          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <footer class="main-footer">
    <div class="pull-right hidden-xs">
      <b>Version</b> 1.0.1
    </div>
    <strong>Copyright &copy; 2024-2025 <a href="http://hasanaltohami.com">ENGI / Hasan ALTohami</a>.</strong> All rights
    reserved.
  </footer>
  <!-- Control Sidebar -->

  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
