<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
// إعداد الاتصال بقاعدة البيانات
$host = 'localhost:3306';
$db   = 'acesaudi_site';     // <-- غيّر اسم قاعدة البيانات هنا
$user = 'acesaudi_usr';          // <-- غيّر اسم المستخدم هنا
$pass = 'tabfyv-6xiFry-noczak';          // <-- غيّر كلمة المرور هنا
$charset = 'utf8mb4';

// الاتصال عبر PDO
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    die("خطأ في الاتصال: " . $e->getMessage());
}

// استقبال التواريخ (إن وُجدت)
$fromDate = isset($_GET['from']) ? $_GET['from'] : null;
$toDate = isset($_GET['to']) ? $_GET['to'] : null;

// فلترة حسب التاريخ
$where = '';
$params = [];

if ($fromDate && $toDate) {
    $where = "WHERE ci.BILLABLEPERIODSTART >= :fromDate AND ci.BILLABLEPERIODEND <= :toDate";
    $params = [
        ':fromDate' => $fromDate,
        ':toDate' => $toDate
    ];
}

// الاستعلام الرئيسي
$sql = "
SELECT 
    ci.PROVCLAIMNO,
    ci.BENEFICIARYID,
    b.FULLNAME,
    ci.COVERAGEID,
    c.POLICYNUMBER,
    cc.VALUE AS COVERAGE_CLASS,
    ci.BILLABLEPERIODSTART,
    ci.BILLABLEPERIODEND
FROM NPHIES_CLAIMINFO ci
LEFT JOIN NPHIES_CLAIMITEM ci_item ON ci.PROVCLAIMNO = ci_item.PROVCLAIMNO
LEFT JOIN NPHIES_BENEFICIARY b ON ci.BENEFICIARYID = b.BENEFICIARYID
LEFT JOIN NPHIES_COVERAGE c ON ci.COVERAGEID = c.COVERAGEID
LEFT JOIN NPHIES_COVERAGE_CLASS cc ON c.COVERAGEID = cc.COVERAGEID
$where
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$results = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>تقرير المطالبات</title>
    <style>
        body { font-family: Arial; direction: rtl; padding: 20px; background: #f8f8f8; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; background: white; }
        th, td { padding: 10px; border: 1px solid #ccc; text-align: center; }
        th { background: #eee; }
        .form-container { background: white; padding: 20px; border-radius: 10px; max-width: 600px; margin-bottom: 20px; }
        input[type="date"], button { padding: 10px; width: 100%; margin-top: 10px; }
    </style>
</head>
<body>

<h2>تقرير المطالبات حسب فترة الخدمة</h2>

<div class="form-container">
    <form method="get">
        <label>من تاريخ:</label>
        <input type="date" name="from" value="<?= htmlspecialchars($fromDate ?? '') ?>">
        <label>إلى تاريخ:</label>
        <input type="date" name="to" value="<?= htmlspecialchars($toDate ?? '') ?>">
        <button type="submit">عرض التقرير</button>
    </form>
</div>

<?php if ($results): ?>
    <table>
        <thead>
            <tr>
                <th>رقم المطالبة</th>
                <th>اسم المستفيد</th>
                <th>معرّف المستفيد</th>
                <th>رقم الوثيقة</th>
                
                <th>نوع التغطية</th>
                <th>من تاريخ</th>
                <th>إلى تاريخ</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($results as $row): ?>
                <tr>
                    <td><?= htmlspecialchars($row['PROVCLAIMNO']) ?></td>
                    <td><?= htmlspecialchars($row['FULLNAME']) ?></td>
                    <td><?= htmlspecialchars($row['BENEFICIARYID']) ?></td>
                    <td><?= htmlspecialchars($row['POLICYNUMBER']) ?></td>
                 
                    <td><?= htmlspecialchars($row['COVERAGE_CLASS']) ?></td>
                    <td><?= htmlspecialchars($row['BILLABLEPERIODSTART']) ?></td>
                    <td><?= htmlspecialchars($row['BILLABLEPERIODEND']) ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>لا توجد بيانات.</p>
<?php endif; ?>

</body>
</html>
