<?php
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
error_reporting(E_ALL);
ini_set('display_errors', 1);

/* ========= الاتصال ========= */
$have_external_conn = false;
if (file_exists(__DIR__ . '/conn.php')) {
  include __DIR__ . '/conn.php';
  if (isset($conn) && $conn instanceof mysqli) $have_external_conn = true;
}
if (!$have_external_conn) {
  $conn = new mysqli("localhost:3306", "acesaudi_usr", "tabfyv-6xiFry-noczak", "acesaudi_site");
  mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
}
if ($conn->connect_error) { http_response_code(500); die("DB error: ".$conn->connect_error); }
$conn->set_charset("utf8mb4");

/* ========= Helpers ========= */
function post($k,$d=null){ return isset($_POST[$k]) ? trim((string)$_POST[$k]) : $d; }
function to_mysql_dt($v){
  if(!$v) return null;
  $v = str_replace('T',' ',$v);
  if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$v)) $v .= ' 00:00:00';
  if (preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}$/',$v)) $v .= ':00';
  $ts = strtotime($v); return $ts ? date('Y-m-d H:i:s',$ts) : null;
}
function t($v,$max){ if($v===null) return null; return mb_substr(trim($v),0,$max); }
function pick($row, $keys, $max=null){
  foreach ($keys as $k){
    foreach ($row as $rk=>$rv){
      if (strtolower($rk)===strtolower($k)) {
        $val = trim((string)$rv);
        return $max!==null ? t($val,$max) : $val;
      }
    }
  }
  return null;
}
function extract_code_and_text($text, $fallbackId=null){
  $code = $fallbackId ?: null;
  $desc = trim((string)$text);
  if(!$fallbackId && preg_match('/^\s*([A-Za-z0-9.\-]+)\s*—\s*(.+)$/u', $desc, $m)){
    $code = $m[1]; $desc = $m[2];
  }
  return [ $code ? mb_substr($code,0,30) : null,
           $desc ? mb_substr($desc,0,255) : null ];
}
function cause_code_only($v){
  $v = trim((string)$v);
  if ($v==='') return null;
  if (preg_match('/^\s*([A-Za-z0-9.\-]+)/', $v, $m)) return mb_substr($m[1],0,10);
  return mb_substr($v,0,10);
}

/* ========= أسماء الجداول ========= */
$T_INFO   = 'NPHIES_CLAIMINFO';
$T_CT     = 'NPHIES_CLAIMCARETEAM';
$T_DIAG   = 'NPHIES_CLAIMDIAGNOSIS';
$T_SUP    = 'NPHIES_CLAIMSUPPORTINGINFO';
$T_ITEMS  = 'NPHIES_CLAIMITEM';
$T_ICT    = 'NPHIES_ITEMCARETEAM';
$T_ENC    = 'NPHIES_CLAIMENCOUNTERS';
$T_ITEMSUP = 'NPHIES_ITEMSUPPORTINGINFO';


/* ========= Claim Info ========= */
$PROVCLAIMNO   = t(post('ProviderClaimNo'), 40);
$EPISODEID     = t(post('EpisodeId'), 30);

$CLAIMTYPE     = t(post('ClaimType','professional'), 20);
$CLAIMSUBTYPE  = t(post('ClaimSubtype','op'), 20);
$PAYEETYPE     = t(post('PAYEETYPE','provider'), 10);

$CLAIMCREATEDDATE = to_mysql_dt(post('ClaimCreatedDate', date('Y-m-d H:i')));
$ACCOUNTINGPERIOD = to_mysql_dt(post('AccountingPeriod'));

$ISNEWBORN     = t(post('IsNewborn','false'), 10);
$ISREFERRAL    = t(post('ISREFERRAL','false'), 10);
$REFERRINGPROVIDERNAME = t(post('REFERRINGPROVIDERNAME'), 200);

$PROVIDERNPHIESID = t(post('ProviderNphiesId'), 20);

$BILLABLEPERIODSTART = to_mysql_dt(post('BILLABLEPERIODSTART'));
$BILLABLEPERIODEND   = null;

$ELIGIBILITYRESPONSEID    = t(post('eligibility_details'), 30);
$ELIGIBILITYIDENTIFIERURL = null;
$ELIGIBILITYOFFLINEID     = null;
$ELIGIBILITYOFFLINEDATE   = null;

/* Preauth */
$hasPreauth  = post('hasPreauth','0') === '1';
$pre_csv     = trim((string)post('preauth_reference_nos'));
$pre_first   = '';
if ($pre_csv !== '') {
  $arr = array_filter(array_map('trim', explode(',',$pre_csv)));
  $pre_first = $arr ? $arr[0] : '';
}
$PREAUTHOFFLINEDATE   = to_mysql_dt(post('PREAUTHOFFLINEDATE'));
$PREAUTHRESPONSEID    = $hasPreauth ? t($pre_first, 30) : null;
$PREAUTHIDENTIFIERURL = $hasPreauth ? t($pre_csv, 250) : null;

/* Payee/Coverage/Beneficiary */
$PAYEEID       = '10000300205372';
$COVERAGEID    = t(post('CoverageId'), 20);
$BENEFICIARYID = t(post('BeneficiaryId'), 30);
$SUBSCRIBERID  = null;

$TOTAL = post('Total');
$TOTAL = $TOTAL!==null ? (float)str_replace(',','',$TOTAL) : null;

$PRESCRIPTION = null;

/* تحقق أساسي */
$missing = [];
if(!$PROVCLAIMNO)       $missing[]='ProviderClaimNo';
if(!$EPISODEID)         $missing[]='EpisodeId';
if(!$CLAIMCREATEDDATE)  $missing[]='ClaimCreatedDate';
if($missing){ http_response_code(422); die("حقول ناقصة: ".implode(', ',$missing)); }

/* ========= Care Team (Claim-level) ========= */
$CT_SEQUENCENO   = (int)post('SEQUENCENO', 1);
$CT_PHYSICIANID  = t(post('PHYSICIANID', post('PHYSICIANNAME')), 30);
$CT_PHYSICIANNAME= t(post('PHYSICIANNAME_REAL', post('PHYSICIANNAME')), 60);
$CT_PRACTROLE    = t(post('ct_practitioner_role'), 20);
$CT_CAREROLE     = t(post('ct_careteam_role'), 20);
$CT_QUALIF       = t(post('ct_qualification'), 30);

/* ========= JSONs ========= */
$dx_json    = post('diagnosis_json','[]');
$DX         = json_decode($dx_json, true);     if(!is_array($DX)) $DX = [];

$sup_json   = post('supporting_rows_json','[]');
$SUP        = json_decode($sup_json, true);    if(!is_array($SUP)) $SUP = [];

$items_json = post('items_json','[]');
$ITEMS      = json_decode($items_json, true);  if(!is_array($ITEMS)) $ITEMS = [];

$item_ct_json = post('item_careteam_json','[]');           // إن وجد
$ITEM_CTS     = json_decode($item_ct_json, true);           if(!is_array($ITEM_CTS)) $ITEM_CTS = [];

/* ========= Encounter (from form) ========= */
$ENC_STATUS    = t(post('status','planned'), 20);
$ENC_CLASS     = t(post('class','ambulatory'), 20);
$ENC_SVCTYPE   = t(post('service_type','acute'), 20);
$ENC_PRIORITY  = t(post('priority','EL'), 20);
$ENC_START     = to_mysql_dt(post('start_period'));  if ($ENC_START===null) $ENC_START = date('Y-m-d H:i:s');
$ENC_END       = to_mysql_dt(post('end_period'));    if ($ENC_END===null)   $ENC_END   = $ENC_START;
$ENC_COD       = cause_code_only(post('cause_of_death',''));
$ENC_EVENTTYPE = t(post('service_event_type','initial'), 10);
$ENC_ID        = 'ENC'.date('YmdHis').substr((string)mt_rand(100,999),0,3);
$SERVICEPROVIDER = $PROVIDERNPHIESID ?: $PAYEEID;

/* ========= Transaction ========= */
try {
  $conn->begin_transaction();

  /* 1) Claim Info */
  $sql = "INSERT INTO `$T_INFO`
    (`PROVCLAIMNO`,`EPISODEID`,`ISNEWBORN`,`ISREFERRAL`,`REFERRINGPROVIDERNAME`,
     `CLAIMTYPE`,`CLAIMSUBTYPE`,`PROVIDERNPHIESID`,`CLAIMCREATEDDATE`,`ACCOUNTINGPERIOD`,
     `BILLABLEPERIODSTART`,`BILLABLEPERIODEND`,`ELIGIBILITYRESPONSEID`,`ELIGIBILITYIDENTIFIERURL`,
     `ELIGIBILITYOFFLINEID`,`ELIGIBILITYOFFLINEDATE`,`PREAUTHOFFLINEDATE`,`PREAUTHRESPONSEID`,
     `PREAUTHIDENTIFIERURL`,`PAYEETYPE`,`PAYEEID`,`COVERAGEID`,`BENEFICIARYID`,`SUBSCRIBERID`,
     `TOTAL`,`PRESCRIPTION`)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
  $stmt = $conn->prepare($sql);
  if(!$stmt){ throw new RuntimeException("Prepare failed (claiminfo): ".$conn->error); }
  $stmt->bind_param(
    "ssssssssssssssssssssssssds",
    $PROVCLAIMNO,$EPISODEID,$ISNEWBORN,$ISREFERRAL,$REFERRINGPROVIDERNAME,
    $CLAIMTYPE,$CLAIMSUBTYPE,$PROVIDERNPHIESID,$CLAIMCREATEDDATE,$ACCOUNTINGPERIOD,
    $BILLABLEPERIODSTART,$BILLABLEPERIODEND,$ELIGIBILITYRESPONSEID,$ELIGIBILITYIDENTIFIERURL,
    $ELIGIBILITYOFFLINEID,$ELIGIBILITYOFFLINEDATE,$PREAUTHOFFLINEDATE,$PREAUTHRESPONSEID,
    $PREAUTHIDENTIFIERURL,$PAYEETYPE,$PAYEEID,$COVERAGEID,$BENEFICIARYID,$SUBSCRIBERID,
    $TOTAL,$PRESCRIPTION
  );
  if(!$stmt->execute()){ throw new RuntimeException("Execute failed (claiminfo): ".$stmt->error); }
  $stmt->close();

  /* 2) Care Team (Claim-level) */
  if($CT_PHYSICIANID || $CT_PHYSICIANNAME){
    $conn->query("DELETE FROM `$T_CT` WHERE PROVCLAIMNO='".$conn->real_escape_string($PROVCLAIMNO)."' AND SEQUENCENO=".(int)$CT_SEQUENCENO);
    $ins = $conn->prepare(
      "INSERT INTO `$T_CT`
       (PROVCLAIMNO, SEQUENCENO, PHYSICIANID, PHYSICIANNAME, PRACTITIONERROLE, CARETEAMROLE, CARETEAMQUALIFICATION)
       VALUES (?,?,?,?,?,?,?)"
    );
    if(!$ins){ throw new RuntimeException("Prepare failed (careteam insert): ".$conn->error); }
    $ins->bind_param("sisssss",
      $PROVCLAIMNO, $CT_SEQUENCENO, $CT_PHYSICIANID, $CT_PHYSICIANNAME,
      $CT_PRACTROLE, $CT_CAREROLE, $CT_QUALIF
    );
    if(!$ins->execute()){ throw new RuntimeException("Execute failed (careteam insert): ".$ins->error); }
    $ins->close();
  }

  /* 3) Diagnosis */
  $delDx = $conn->prepare("DELETE FROM `$T_DIAG` WHERE PROVCLAIMNO=?");
  if(!$delDx){ throw new RuntimeException("Prepare failed (dx delete): ".$conn->error); }
  $delDx->bind_param("s", $PROVCLAIMNO);
  if(!$delDx->execute()){ throw new RuntimeException("Execute failed (dx delete): ".$delDx->error); }
  $delDx->close();

  if($DX){
    $insDx = $conn->prepare(
      "INSERT INTO `$T_DIAG`
       (PROVCLAIMNO, SEQUENCENO, DIAGNOSISCODE, DIAGNOSISDESC, DIAGNOSISTYPE, ONADMISSION, CONDITIONONSET)
       VALUES (?,?,?,?,?,?,?)"
    );
    if(!$insDx){ throw new RuntimeException("Prepare failed (dx insert): ".$conn->error); }
    foreach ($DX as $row){
      $seq   = (int)($row['seq'] ?? 0);  if($seq<=0) $seq = 1;
      $id    = pick($row,['id','code_id']);
      $text  = pick($row,['text']) ?: '';
      $type  = pick($row,['type']);
      $onadm = pick($row,['onadmission']);
      $onset = pick($row,['conditiononset']);
      list($code,$desc) = extract_code_and_text($text, $id);
      if(!$desc) continue;
      $type  = $type  ? mb_substr($type,0,40)  : null;
      $onadm = $onadm ? mb_substr($onadm,0,30) : null;
      $onset = $onset ? mb_substr($onset,0,30) : null;

      $insDx->bind_param("sisssss", $PROVCLAIMNO, $seq, $code, $desc, $type, $onadm, $onset);
      if(!$insDx->execute()){ throw new RuntimeException("Execute failed (dx insert): ".$insDx->error); }
    }
    $insDx->close();
  }

  /* 4) Supporting Info */
  $delSup = $conn->prepare("DELETE FROM `$T_SUP` WHERE PROVCLAIMNO=?");
  if(!$delSup){ throw new RuntimeException("Prepare failed (support delete): ".$conn->error); }
  $delSup->bind_param("s", $PROVCLAIMNO);
  if(!$delSup->execute()){ throw new RuntimeException("Execute failed (support delete): ".$delSup->error); }
  $delSup->close();

  if($SUP){
    $insSup = $conn->prepare(
      "INSERT INTO `$T_SUP`
       (PROVCLAIMNO, SEQUENCENO, CATEGORY, REASON, SUPPORTINGVALUE, UNIT)
       VALUES (?,?,?,?,?,?)"
    );
    if(!$insSup){ throw new RuntimeException("Prepare failed (support insert): ".$conn->error); }
    foreach ($SUP as $i=>$row){
      $seq = (int)($row['SEQUENCENO'] ?? $row['seq'] ?? 0);
      if($seq<=0) $seq = $i+1;
      $category = pick($row,['CATEGORY'],60) ?: '';
      $reason   = pick($row,['REASON'],120) ?: '';
      $value    = pick($row,['SUPPORTINGVALUE','VALUE','support_value','SUPPORT_VALUE'],100) ?: '';
      $unit     = pick($row,['UNIT'],20) ?: '';
      if($category==='' && $reason==='' && $value==='' && $unit==='') continue;

      $insSup->bind_param("sissss", $PROVCLAIMNO, $seq, $category, $reason, $value, $unit);
      if(!$insSup->execute()){ throw new RuntimeException("Execute failed (support insert): ".$insSup->error); }
    }
    $insSup->close();
  }

  /* 5) Items */
  $delIt = $conn->prepare("DELETE FROM `$T_ITEMS` WHERE PROVCLAIMNO=?");
  if(!$delIt){ throw new RuntimeException("Prepare failed (items delete): ".$conn->error); }
  $delIt->bind_param("s", $PROVCLAIMNO);
  if(!$delIt->execute()){ throw new RuntimeException("Execute failed (items delete): ".$delIt->error); }
  $delIt->close();

  if($ITEMS){
    $insIt = $conn->prepare(
      "INSERT INTO `$T_ITEMS`
       (PROVCLAIMNO, INVOICENO, SEQUENCENO,
        SERVICETYPE, SERVICECODE, SERVICEDESC,
        NONSTANDARDCODE, NONSTANDARDDESC,
        QUANTITY, QUANTITYCODE,
        UNITPRICE, FACTOR, PATIENTSHARE, PAYERSHARE, TAX, NET,
        ISPACKAGE, ISMATERNITY,
        STARTDATE, ENDDATE)
       VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"
    );
    if(!$insIt){ throw new RuntimeException("Prepare failed (items insert): ".$conn->error); }

    foreach ($ITEMS as $i=>$it){
      $seq        = (int)($it['seq'] ?? 0);  if($seq<=0) $seq = $i+1;
      $invoiceNo  = t(pick($it,['invoiceNo','invoice','InvoiceNo'],40) ?: $EPISODEID, 40);

      $svcType    = t(pick($it,['type','SERVICE_TYPE'],32),32);
      $svcCode    = t(pick($it,['code','SERVICECODE','SERVICE_CODE','STD_CODE','STD_CODE_DESC'],30),30);
      $svcDesc    = t(pick($it,['desc','SERVICEDESC','SERVICE_DESC','STD_DESC'],255),255);

      $nsc        = t(pick($it,['nonStdCode','NON_STANDARD_CODE','NONSTANDARDCODE'],30),30);
      $nsd        = t(pick($it,['nonStdDesc','NON_STANDARD_DESC','NONSTANDARDDESC'],255),255);

      $qty        = (float)(pick($it,['qty','QUANTITY']) ?? 1);
      $qtyCode    = t(pick($it,['qtyType','QUANTITYCODE'],20) ?: 'Unit',20);

      // دعم كلتا الصيغتين unitPrice / unit
      $unitPrice  = (float)(pick($it,['unitPrice','UNITPRICE','unit','price']) ?? 0);
      $factor     = (float)(pick($it,['factor','FACTOR']) ?? 1);
      $patient    = (float)(pick($it,['patientShare','benefit','PATIENTSHARE']) ?? 0);
      $payer      = (float)(pick($it,['payerShare','PAYERSHARE']) ?? 0);
      $tax        = (float)(pick($it,['tax','TAX']) ?? 0);
      $disc       = (float)(pick($it,['discount','DISCOUNT']) ?? 0);
      $net        = (float)(pick($it,['net','NET']) ?? max(0, $qty * $unitPrice * $factor - $disc));

      $startDate  = to_mysql_dt(pick($it,['startDate','STARTDATE'])) ?: ($BILLABLEPERIODSTART ?: $CLAIMCREATEDDATE);
      $endDate    = to_mysql_dt(pick($it,['endDate','ENDDATE']))     ?: $startDate;

      $isPackage   = in_array(pick($it,['isPackage'],5),   [true,1,'1','true'], true) ? 'true' : 'false';
      $isMaternity = in_array(pick($it,['isMaternity'],5), [true,1,'1','true'], true) ? 'true' : 'false';

      $insIt->bind_param(
        "ssisssssdsddddddssss",
        $PROVCLAIMNO, $invoiceNo, $seq,
        $svcType, $svcCode, $svcDesc,
        $nsc, $nsd,
        $qty, $qtyCode,
        $unitPrice, $factor, $patient, $payer, $tax, $net,
        $isPackage, $isMaternity,
        $startDate, $endDate
      );
      if(!$insIt->execute()){
        throw new RuntimeException("Execute failed (items insert): ".$insIt->error);
      }
    }
    $insIt->close();
  }

  /* 5) Items (لا نحذف القديم إلا لو عندنا بيانات جديدة) ----------------------------------- */
$items_json = post('items_json','[]');
if (is_string($items_json)) {
  // لو المتصفح حول علامات الاقتباس لـ HTML entities
  $items_json = html_entity_decode($items_json, ENT_QUOTES, 'UTF-8');
}
$ITEMS = json_decode($items_json, true);
if(!is_array($ITEMS)) $ITEMS = [];

/* Fallback: إن كان الفورم أرسل حقولًا مفردة ولم يُرسل items_json */
if (!$ITEMS && (post('SERVICE_TYPE') || post('NON_STANDARD_CODE') || post('STD_CODE_DESC') || post('invoiceNo'))) {
  $std = post('STD_CODE_DESC'); $code = null; $desc = null;
  if ($std) {
    if (preg_match('/^\s*([A-Za-z0-9.\-]+)\s*—\s*(.+)$/u', $std, $m)) { $code=$m[1]; $desc=$m[2]; }
    else { $code = $std; }
  }
  $ITEMS[] = [
    'seq'          => 1,
    'invoiceNo'    => post('invoiceNo', $EPISODEID),
    'type'         => post('SERVICE_TYPE',''),
    'code'         => $code ?: post('SERVICE_CODE',''),
    'desc'         => $desc ?: post('NON_STANDARD_DESC',''),
    'nonStdCode'   => post('NON_STANDARD_CODE',''),
    'nonStdDesc'   => post('NON_STANDARD_DESC',''),
    'qty'          => (float)post('quantity',1),
    'qtyType'      => post('qtyType','Unit'),
    'unitPrice'    => (float)post('unitPrice', post('price',0)),
    'factor'       => (float)post('factor',1),
    'patientShare' => (float)post('patientShare',0),
    'payerShare'   => (float)post('payerShare',0),
    'tax'          => (float)post('taxAmount',0),
    'discount'     => (float)post('discountAmount',0),
    'net'          => null, // سيُحسب لاحقًا
    'isPackage'    => post('isPackage','false'),
    'isMaternity'  => post('isMaternity','false'),
    'startDate'    => post('startDate', null),
    'endDate'      => post('endDate', null),
  ];
}

if ($ITEMS) {
  // امسح البنود القديمة لهذه المطالبة
  $delIt = $conn->prepare("DELETE FROM `$T_ITEMS` WHERE PROVCLAIMNO=?");
  if(!$delIt){ throw new RuntimeException("Prepare failed (items delete): ".$conn->error); }
  $delIt->bind_param("s", $PROVCLAIMNO);
  if(!$delIt->execute()){ throw new RuntimeException("Execute failed (items delete): ".$delIt->error); }
  $delIt->close();

  // التحضير للإدراج
  $insIt = $conn->prepare(
    "INSERT INTO `$T_ITEMS`
     (PROVCLAIMNO, INVOICENO, SEQUENCENO,
      SERVICETYPE, SERVICECODE, SERVICEDESC,
      NONSTANDARDCODE, NONSTANDARDDESC,
      QUANTITY, QUANTITYCODE,
      UNITPRICE, FACTOR, PATIENTSHARE, PAYERSHARE, TAX, NET,
      ISPACKAGE, ISMATERNITY,
      STARTDATE, ENDDATE)
     VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"
  );
  if(!$insIt){ throw new RuntimeException("Prepare failed (items insert): ".$conn->error); }

  foreach ($ITEMS as $i=>$it){
    // التقط من أكثر من اسم مفتاح
    $seq        = (int)($it['seq'] ?? 0); if($seq<=0) $seq = $i+1;
    $invoiceNo  = t(($it['invoiceNo'] ?? $it['invoice'] ?? $EPISODEID), 40);

    // فكّ "CODE — DESC" لو وصل نص واحد
    $rawStd = $it['STD_CODE_DESC'] ?? $it['STD_CODE'] ?? null;
    if ($rawStd && (!($it['code']??'') || !($it['desc']??''))) {
      if (preg_match('/^\s*([A-Za-z0-9.\-]+)\s*—\s*(.+)$/u', $rawStd, $m)) {
        $it['code'] = $it['code'] ?? $m[1];
        $it['desc'] = $it['desc'] ?? $m[2];
      } else {
        $it['code'] = $it['code'] ?? $rawStd;
      }
    }

    $svcType    = t(($it['type'] ?? $it['SERVICE_TYPE'] ?? ''), 32);
    $svcCode    = t(($it['code'] ?? $it['SERVICECODE'] ?? $it['SERVICE_CODE'] ?? ''), 30);
    $svcDesc    = t(($it['desc'] ?? $it['SERVICEDESC'] ?? $it['SERVICE_DESC'] ?? ''), 255);

    $nsc        = t(($it['nonStdCode'] ?? $it['NON_STANDARD_CODE'] ?? $it['NONSTANDARDCODE'] ?? null), 30);
    $nsd        = t(($it['nonStdDesc'] ?? $it['NON_STANDARD_DESC'] ?? $it['NONSTANDARDDESC'] ?? null), 255);

    $qty        = isset($it['qty']) ? (float)$it['qty'] : (float)($it['QUANTITY'] ?? 1);
    $qtyCode    = t(($it['qtyType'] ?? $it['QUANTITYCODE'] ?? 'Unit'), 20);

    $unitPrice  = isset($it['unitPrice']) ? (float)$it['unitPrice']
                  : (float)($it['UNITPRICE'] ?? $it['unit'] ?? $it['price'] ?? 0);
    $factor     = (float)($it['factor'] ?? $it['FACTOR'] ?? 1);
    $patient    = (float)($it['patientShare'] ?? $it['PATIENTSHARE'] ?? $it['benefit'] ?? 0);
    $payer      = (float)($it['payerShare'] ?? $it['PAYERSHARE'] ?? 0);
    $tax        = (float)($it['tax'] ?? $it['TAX'] ?? 0);
    $disc       = (float)($it['discount'] ?? $it['DISCOUNT'] ?? 0);

    $net        = isset($it['net']) ? (float)$it['net']
                  : (float)max(0, $qty * $unitPrice * $factor - $disc);

    $startDate  = to_mysql_dt($it['startDate'] ?? $it['STARTDATE'] ?? null);
    $endDate    = to_mysql_dt($it['endDate']   ?? $it['ENDDATE']   ?? null);
    if ($startDate === null) $startDate = ($BILLABLEPERIODSTART ?: $CLAIMCREATEDDATE);
    if ($endDate   === null) $endDate   = $startDate;

    $isPackage   = in_array(($it['isPackage'] ?? 'false'),   [true,1,'1','true'], true) ? 'true':'false';
    $isMaternity = in_array(($it['isMaternity'] ?? 'false'), [true,1,'1','true'], true) ? 'true':'false';

    $insIt->bind_param(
      "ssisssssdsddddddssss",
      $PROVCLAIMNO, $invoiceNo, $seq,
      $svcType, $svcCode, $svcDesc,
      $nsc, $nsd,
      $qty, $qtyCode,
      $unitPrice, $factor, $patient, $payer, $tax, $net,
      $isPackage, $isMaternity,
      $startDate, $endDate
    );
    if(!$insIt->execute()){
      throw new RuntimeException("Execute failed (items insert): ".$insIt->error);
    }
  }
  $insIt->close();
} // إذا ما فيه ITEMS لا نلمس الجدول
/* ---------------------------------------------------------------------- */

/* 6.x) Item Diagnosis — مطابق لبنية NPHIES_ITEMDIAGNOSIS (3 أعمدة) */

// امسح القديم
$delIDx = $conn->prepare("DELETE FROM `NPHIES_ITEMDIAGNOSIS` WHERE PROVCLAIMNO=?");
if(!$delIDx){ throw new RuntimeException("Prepare failed (itemdiagnosis delete): ".$conn->error); }
$delIDx->bind_param("s", $PROVCLAIMNO);
if(!$delIDx->execute()){ throw new RuntimeException("Execute failed (itemdiagnosis delete): ".$delIDx->error); }
$delIDx->close();

// اجلب جميع أرقام الـ Diagnosis (SEQUENCENO) الخاصة بهذه المطالبة
$diagSeqs = [];
$selDx = $conn->prepare(
  "SELECT SEQUENCENO FROM `NPHIES_CLAIMDIAGNOSIS`
   WHERE PROVCLAIMNO=? ORDER BY SEQUENCENO"
);
if(!$selDx){ throw new RuntimeException("Prepare failed (claim diagnosis select): ".$conn->error); }
$selDx->bind_param("s", $PROVCLAIMNO);
if(!$selDx->execute()){ throw new RuntimeException("Execute failed (claim diagnosis select): ".$selDx->error); }

if (method_exists($selDx,'get_result') && ($res=$selDx->get_result())) {
  while($r=$res->fetch_assoc()){ $diagSeqs[] = (int)$r['SEQUENCENO']; }
} else {
  $tmp=null; $selDx->bind_result($tmp);
  while($selDx->fetch()){ $diagSeqs[] = (int)$tmp; }
}
$selDx->close();

// لا تُكمل إن لم يوجد تشخيصات أو بنود
if ($diagSeqs && $ITEMS){

  // JSON اختياري لتحديد الربط: 
  // [{ITEMSEQUENCENO:1, DIAGNOSISSEQUENCENO:2}, {item_seq:2, diagnosis_seq:1}, ...]
  $item_dx_json = post('item_diagnosis_json','[]');
  $mapArr = json_decode($item_dx_json, true);
  $mapByItem = [];
  if (is_array($mapArr)) {
    foreach ($mapArr as $r){
      $itSeq = (int)($r['ITEMSEQUENCENO'] ?? $r['item_seq'] ?? 0);
      $dxSeq = (int)($r['DIAGNOSISSEQUENCENO'] ?? $r['diagnosis_seq'] ?? 0);
      if ($itSeq>0 && $dxSeq>0) $mapByItem[$itSeq][] = $dxSeq;
    }
  }

  // إدراج العلاقات
  $insIDx = $conn->prepare(
    "INSERT INTO `NPHIES_ITEMDIAGNOSIS`
     (PROVCLAIMNO, DIAGNOSISSEQUENCENO, ITEMSEQUENCENO)
     VALUES (?,?,?)"
  );
  if(!$insIDx){ throw new RuntimeException("Prepare failed (itemdiagnosis insert): ".$conn->error); }

  foreach ($ITEMS as $i=>$it){
    $itemSeq = (int)($it['seq'] ?? ($i+1));
    if ($itemSeq <= 0) continue;

    // إن لم يُرسل JSON: اربط كل التشخيصات بكل بند (يمكنك تغييره لأول تشخيص فقط إن أردت)
    $theseDx = $mapByItem[$itemSeq] ?? $diagSeqs;   // أو استخدم: [$diagSeqs[0]]

    foreach ($theseDx as $dxSeq){
      $dxSeq = (int)$dxSeq;
      if ($dxSeq <= 0) continue;
      $insIDx->bind_param("sii", $PROVCLAIMNO, $dxSeq, $itemSeq);
      if(!$insIDx->execute()){
        throw new RuntimeException("Execute failed (itemdiagnosis insert): ".$insIDx->error);
      }
    }
  }
  $insIDx->close();
}

/* 6) Item CareTeam — مطابق لبنية جدول NPHIES_ITEMCARETEAM (3 أعمدة فقط) */

// 1) امسح القديم
$delIct = $conn->prepare("DELETE FROM `NPHIES_ITEMCARETEAM` WHERE PROVCLAIMNO=?");
if(!$delIct){ throw new RuntimeException("Prepare failed (itemcareteam delete): ".$conn->error); }
$delIct->bind_param("s",$PROVCLAIMNO);
if(!$delIct->execute()){ throw new RuntimeException("Execute failed (itemcareteam delete): ".$delIct->error); }
$delIct->close();

// 2) اجلب أرقام الـ CareTeam الخاصة بالمطالبة من جدول NPHIES_CLAIMCARETEAM
$ctSeqs = [];
$selCT = $conn->prepare("SELECT SEQUENCENO FROM `NPHIES_CLAIMCARETEAM` WHERE PROVCLAIMNO=? ORDER BY SEQUENCENO");
if(!$selCT){ throw new RuntimeException("Prepare failed (claim CT select): ".$conn->error); }
$selCT->bind_param("s",$PROVCLAIMNO);
if(!$selCT->execute()){ throw new RuntimeException("Execute failed (claim CT select): ".$selCT->error); }

if (method_exists($selCT,'get_result') && ($res=$selCT->get_result())) {
  while($r=$res->fetch_assoc()){ $ctSeqs[] = (int)$r['SEQUENCENO']; }
} else {
  $tmp=null; $selCT->bind_result($tmp);
  while($selCT->fetch()){ $ctSeqs[] = (int)$tmp; }
}
$selCT->close();
if (!$ctSeqs) { $ctSeqs = [1]; }  // افتراضيًا اربط بعنصر كيرتيم رقم 1 إن لم يوجد

// 3) دعم JSON اختياري لتحديد الربط لكل بند: [{ITEMSEQUENCENO:1, CARETEAMSEQUENCENO:2}, ...]
$item_ct_map_json = post('item_careteam_json','[]');
$mapArr = json_decode($item_ct_map_json, true);
$mapByItem = [];
if (is_array($mapArr)) {
  foreach ($mapArr as $r){
    $itSeq = (int)($r['ITEMSEQUENCENO'] ?? $r['item_seq'] ?? 0);
    $ctSeq = (int)($r['CARETEAMSEQUENCENO'] ?? $r['careteam_seq'] ?? 0);
    if ($itSeq>0 && $ctSeq>0) $mapByItem[$itSeq][] = $ctSeq;
  }
}

// 4) أدخل الروابط (Claim ↔ ItemSeq ↔ CareTeamSeq) للأصناف الموجودة
if ($ITEMS){
  $insIct = $conn->prepare(
    "INSERT INTO `NPHIES_ITEMCARETEAM`
     (PROVCLAIMNO, CARETEAMSEQUENCENO, ITEMSEQUENCENO)
     VALUES (?,?,?)"
  );
  if(!$insIct){ throw new RuntimeException("Prepare failed (itemcareteam insert): ".$conn->error); }

  foreach ($ITEMS as $i=>$it){
    $itemSeq = (int)($it['seq'] ?? ($i+1));
    if ($itemSeq <= 0) continue;

    // إن كان هناك خريطة مخصصة للبند استخدمها، وإلا اربطه بكل صفوف Claim CT
    $thisItemCTs = $mapByItem[$itemSeq] ?? $ctSeqs;
    foreach ($thisItemCTs as $ct){
      $ct = (int)$ct ?: 1;
      $insIct->bind_param("sii", $PROVCLAIMNO, $ct, $itemSeq);
      if(!$insIct->execute()){
        throw new RuntimeException("Execute failed (itemcareteam insert): ".$insIct->error);
      }
    }
  }
  $insIct->close();
}

/* 6.y) Item → Supporting Info (NPHIES_ITEMSUPPORTINGINFO: 3 أعمدة) */

/* امسح أي ربط قديم */
$delISup = $conn->prepare("DELETE FROM `$T_ITEMSUP` WHERE PROVCLAIMNO=?");
if(!$delISup){ throw new RuntimeException("Prepare failed (item-supporting delete): ".$conn->error); }
$delISup->bind_param("s", $PROVCLAIMNO);
if(!$delISup->execute()){ throw new RuntimeException("Execute failed (item-supporting delete): ".$delISup->error); }
$delISup->close();

/* اجلب جميع SEQUENCENO من جدول المطالبة NPHIES_CLAIMSUPPORTINGINFO */
$supSeqs = [];
$selSup = $conn->prepare("SELECT SEQUENCENO FROM `$T_SUP` WHERE PROVCLAIMNO=? ORDER BY SEQUENCENO");
if(!$selSup){ throw new RuntimeException("Prepare failed (claim supporting select): ".$conn->error); }
$selSup->bind_param("s", $PROVCLAIMNO);
if(!$selSup->execute()){ throw new RuntimeException("Execute failed (claim supporting select): ".$selSup->error); }

if (method_exists($selSup, 'get_result') && ($res = $selSup->get_result())) {
  while($r = $res->fetch_assoc()){ $supSeqs[] = (int)$r['SEQUENCENO']; }
} else {
  $tmp = null; $selSup->bind_result($tmp);
  while($selSup->fetch()){ $supSeqs[] = (int)$tmp; }
}
$selSup->close();

/* لا تكمل إذا ما عندك Supporting Info أو ما عندك Items */
if ($supSeqs && $ITEMS) {

  /* JSON اختياري لتحديد الربط يدويًا:
     مثال القيمة:
     [
       {"ITEMSEQUENCENO":1,"SUPPORTINGINFOSEQUENCENO":2},
       {"ITEMSEQUENCENO":2,"SUPPORTINGINFOSEQUENCENO":1}
     ]
  */
  $item_sup_json = post('item_supporting_json','[]');
  $mapArr = json_decode($item_sup_json, true);
  $mapByItem = [];
  if (is_array($mapArr)) {
    foreach ($mapArr as $r){
      $itSeq  = (int)($r['ITEMSEQUENCENO'] ?? $r['item_seq'] ?? 0);
      $supSeq = (int)($r['SUPPORTINGINFOSEQUENCENO'] ?? $r['support_seq'] ?? 0);
      if ($itSeq>0 && $supSeq>0) $mapByItem[$itSeq][] = $supSeq;
    }
  }

  $insISup = $conn->prepare(
    "INSERT INTO `$T_ITEMSUP`
     (PROVCLAIMNO, SUPPORTINGINFOSEQUENCENO, ITEMSEQUENCENO)
     VALUES (?,?,?)"
  );
  if(!$insISup){ throw new RuntimeException("Prepare failed (item-supporting insert): ".$conn->error); }

  foreach ($ITEMS as $i=>$it){
    $itemSeq = (int)($it['seq'] ?? ($i+1));
    if ($itemSeq <= 0) continue;

    /* الافتراضي: اربط كل بند بأول صف Supporting فقط لتفادي التضاعف.
       لو حاب تربط "كل" الصفوف بكل بند، استبدل السطر التالي بـ: $supSeqs */
    $theseSup = $mapByItem[$itemSeq] ?? ( $supSeqs ? [$supSeqs[0]] : [] );

    foreach ($theseSup as $supSeq){
      $supSeq = (int)$supSeq;
      if ($supSeq <= 0) continue;
      $insISup->bind_param("sii", $PROVCLAIMNO, $supSeq, $itemSeq);
      if(!$insISup->execute()){
        throw new RuntimeException("Execute failed (item-supporting insert): ".$insISup->error);
      }
    }
  }
  $insISup->close();
}


  /* 7) Encounter */
  $delEnc = $conn->prepare("DELETE FROM `$T_ENC` WHERE PROVCLAIMNO=?");
  if(!$delEnc){ throw new RuntimeException("Prepare failed (encounter delete): ".$conn->error); }
  $delEnc->bind_param("s", $PROVCLAIMNO);
  if(!$delEnc->execute()){ throw new RuntimeException("Execute failed (encounter delete): ".$delEnc->error); }
  $delEnc->close();

  $insEnc = $conn->prepare(
    "INSERT INTO `$T_ENC`
     (PROVCLAIMNO, ENCOUNTERID,
      ENCOUNTERSTARTDATE, ENCOUNTERENDDATE,
      ENCOUNTERCLASS, ENCOUNTERSERVICETYPE, PRIORITY, SERVICEPROVIDER,
      ENCOUNTERSTATUS, CAUSEOFDEATH, SERVICEEVENTTYPE)
     VALUES (?,?,?,?,?,?,?,?,?,?,?)"
  );
  if(!$insEnc){ throw new RuntimeException("Prepare failed (encounter insert): ".$conn->error); }
  $insEnc->bind_param(
    "sssssssssss",
    $PROVCLAIMNO, $ENC_ID,
    $ENC_START, $ENC_END,
    $ENC_CLASS, $ENC_SVCTYPE, $ENC_PRIORITY, $SERVICEPROVIDER,
    $ENC_STATUS, $ENC_COD, $ENC_EVENTTYPE
  );
  if(!$insEnc->execute()){
    throw new RuntimeException("Execute failed (encounter insert): ".$insEnc->error);
  }
  $insEnc->close();

  /* تمّ */
  $conn->commit();

  // إعادة توجيه
  $qs = http_build_query([
    'provclaimno'   => $PROVCLAIMNO,
    'beneficiaryid' => $BENEFICIARYID,
    'saved'         => 1
  ]);
  header("Location: viewclaim.php?{$qs}");
  exit;

} catch (Throwable $e) {
  $conn->rollback();
  http_response_code(500);
  echo "<h3>فشل الحفظ</h3>";
  echo "<pre style='white-space:pre-wrap;direction:ltr'>".$e->getMessage()."</pre>";
} finally {
  if(!$have_external_conn) $conn->close();
}

