<?php include 'sessionheaderrecption.php'; ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Reception ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->

</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
 <?php include 'receptionheader.php'; ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
         <!-- Sidebar user panel -->
    <?php include 'receptionsidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenureception.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#"> Installments scheduling Customer</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title"> Installments scheduling Customer</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
      
            <div class="box-header">
              <h3 class="box-title"> </h3>
            </div>
            <!-- /.box-header -->

            
                
<?php
/****************************************************
 * حفظ خطة الأقساط — مع typeservice
 * يدعم:
 * - typeservice واحد لكل الجدولة  =>  <input name="typeservice" ...>
 * - أو typeservice لكل قسط        =>  <input name="typeservice[]" ...>
 * الأعمدة المستهدفة:
 * (customerid, serviceid, typeservice, installmentamount, userschauled, dateschauled, payment_status, fileid)
 ****************************************************/

include 'db_connection.php'; // يجب أن يعرّف $conn (mysqli)

// تأكد من الاتصال
if (!isset($conn) || !($conn instanceof mysqli)) {
    die("<h3 style='color:red;text-align:center;'>لا يوجد اتصال بقاعدة البيانات. تأكد من db_connection.php</h3>");
}

// دالة: تحويل الأرقام العربية إلى إنجليزية + تنظيف الفواصل لإرجاع رقم عشري صالح
function normalize_amount($value) {
    if ($value === null) return null;

    // تحويل الأرقام العربية إلى إنجليزية
    $arabic_nums = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩'];
    $latin_nums  = ['0','1','2','3','4','5','6','7','8','9'];
    $value = str_replace($arabic_nums, $latin_nums, (string)$value);

    $value = trim($value);
    // توحيد الفاصل العشري العربي
    $value = str_replace('٫', '.', $value);

    // معالجة الفواصل: إذا فيه نقطة نعتبر كل الفواصل فواصل آلاف ونحذفها
    if (strpos($value, '.') !== false) {
        $value = str_replace([',','٬','،',' '], '', $value);
    } else {
        $commaCount = substr_count($value, ',') + substr_count($value, '٬') + substr_count($value, '،');
        if ($commaCount === 1) {
            $value = str_replace([',','٬','،'], '.', $value);
        } else {
            $value = str_replace([',','٬','،',' '], '', $value);
        }
    }

    // أبقِ فقط الأرقام والنقطة والعلامة السالبة
    $value = preg_replace('/[^0-9\.\-]/', '', $value);

    if ($value === '' || $value === '-' || $value === '.' || $value === '-.' ) {
        return null;
    }

    return (float)$value;
}

// التحقق من استقبال البيانات الأساسية
if (
    !isset($_POST['customerid'], $_POST['proudctid'], $_POST['id'], $_POST['amounts'], $_POST['dates'], $_POST['payment_status'])
) {
    die("<h3 style='color:red;text-align:center;'>بيانات غير مكتملة! (customerid, proudctid, id, amounts[], dates[], payment_status[])</h3>");
}

// قراءة الحقول الرئيسية
$id          = trim((string)$_POST['id']);          // fileid
$customerid  = trim((string)$_POST['customerid']);  // قد يكون رقم/نص
$serviceid   = trim((string)$_POST['proudctid']);   // serviceid (اسم الحقل حسب كودك)
$user        = $_SESSION["iduser"];                         // المستخدم الذي أضاف الجدولة

// المصفوفات
$amounts  = $_POST['amounts'];
$dates    = $_POST['dates'];
$statuses = $_POST['payment_status'];

// typeservice قد يأتي كنص واحد أو كمصفوفة
$typeservice_input = $_POST['typeservice'] ?? null;

// تحقق من أن هذه الحقول مصفوفات
if (!is_array($amounts) || !is_array($dates) || !is_array($statuses)) {
    die("<h3 style='color:red;text-align:center;'>صيغة الحقول amounts[] و dates[] و payment_status[] غير صحيحة!</h3>");
}

// تحقق من الطول المتساوي للمصفوفات
$rowsCount = min(count($amounts), count($dates), count($statuses));
if ($rowsCount === 0) {
    die("<h3 style='color:red;text-align:center;'>لا توجد أقساط لإدخالها!</h3>");
}

// تحقق من الحقول الرئيسية
if ($customerid === '' || $serviceid === '' || $id === '') {
    die("<h3 style='color:red;text-align:center;'>جميع الحقول الرئيسية (العميل/الخدمة/الملف) مطلوبة!</h3>");
}

// جهّز الاستعلام مع الحقل الجديد typeservice
$sql = "INSERT INTO installments
        (customerid, serviceid, typeservice, installmentamount, userschauled, dateschauled, payment_status, fileid)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("<h3 style='color:red;text-align:center;'>فشل تجهيز الاستعلام: " . htmlspecialchars($conn->error, ENT_QUOTES, 'UTF-8') . "</h3>");
}

// معاملة (Transaction) لضمان الإدخالات
$conn->begin_transaction();

try {
    // متغيرات الربط — bind_param يربط بالمرجع
    $bind_customerid       = $customerid;        // s
    $bind_serviceid        = $serviceid;         // s
    $bind_typeservice      = '';                 // s
    $bind_installmentamount= 0.0;                // d
    $bind_userschauled     = $user;              // s
    $bind_dateschauled     = '';                 // s
    $bind_payment_status   = '';                 // s
    $bind_fileid           = $id;                // s

    // أنواع الحقول: sssdssss (customerid, serviceid, typeservice, amount(d), user, date, status, fileid)
    $stmt->bind_param(
        "sssdssss",
        $bind_customerid,
        $bind_serviceid,
        $bind_typeservice,
        $bind_installmentamount,
        $bind_userschauled,
        $bind_dateschauled,
        $bind_payment_status,
        $bind_fileid
    );

    $inserted = 0;

    for ($i = 0; $i < $rowsCount; $i++) {
        // أصل قيم السطر
        $rawAmount  = $amounts[$i]   ?? null;
        $rawDate    = $dates[$i]     ?? null;
        $rawStatus  = $statuses[$i]  ?? null;

        // typeservice: إن كان مصفوفة نأخذ المقابل، إن كان نصًّا واحدًا نستخدمه للجميع
        if (is_array($typeservice_input)) {
            $bind_typeservice = trim((string)($typeservice_input[$i] ?? ''));
        } else {
            $bind_typeservice = trim((string)$typeservice_input);
        }

        // تنظيف وتحويل المبلغ
        $bind_installmentamount = normalize_amount($rawAmount);
        $bind_dateschauled      = trim((string)$rawDate);
        $bind_payment_status    = trim((string)$rawStatus);

        // شرط الإدراج
        if ($bind_installmentamount === null || $bind_dateschauled === '') {
            continue; // تخطّي السطر إن كان ناقصًا
        }

        // افتراضيًا اجعل typeservice فارغًا لو لم يُرسل
        if ($bind_typeservice === null) {
            $bind_typeservice = '';
        }

        if (!$stmt->execute()) {
            throw new Exception("فشل إدراج قسط رقم ".($i+1).": " . $stmt->error);
        }

        $inserted += $stmt->affected_rows;
    }

    if ($inserted === 0) {
        $conn->rollback();
        echo "<h3 style='color:red;text-align:center;'>لم يتم إدراج أي قسط. تأكد من تعبئة المبالغ والتواريخ ونوع الخدمة (إن لزم) بشكل صحيح.</h3>";
    } else {
        $conn->commit();
        echo "
        <div class='alert alert-success alert-dismissible'>
            <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>×</button>
            <h4><i class='icon fa fa-check'></i> ممتاز تمت ال جدولة بنجاح </h4>
            <h3 style='text-align:center;color:white;'>تم حفظ  جدول الأقساط  بنجاح — عدد السجلات: {$inserted}</h3>
        </div>";
    }

} catch (Exception $e) {
    $conn->rollback();
    echo "<h3 style='color:red;text-align:center;'>حدث خطأ أثناء الحفظ: " . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8') . "</h3>";
} finally {
    $stmt->close();
    $conn->close();
}
?>


        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
