<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>البحث عن الخدمات</title>
    <style>
        body { font-family: Arial; direction: rtl; text-align: right; padding: 20px; }
        input { margin: 5px; padding: 8px; width: 200px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ccc; padding: 10px; text-align: center; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>

<h2>بحث مباشر عن الخدمات</h2>

<input type="text" id="beneficiary_name" placeholder="اسم المستفيد" oninput="fetchResults()">
<input type="text" id="mobile" placeholder="رقم الجوال" oninput="fetchResults()">
<input type="text" id="idcustomer" placeholder="رقم الهوية" oninput="fetchResults()">
<input type="text" id="service_name" placeholder="اسم الخدمة" oninput="fetchResults()">
<br>
<label>من:</label>
<input type="date" id="date_from" onchange="fetchResults()">
<label>إلى:</label>
<input type="date" id="date_to" onchange="fetchResults()">

<div id="results"></div>

<script>
function fetchResults() {
    let name = document.getElementById('beneficiary_name').value;
    let mobile = document.getElementById('mobile').value;
    let id = document.getElementById('idcustomer').value;
    let service = document.getElementById('service_name').value;
    let dateFrom = document.getElementById('date_from').value;
    let dateTo = document.getElementById('date_to').value;

    let xhr = new XMLHttpRequest();
    xhr.open("POST", "search.php", true);
    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");

    let params = `beneficiary_name=${encodeURIComponent(name)}&mobile=${encodeURIComponent(mobile)}&idcustomer=${encodeURIComponent(id)}&service_name=${encodeURIComponent(service)}&date_from=${encodeURIComponent(dateFrom)}&date_to=${encodeURIComponent(dateTo)}`;

    xhr.onload = function () {
        if (xhr.status === 200) {
            document.getElementById("results").innerHTML = xhr.responseText;
        }
    };
    xhr.send(params);
}
// ✅ هذا السطر يجعل البحث يعمل تلقائيًا عند فتح الصفحة
window.onload = fetchResults;
</script>

</body>
</html>
