<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>البحث عن موعد متاح</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body class="bg-light">

<div class="container mt-5">
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">البحث عن موعد متاح</h4>
        </div>
        <div class="card-body">
            <form id="searchForm">
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label for="roomno">رقم الغرفة</label>
                        <input type="text" class="form-control" id="roomno" name="roomno" placeholder="أدخل رقم الغرفة">
                    </div>
                    <div class="form-group col-md-4">
                        <label for="period">اختر الفترة</label>
                        <select class="form-control" id="period" name="period">
                            <option value="">-- اختر الفترة --</option>
                            <option value="12-22">12:00 - 22:00</option>
                            <option value="12:30-22">12:30 - 22:00</option>
                            <option value="18-22">18:00 - 22:00</option>
                        </select>
                    </div>
                    <div class="form-group col-md-4">
                        <label for="date">اختر اليوم</label>
                        <input type="date" class="form-control" id="date" name="date" value="<?php echo date('Y-m-d'); ?>">
                    </div>
                </div>
                <button type="submit" class="btn btn-success btn-block">بحث</button>
            </form>
        </div>
    </div>

    <div class="mt-4" id="resultsArea"></div>
</div>

<script>
$(document).ready(function(){
    $("#searchForm").submit(function(e){
        e.preventDefault();
        var formData = $(this).serialize();

        $.ajax({
            url: "search_appointments_ajax.php",
            type: "POST",
            data: formData,
            beforeSend: function() {
                $("#resultsArea").html('<div class="text-center my-4"><div class="spinner-border text-primary" role="status"><span class="sr-only">جارٍ التحميل...</span></div></div>');
            },
            success: function(response) {
                $("#resultsArea").html(response);
            },
            error: function() {
                $("#resultsArea").html('<div class="alert alert-danger text-center">حدث خطأ أثناء الاتصال بالخادم.</div>');
            }
        });
    });
});
</script>

</body>
</html>
