<?php

//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);

$host = "localhost:3306";
$dbname = "acesaudi_site";
$username = "acesaudi_usr";
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("فشل الاتصال بقاعدة البيانات: " . $e->getMessage());
}

$from = $_GET['from'] ?? date('Y-m-d');
$to = $_GET['to'] ?? date('Y-m-d', strtotime('+7 days'));
$total_sessions = isset($_GET['total_session']) ? (int)$_GET['total_session'] : 1;
$patient_id = $_GET['patient_id'] ?? '';
$roomno = $_GET['roomno'] ?? '';
$patientname = $_GET['patient_name'] ?? '';
$serviceedid = $_GET['serviceedid'] ?? '';
$patient = $_GET['patient_id'] ?? '';
$typeservice = $_GET['typeservice'] ?? '';
$spesilstid = $_GET['spesilstid'] ?? '';

$slpno = $_GET['slpno'] ?? '';
$otno = $_GET['otno'] ?? '';
$abano = $_GET['abano'] ?? '';
$vrno = $_GET['vrno'] ?? '';

$startTime = '07:15:00';
$endTime = '23:00:00';
$slotDuration = 45; // بالدقائق

function generateTimeSlots($start, $end, $duration)
{
    $slots = [];
    $current = strtotime($start);
    $end = strtotime($end);

    while ($current + ($duration * 60) <= $end) {
        $slotStart = date('H:i', $current);
        $slotEnd = date('H:i', $current + ($duration * 60));
        $slots[] = [$slotStart, $slotEnd];
        $current += ($duration * 60);
    }
    return $slots;
}

$timeSlots = generateTimeSlots($startTime, $endTime, $slotDuration);

$dates = [];
$currentDate = strtotime($from);
$endDate = strtotime($to);

while ($currentDate <= $endDate) {
    $dates[] = date('Y-m-d', $currentDate);
    $currentDate = strtotime('+1 day', $currentDate);
}

$availableDays = [];
foreach ($dates as $date) {
    // جلب عدد الفترات المتاحة في نفس الغرفة
    $count = $pdo->prepare("SELECT COUNT(*) FROM bookings 
        WHERE booking_date = ? 
        AND bookingstatus = 'متوفر' 
        AND (patient_id IS NULL OR patient_id != ?) 
        AND room_id = ?");
    $count->execute([$date, $patient_id, $roomno]);
    $availableCount = $count->fetchColumn();

    if ($availableCount >= $total_sessions) {
        // جلب الفترات المتوفرة في نفس الغرفة
        $stmt = $pdo->prepare("SELECT * FROM bookings 
            WHERE booking_date = ? 
            AND bookingstatus = 'متوفر' 
            AND (patient_id IS NULL OR patient_id != ?) 
            AND room_id = ? 
            ORDER BY time_slot 
            LIMIT " . (int)$total_sessions);
        $stmt->execute([$date, $patient_id, $roomno]);
        $availableDays[$date] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

?>


<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
  <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">
      <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <title>تحديد الفترات</title>
        <style>
        body { font-family: 'Tajawal', sans-serif; background-color: #f4f6f9; }
        .form-inline .form-group { display: block; margin-bottom: 8px; }
        .form-inline .form-control { width: -moz-available; }
        .panel { margin-top: 20px; }
        .slot-card { background:  #cae8ca; border: 1px solid #ddd; padding: 15px; border-radius: 5px; margin-bottom: 10px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        .slot-card h5 { margin-top: 0; font-weight: bold; }
        .form-inline .form-control { width: auto; }
        .header-title { margin: 30px 0 20px; text-align: center; font-weight: bold; }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">

<div class="wrapper">


<?php include 'receptionheader.php'; ?>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'receptionsidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenureception.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains ppatient_name content -->
  <div class="content-wrapper">
    <!-- Content Header (Ppatient_name header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="receptiondashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Search By Appoiment</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title" style="font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease;">Filtiration Appoiments Info - فلترة الفترات حسب التاريخ وعدد الجلسات</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">

            <div class="col-md-12" style="text-align: center;">

<h3 style="font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease;">فلترة الفترات حسب التاريخ وعدد الجلسات</h3>



    <form method="GET" class="form-inline">
   
       <div class="col-md-12">
       
        <div class="col-md-6" style="width: 50%;padding: 22px;">

     <div class="form-group" style="display: block; margin-bottom: 8px;">
            <label>إلى تاريخ</label><br>
            <input type="date" name="to" class="form-control" value="<?= htmlspecialchars($to) ?>" required style=" width: -moz-available;">
        </div>
  
        <div class="form-group">
          <label> رقم ملف المستفيد  </label><br>
          <input type="text" name="patient_id" value="<?= htmlspecialchars($patient) ?>" required class="form-control" readonly style=" width: -moz-available;">
          </div>

     <div class="form-group">
          <label> نوع الخدمة  </label>
  <input type="text" name="typeservice" value="<?= htmlspecialchars($typeservice) ?>" required class="form-control" readonly style=" width: -moz-available;">
          </div>  
          
       <div class="form-group">
          <label> رقم الغرفة  </label>
  <input type="text" name="roomno" value="<?= htmlspecialchars($roomno) ?>" required class="form-control" readonly style=" width: -moz-available;">
          </div>

     </div>

    <div class="col-md-6" style="width: 50%;padding: 22px;">

     <div class="form-group">
            <label>من تاريخ</label><br>
            <input type="date" name="from" class="form-control" value="<?= htmlspecialchars($from) ?>" required style=" width: -moz-available;">
        </div>
  
     <div class="form-group">
          <label> المستفيد  </label><br>
          <input type="text" name="patient_name" value="<?= htmlspecialchars($patientname) ?>" required class="form-control" readonly style=" width: -moz-available;">
          </div>
  
            <div class="form-group">
          <label> رقم الخدمة  </label>
  <input type="text" name="serviceedid" value="<?= htmlspecialchars($serviceedid) ?>" required class="form-control" readonly style=" width: -moz-available;">
          </div>

            <div class="form-group">
          <label> رقم الأخصائي  </label>
  <input type="text" name="spesilstid" value="<?= htmlspecialchars($spesilstid) ?>" required class="form-control" readonly style=" width: -moz-available;">
          </div>

    </div>

       </div>

       <div class="col-md-12">
         <div class="from-group">
        <label>عدد الجلسات المطلوبة</label>
       <input type="number" name="total_session" class="form-control" min="1" value="<?= htmlspecialchars($total_sessions) ?>" required style=" width: -moz-available;"><br>
     </div>
       </div>

       <div class="col-md-12"><br></div>

        <div class="col-md-12">
          <button type="submit" class="btn btn-primary btn-block">بحث</button>
        </div>
       
         <div class="col-md-12"><br></div>
  

    </form>

    <div class="hasa"><br><br></div>

    <?php if (!empty($availableDays)): ?>
        <form method="POST" action="confirm_booking.php">
            <input type="hidden" name="patient_id" value="<?= htmlspecialchars($patient_id) ?>">
            <?php foreach ($availableDays as $date => $slots): ?>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <strong>تاريخ: <?= $date ?></strong>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <?php foreach ($slots as $slot): ?>
                                <div class="col-md-4">
                                    <div class="slot-card">
                                        <div class="checkbox">
                                            <label>
                                                <input type="checkbox" name="selected_slots[]" value="<?= $slot['id'] ?>">
                                                <strong><?= $slot['booking_date'] ?></strong><br>
                                                من <strong><?= $slot['time_slot'] ?></strong> إلى <strong><?= $slot['end_time'] ?></strong><br>
                                                الغرفة: <?= $slot['room_id'] ?><br>
                                                الأخصائي: <?= $slot['spclistsname'] ?? 'غير معروف' ?>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            <div class="text-center">
                <button type="submit" class="btn btn-success btn-lg">تأكيد الحجز</button>
            </div>
        </form>
    <?php else: ?>
        <div class="alert alert-warning text-center">لا توجد فترات متاحة حسب المدخلات.</div>
    <?php endif; ?>


</div>
</body>
</html>
