<?php
// search_services.php
mb_internal_encoding('UTF-8');
header('Content-Type: application/json; charset=utf-8');

$have_external_conn = false;
if (file_exists(__DIR__ . '/conn.php')) {
  include __DIR__ . '/conn.php';
  if (isset($conn) && $conn instanceof mysqli) $have_external_conn = true;
}
if (!$have_external_conn) {
  $conn = new mysqli('localhost', 'acesaudi_usr', 'tabfyv-6xiFry-noczak', 'acesaudi_site');
  if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'DB connection failed'], JSON_UNESCAPED_UNICODE);
    exit;
  }
  $conn->set_charset('utf8mb4');
}

$q  = trim($_GET['q'] ?? '');
$ins = trim($_GET['insurancecompanyid'] ?? '');
$limit = (int)($_GET['limit'] ?? 20);
if ($limit < 1 || $limit > 100) $limit = 20;

if ($q === '') {
  echo json_encode(['ok'=>true, 'results'=>[]], JSON_UNESCAPED_UNICODE);
  exit;
}

$sql = "SELECT
          service_id,
          insurancecompanyid,
          insurancecompanyname,
          SERVICE_TYPE,
          SERVICE_CODE,
          NON_STANDARD_CODE,
          service_name_ar,
          service_name_en,
          NON_STANDARD_DESC,
          UNIT_PRICE,
          specialty,
          FACTOR
        FROM insuranceservices
        WHERE
          (
            SERVICE_CODE LIKE ?
            OR NON_STANDARD_CODE LIKE ?
            OR service_name_ar LIKE ?
            OR service_name_en LIKE ?
          )";

$params = [];
$types  = "ssss";
$qLike  = "%$q%";
$params = [$qLike, $qLike, $qLike, $qLike];

if ($ins !== '') {
  $sql .= " AND insurancecompanyid = ?";
  $types .= "s";
  $params[] = $ins;
}

$sql .= " ORDER BY
            (service_name_ar <> '') DESC,
            service_name_ar ASC,
            service_name_en ASC
          LIMIT ?";

$types .= "i";
$params[] = $limit;

$stmt = $conn->prepare($sql);
if (!$stmt) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>$conn->error], JSON_UNESCAPED_UNICODE);
  exit;
}
$stmt->bind_param($types, ...$params);
$stmt->execute();
$res = $stmt->get_result();

$out = [];
while ($r = $res->fetch_assoc()) {
  $out[] = [
    'service_id'           => (int)$r['service_id'],
    'insurancecompanyid'   => (string)$r['insurancecompanyid'],
    'insurancecompanyname' => (string)$r['insurancecompanyname'],
    'type'                 => (string)$r['SERVICE_TYPE'],
    'code'                 => (string)$r['SERVICE_CODE'],
    'non_code'             => (string)$r['NON_STANDARD_CODE'],
    'name_ar'              => (string)$r['service_name_ar'],
    'name_en'              => (string)$r['service_name_en'],
    'desc'                 => (string)$r['NON_STANDARD_DESC'],
    'price'                => (float)$r['UNIT_PRICE'],
    'specialty'            => (string)$r['specialty'],
    'factor'               => (string)$r['FACTOR'],
  ];
}
$stmt->close();

echo json_encode(['ok'=>true, 'results'=>$out], JSON_UNESCAPED_UNICODE);
