<?php
ini_set('memory_limit', '1024M');
ini_set('max_execution_time', 300);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php'; // PHPMailer
require_once 'tcpdf/tcpdf.php'; // TCPDF

// الاتصال بقاعدة البيانات
$conn = new mysqli("localhost:3306", "acesaudi_usr", 'tabfyv-6xiFry-noczak', "acesaudi_site");
$conn->set_charset("utf8");
if ($conn->connect_error) {
    die("فشل الاتصال: " . $conn->connect_error);
}

$specialist_id = '165'; 
$today = date('Y-m-d');
$bookstatus = 'محجوز';
$patient_id = '2184261119';

// ✅ الاستعلام الصحيح مع علامات استفهام إنجليزية
$sql = "SELECT * FROM bookings 
        WHERE spesilstid = ? AND bookingstatus LIKE ?
        ORDER BY time_slot ASC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $specialist_id, $bookstatus);
$stmt->execute();
$result = $stmt->get_result();

// ✅ بناء الجدول
$html = "<h3 style='font-family: DejaVu Sans;'>جدول مواعيد يوم: $today</h3>";
$html .= "<table border='1' cellpadding='5' cellspacing='0'>
<thead><tr>
<th>الحالة</th>
<th>الغرفة</th>
<th>إلى</th>
<th>من</th>
<th>الخدمة</th>
<th>المستفيد</th>
</tr></thead><tbody>";

while ($row = $result->fetch_assoc()) {
    $html .= "<tr>
     <td>{$row['bookingstatus']}</td>
     <td>{$row['room_id']}</td>
     <td>{$row['end_time']}</td>
     <td>{$row['time_slot']}</td>
     <td>{$row['typeservice']}</td>
     <td>{$row['patient_name']}</td>
    </tr>";
}
$html .= "</tbody></table>";

$stmt->close();
$conn->close();


// ✅ إنشاء ملف PDF
$pdf = new TCPDF();
$pdf->SetFont('dejavusans', '', 12);
$pdf->AddPage();
$pdf->writeHTML($html, true, false, true, false, '');

// ✅ تأكد من أن مجلد pdfs موجود
$pdfs_dir = __DIR__ . '/pdfs';
if (!is_dir($pdfs_dir)) {
    mkdir($pdfs_dir, 0777, true); // إنشاء المجلد إن لم يكن موجودًا
}

$filename = $pdfs_dir . '/appointments_' . $today . '.pdf';
$pdf->Output($filename, 'F'); // حفظ الملف فعليًا


// ✅ إرسال الإيميل
$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host       = 'mail.acesaudi.space';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'erp@acesaudi.space';
    $mail->Password   = 'Hh@0530677887';
    $mail->SMTPSecure = 'ssl';
    $mail->Port       = 465;

    $mail->setFrom('erp@acesaudi.space', 'عيادتنا');
    $mail->addAddress('haltohami@acesaudi.org', 'Test User');

    $mail->isHTML(true);
    $mail->CharSet = "UTF-8";
    $mail->Subject = "📌 جدول مواعيد الأخصائي لـ $today";
    $mail->Body    = $html;

    $mail->addAttachment($filename);

    $mail->send();
    echo "✅ تم إرسال الإيميل مع ملف PDF بنجاح.";

    unlink($filename); // حذف بعد الإرسال

} catch (Exception $e) {
    echo "❌ خطأ في الإرسال: {$mail->ErrorInfo}";
}
?>
