<?php
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

// ===== CSRF =====
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$CSRF = $_SESSION['csrf_token'];

// ===== DB Connection =====
$have_external_conn = false;
if (file_exists(__DIR__ . '/conn.php')) {
    include __DIR__ . '/conn.php';
    if (isset($conn) && $conn instanceof mysqli) { $have_external_conn = true; }
}
if (!$have_external_conn) {
    // عدّل هذه القيم إذا لم تستخدم conn.php
    $db_host = 'localhost';
    $db_user = 'acesaudi_site';
    $db_pass = 'tabfyv-6xiFry-noczak';
    $db_name = 'acesaudi_usr';
    $db_port = 3306;
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name, $db_port);
}
if ($conn->connect_error) { die('DB Error: ' . htmlspecialchars($conn->connect_error)); }
$conn->set_charset('utf8mb4');

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function arabic_to_english_digits($str) {
    $ar = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩','٫','٬','،'];
    $en = ['0','1','2','3','4','5','6','7','8','9','.','',','];
    return str_replace($ar, $en, (string)$str);
}
function clean_price($v) {
    $v = arabic_to_english_digits($v);
    $v = trim((string)$v);
    $v = str_replace([',', ' '], '', $v);
    $v = preg_replace('/[^0-9\.\-]/', '', $v);
    return $v;
}
function norm_factor_bit($v) {
    $v = (string)$v;
    return (ctype_digit($v) && (int)$v === 0) ? 0 : 1;
}

// ===== Load row =====
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) { die('<h3 style="color:#b00">معرّف غير صالح.</h3>'); }

$stmt = $conn->prepare("SELECT service_id, insurancecompanyid, insurancecopmanyname, SERVICE_CODE, NON_STANDARD_CODE, SERVICE_TYPE,
                               service_name_ar, service_name_en, NON_STANDARD_DESC, UNIT_PRICE, specialty, FACTOR
                        FROM insuranceservices WHERE service_id=?");
$stmt->bind_param('i', $id);
$stmt->execute();
$service = $stmt->get_result()->fetch_assoc();
if (!$service) { die('<h3 style="color:#b00">الخدمة غير موجودة.</h3>'); }

// ===== Handle POST (update) =====
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!hash_equals($CSRF, $_POST['csrf'] ?? '')) {
        die('<h3 style="color:#b00">CSRF token غير صالح.</h3>');
    }

    $insurancecompanyid   = trim($_POST['insurancecompanyid'] ?? '');
    $insurancecopmanyname = trim($_POST['insurancecopmanyname'] ?? '');
    $SERVICE_CODE         = trim($_POST['SERVICE_CODE'] ?? '');
    $NON_STANDARD_CODE    = trim($_POST['NON_STANDARD_CODE'] ?? '');
    $SERVICE_TYPE         = trim($_POST['SERVICE_TYPE'] ?? '');
    $service_name_ar      = trim($_POST['service_name_ar'] ?? '');
    $service_name_en      = trim($_POST['service_name_en'] ?? '');
    $NON_STANDARD_DESC    = trim($_POST['NON_STANDARD_DESC'] ?? '');
    $UNIT_PRICE           = clean_price($_POST['UNIT_PRICE'] ?? '');
    $specialty            = trim($_POST['specialty'] ?? '');
    $FACTOR               = norm_factor_bit($_POST['FACTOR'] ?? '1');

    // تحقق بسيط
    $errors = [];
    if ($insurancecompanyid === '' || $insurancecopmanyname === '' || $SERVICE_CODE === '') {
        $errors[] = 'حقول (رقم الشركة، اسم الشركة، كود الخدمة) مطلوبة.';
    }
    if (!empty($UNIT_PRICE) && !is_numeric($UNIT_PRICE)) {
        $errors[] = 'السعر غير صالح.';
    }

    if (!$errors) {
        $sql = "UPDATE insuranceservices SET
                    insurancecompanyid=?,
                    insurancecopmanyname=?,
                    SERVICE_CODE=?,
                    NON_STANDARD_CODE=?,
                    SERVICE_TYPE=?,
                    service_name_ar=?,
                    service_name_en=?,
                    NON_STANDARD_DESC=?,
                    UNIT_PRICE=NULLIF(?,''), 
                    specialty=?,
                    FACTOR=?
                WHERE service_id=?";
        $upd = $conn->prepare($sql);
        $upd->bind_param(
            'ssssssssssii',
            $insurancecompanyid,
            $insurancecopmanyname,
            $SERVICE_CODE,
            $NON_STANDARD_CODE,
            $SERVICE_TYPE,
            $service_name_ar,
            $service_name_en,
            $NON_STANDARD_DESC,
            $UNIT_PRICE,
            $specialty,
            $FACTOR,
            $id
        );
        if ($upd->execute()) {
            $msg = 'تم حفظ التعديلات بنجاح.';
            // إعادة تحميل البيانات المحدثة
            $stmt = $conn->prepare("SELECT service_id, insurancecompanyid, insurancecopmanyname, SERVICE_CODE, NON_STANDARD_CODE, SERVICE_TYPE,
                                           service_name_ar, service_name_en, NON_STANDARD_DESC, UNIT_PRICE, specialty, FACTOR
                                    FROM insuranceservices WHERE service_id=?");
            $stmt->bind_param('i', $id);
            $stmt->execute();
            $service = $stmt->get_result()->fetch_assoc();
        } else {
            $errors[] = 'فشل حفظ التعديلات: ' . $upd->error;
        }
    }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>تعديل خدمة #<?= (int)$service['service_id'] ?></title>
<style>
body{font-family:Tahoma,Arial;margin:20px}
.box{border:1px solid #ddd;border-radius:8px;padding:15px;max-width:900px}
.row{display:flex;gap:12px}
.col{flex:1}
label{display:block;margin:6px 0 4px}
input[type=text], textarea, select{width:100%;padding:8px}
.msg{padding:8px 12px;border-radius:6px;margin:10px 0}
.ok{background:#f6ffed;border:1px solid #b7eb8f;color:#135200}
.err{background:#fff1f0;border:1px solid #ffa39e;color:#a8071a}
small.mono{font-family:monospace;color:#666}
.actions a, .actions button{margin-inline-end:8px}
</style>
</head>
<body>

<div class="box" style="max-width: 1830px;">
    <div class="actions" style="margin-bottom:10px">
        <a href="services_list.php">← رجوع للقائمة</a>
        <span class="mono">خدمة #<?= (int)$service['service_id'] ?></span>
    </div>

    <?php if (!empty($msg)): ?>
        <div class="msg ok"><?= h($msg) ?></div>
    <?php endif; ?>
    <?php if (!empty($errors ?? [])): ?>
        <div class="msg err"><ul><?php foreach($errors as $e){ echo '<li>'.h($e).'</li>'; } ?></ul></div>
    <?php endif; ?>

    <form method="post">
        <input type="hidden" name="csrf" value="<?= h($CSRF) ?>">

        <div class="row">
            <div class="col">
                <label>رقم شركة التأمين (insurancecompanyid)</label>
                <input type="text" name="insurancecompanyid" value="<?= h($service['insurancecompanyid']) ?>">
            </div>
            <div class="col">
                <label>اسم شركة التأمين (insurancecopmanyname)</label>
                <input type="text" name="insurancecopmanyname" value="<?= h($service['insurancecopmanyname']) ?>">
            </div>
            <div class="col">
                <label>الحالة (FACTOR)</label>
                <select name="FACTOR">
                    <option value="1" <?= ((int)$service['FACTOR']===1?'selected':'') ?>>مفعل</option>
                    <option value="0" <?= ((int)$service['FACTOR']===0?'selected':'') ?>>معطل</option>
                </select>
            </div>
        </div>

        <div class="row">
            <div class="col">
                <label>كود الخدمة (SERVICE_CODE)</label>
                <input type="text" name="SERVICE_CODE" value="<?= h($service['SERVICE_CODE']) ?>">
            </div>
            <div class="col">
                <label>كود بديل (NON_STANDARD_CODE)</label>
                <input type="text" name="NON_STANDARD_CODE" value="<?= h($service['NON_STANDARD_CODE']) ?>">
            </div>
            <div class="col">
                <label>نوع الخدمة (SERVICE_TYPE)</label>
                <input type="text" name="SERVICE_TYPE" value="<?= h($service['SERVICE_TYPE']) ?>">
            </div>
        </div>

        <div class="row">
            <div class="col">
                <label>اسم الخدمة (ع)</label>
                <input type="text" name="service_name_ar" value="<?= h($service['service_name_ar']) ?>">
            </div>
            <div class="col">
                <label>اسم الخدمة (En)</label>
                <input type="text" name="service_name_en" value="<?= h($service['service_name_en']) ?>">
            </div>
            <div class="col">
                <label>التخصص (specialty)</label>
                <input type="text" name="specialty" value="<?= h($service['specialty']) ?>">
            </div>
        </div>

        <div class="row">
            <div class="col">
                <label>السعر (UNIT_PRICE)</label>
                <input type="text" name="UNIT_PRICE" value="<?= h($service['UNIT_PRICE']) ?>">
                <small class="mono">يقبل أرقام عربية/إنجليزية؛ سيتم تنظيفها</small>
            </div>
            <div class="col">
                <label>وصف غير قياسي (NON_STANDARD_DESC)</label>
                <textarea name="NON_STANDARD_DESC" rows="2"><?= h($service['NON_STANDARD_DESC']) ?></textarea>
            </div>
        </div>

        <div style="margin-top:12px">
            <button type="submit">حفظ التعديلات</button>
            <a href="services_list.php">إلغاء</a>
        </div>
    </form>
</div>

</body>
</html>
