
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | CRM</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
  <style>
body{font-family:Tahoma,Arial}
table{border-collapse:collapse;width:100%}
th,td{border:1px solid #ddd;padding:6px;text-align:center}
th{background:#f3f5fb}
.badge{display:inline-block;padding:2px 6px;border-radius:10px;font-size:11px}
.badge.red{background:#f8d7da;color:#721c24}
.badge.orange{background:#fff3cd;color:#856404}
.badge.green{background:#d4edda;color:#155724}
.growth.red{background:#f8d7da}
.growth.green{background:#d4edda}
.small{font-size:12px;color:#666}
.head-sticky thead th{position:sticky;top:0;z-index:2}
.controls{margin:8px 0}
.kpi-bar{height:8px;background:#e9ecef;border-radius:4px;overflow:hidden}
.kpi-fill{height:100%;background:#7a70fa}
</style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

<?php include 'financeheader.php'; ?>
 
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'financesidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenufinance.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Weekly PT KPIS Of Our Team </a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Weekly Part Time KPIS Team Details</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
  <!-- #region -->

<br>
  <div class="col-md-12" style="text-align: center;">
<?php
/********* اتصال قاعدة البيانات *********/
$host     = 'localhost:3306';
$dbname   = 'acesaudi_site';
$username = 'acesaudi_usr';
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username, $password, [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
} catch (PDOException $e) { die("DB Error: " . $e->getMessage()); }

function h($v){ return htmlspecialchars((string)($v ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

/********* مُدخلات *********/
$year      = isset($_GET['year']) ? (int)$_GET['year'] : (int)date('Y');
$paid_only = isset($_GET['paid_only']);         // يحصر بالمدفوع فقط
$search    = trim($_GET['search'] ?? '');       // بحث بالاسم أو رقم المنتج
$export    = isset($_GET['export']);            // تصدير إلى Excel

$MONTHS = [1=>'Jan',2=>'Feb',3=>'March',4=>'April',5=>'May',6=>'June',7=>'July',8=>'Aug',9=>'Sep',10=>'Oct',11=>'Nov',12=>'Dec'];

/********* WHERE للاستعلام الفرعي (على photo) *********/
$subWhere  = ["p.creatdate IS NOT NULL", "YEAR(p.creatdate)=?"];
$subParams = [$year];

if ($paid_only) {
    // حوّل paymentstatus إلى utf8mb4 لتفادي التضارب
    $subWhere[] = "TRIM(COALESCE(CONVERT(p.paymentstatus USING utf8mb4), '')) COLLATE utf8mb4_general_ci
                   IN ('مدفوع','Paid','paid','تم الدفع','succeeded')";
}

if ($search !== '') {
    // LIKE على كلا العمودين بعد تحويلهما إلى utf8mb4
    $subWhere[] = "(
        CONVERT(p.typeservice USING utf8mb4) COLLATE utf8mb4_general_ci LIKE ?
        OR CONVERT(p.proudctid  USING utf8mb4) COLLATE utf8mb4_general_ci LIKE ?
    )";
    $subParams[] = "%{$search}%";
    $subParams[] = "%{$search}%";
}

$subWhereSql = 'WHERE '.implode(' AND ', $subWhere);

/********* الاستعلام الفرعي: تجهيز “اسم الخدمة” و“ProductID” مع توحيد الترميز *********/
$svcExpr = "COALESCE(NULLIF(CONVERT(p.typeservice USING utf8mb4), ''), 'غير محدد') COLLATE utf8mb4_general_ci";
$pidExpr = "COALESCE(NULLIF(CONVERT(p.proudctid  USING utf8mb4), ''), 'غير محدد') COLLATE utf8mb4_general_ci";

$subSql = "
  SELECT
    $svcExpr AS service_name,
    $pidExpr AS product_id,
    p.creatdate
  FROM photo p
  $subWhereSql
";

/********* Pivot شهري وعدّ المسجّلين *********/
$monthSums = [];
foreach (array_keys($MONTHS) as $m) {
    $monthSums[] = "SUM(CASE WHEN MONTH(b2.creatdate)=$m THEN 1 ELSE 0 END) AS m$m";
}
$monthSumsSql = implode(",\n  ", $monthSums);

$sql = "
SELECT
  b2.service_name,
  b2.product_id,
  $monthSumsSql,
  COUNT(*) AS total_year
FROM ( $subSql ) b2
GROUP BY b2.service_name, b2.product_id
ORDER BY total_year DESC, b2.service_name ASC, b2.product_id ASC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($subParams);
$rows = $stmt->fetchAll();

/********* تجهيز بيانات العرض *********/
$data = [];
$totals_per_month = array_fill(1,12,0);
$grand_total = 0;

foreach ($rows as $r){
    $row = [
        'name'   => $r['service_name'],
        'pid'    => $r['product_id'],
        'months' => [],
        'total'  => (int)$r['total_year'],
        'growth' => 0.0
    ];
    $lastMonthWithCount = 0; $lastVal = 0;

    foreach ($MONTHS as $m => $label){
        $cnt = (int)($r["m$m"] ?? 0);
        $row['months'][$m] = $cnt;
        $totals_per_month[$m] += $cnt;
        if ($cnt > 0) { $lastMonthWithCount = $m; $lastVal = $cnt; }
    }

    if ($lastMonthWithCount > 1) {
        $prev = $row['months'][$lastMonthWithCount-1] ?? 0;
        if      ($prev > 0) $row['growth'] = (($lastVal - $prev)/$prev)*100.0;
        elseif  ($lastVal>0) $row['growth'] = 100.0;
        else                 $row['growth'] = 0.0;
    } else {
        $row['growth'] = 0.0;
    }

    $grand_total += $row['total'];
    $data[] = $row;
}

/********* تصدير Excel *********/
if ($export) {
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header("Content-Disposition: attachment; filename=\"photo_registrations_$year.xls\"");
    echo "<table border='1' style='text-align:center;font-family:Tahoma'>";
    echo "<tr><th>#</th><th>Service</th><th>Product ID</th>";
    foreach ($MONTHS as $m=>$lab) echo "<th>{$lab}</th>";
    echo "<th>Total</th><th>Growth %</th></tr>";
    $i=1;
    foreach ($data as $d){
        echo "<tr>";
        echo "<td>".($i++)."</td>";
        echo "<td>".h($d['name'])."</td>";
        echo "<td>".h($d['pid'])."</td>";
        foreach ($MONTHS as $m=>$lab) echo "<td>".(int)$d['months'][$m]."</td>";
        echo "<td>".(int)$d['total']."</td>";
        echo "<td>".number_format($d['growth'],1)."%</td>";
        echo "</tr>";
    }
    echo "<tr style='font-weight:bold;background:#f3f5fb'><td colspan='3'>Totals</td>";
    foreach ($MONTHS as $m=>$lab) echo "<td>".(int)$totals_per_month[$m]."</td>";
    echo "<td>".(int)$grand_total."</td><td></td></tr>";
    echo "</table>";
    exit;
}
?>


<form method="get" class="controls">

     <div class="col-md-4">
      السنة<br>
  <select name="year">
    <?php for($y=date('Y')-3;$y<=date('Y')+1;$y++): ?>
      <option value="<?= $y ?>" <?= $y==$year?'selected':''; ?>><?= $y ?></option>
    <?php endfor; ?>
  </select>
     </div>
 
     <div class="col-md-4">
     بحث <br><input type="text" name="search" value="<?= h($search) ?>" placeholder="اسم الخدمة أو رقم الخدمة" style="width:280px;text-align:center;">
     </div>
  
<div class="col-md-4">
<label style="margin:0 8px;">
    <input type="checkbox" name="paid_only" value="1" <?= $paid_only?'checked':''; ?>> المدفوع فقط
  </label>
</div>
  
<div class="col-md-12">
     <br>
 <button type="submit" class="btn btn-primary"> فلترة و تحديث</button>
  <button type="submit" name="export" value="1" class="btn btn-success">تصدير ملف إكسل</button>
</div>
 
</form>

<div class="col-md-12">
     <br>
</div>

<table class="head-sticky">
  <thead>
    <tr>
      <th>#</th>
      <th>الخدمة</th>
      <th>Product ID</th>
      <?php foreach($MONTHS as $m=>$lab): ?>
        <th><?= $lab ?></th>
      <?php endforeach; ?>
      <th>Total</th>
      <th>Growth</th>
    </tr>
  </thead>
  <tbody>
    <?php if(!$data): ?>
      <tr><td colspan="<?= 3 + count($MONTHS) + 2 ?>">لا توجد بيانات.</td></tr>
    <?php else: $i=1; foreach($data as $row): 
        $gcls = ($row['growth']>=0)?'green':'red';
    ?>
      <tr>
        <td><?= $i++ ?></td>
        <td><?= h($row['name']) ?></td>
        <td><?= h($row['pid']) ?></td>
        <?php foreach ($MONTHS as $m=>$lab): ?>
          <td><?= (int)$row['months'][$m] ?></td>
        <?php endforeach; ?>
        <td><?= (int)$row['total'] ?></td>
        <td class="growth <?= $gcls ?>"><?= ($row['growth']>=0?'+':'').number_format($row['growth'],1) ?>%</td>
      </tr>
    <?php endforeach; endif; ?>
  </tbody>
  <tfoot>
    <tr style="font-weight:bold;background:#f3f5fb">
      <td colspan="3">Totals</td>
      <?php foreach($MONTHS as $m=>$lab): ?>
        <td><?= (int)$totals_per_month[$m] ?></td>
      <?php endforeach; ?>
      <td><?= (int)$grand_total ?></td>
      <td></td>
    </tr>
  </tfoot>
</table>

</div>
            <!-- /.box-body -->
          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
