<?php
define('WASEEL_USERNAME', 'aceclaim');
define('WASEEL_PASSWORD', 'ace3640');
define('TOKEN_FILE', __DIR__ . '/token.json');

function getNewToken() {
    $url = 'https://api.eclaims.waseel.com/oauth/authenticate';
    $data = ['username' => WASEEL_USERNAME, 'password' => WASEEL_PASSWORD];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode === 200) {
        $result = json_decode($response, true);
        $tokenData = [
            'access_token' => $result['access_token'],
            'expires_at' => time() + intval($result['expires_in']) - 60
        ];
        file_put_contents(TOKEN_FILE, json_encode($tokenData));
        return $tokenData['access_token'];
    }
    return null;
}

function getAccessToken() {
    if (file_exists(TOKEN_FILE)) {
        $data = json_decode(file_get_contents(TOKEN_FILE), true);
        if (time() < $data['expires_at']) return $data['access_token'];
    }
    return getNewToken();
}
?>
