<?php
// إعداد الاتصال بقاعدة البيانات
$host = "localhost:3306";
$dbname = "acesaudi_site";
$username = "acesaudi_usr";
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // استعلام لاختيار السجلات التي لا تحتوي على اسم اليوم
    $stmt = $pdo->query("SELECT id, booking_date FROM bookings WHERE dayname IS NULL OR dayname = ''");

    // تحويل اليوم إلى العربية
    function getArabicDayName($date) {
        $dayNumber = date('w', strtotime($date)); // 0 (الأحد) إلى 6 (السبت)
        $arabicDays = [
            '0' => 'الأحد',
            '1' => 'الاثنين',
            '2' => 'الثلاثاء',
            '3' => 'الأربعاء',
            '4' => 'الخميس',
            '5' => 'الجمعة',
            '6' => 'السبت'
        ];
        return $arabicDays[$dayNumber];
    }

    $updateStmt = $pdo->prepare("UPDATE bookings SET dayname = :dayname WHERE id = :id");

    $updatedCount = 0;

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $arabicDay = getArabicDayName($row['booking_date']);
        $updateStmt->execute([
            ':dayname' => $arabicDay,
            ':id' => $row['id']
        ]);
        $updatedCount++;
    }

    echo "تم تحديث $updatedCount سجل باسم اليوم باللغة العربية بنجاح.";

} catch (PDOException $e) {
    echo "فشل الاتصال أو التحديث: " . $e->getMessage();
}
?>
