<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Admin ACE | Admin</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the prole_id via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
<?php include 'headeradmin.php'; ?>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'sidebaruserpanel.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenu.php'; ?>

    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains prole_id content -->
  <div class="content-wrapper">
    <!-- Content Header (Prole_id header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Upload Insurance Services</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Upload Insurance Services</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
      
            <div class="box-header">
              <h3 class="box-title"> Please Choose The File & Upload it</h3>
            </div>
            <!-- /.box-header -->
           <div class="content">
               <div class="row">
               
               <?php
/**
 * استيراد خدمات التأمين من ملف Excel/CSV إلى جدول insuranceservices
 * المتطلبات: composer require phpoffice/phpspreadsheet
 */
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
ini_set('display_errors', 1);
error_reporting(E_ALL);
set_time_limit(0);

// ===== إعدادات عامة =====
$MODE = isset($_GET['mode']) && strtolower($_GET['mode']) === 'upsert' ? 'upsert' : 'insert'; 
// modes: 'insert' فقط إدراج / 'upsert' تحديث إذا وجد (insurancecompanyid + SERVICE_CODE)

$ALLOWED_EXTS = ['xlsx','xls','csv'];

// ===== الاتصال بقاعدة البيانات =====
$have_external_conn = false;
if (file_exists(__DIR__ . '/conn.php')) {
    include __DIR__ . '/conn.php';
    if (isset($conn) && $conn instanceof mysqli) {
        $have_external_conn = true;
    }
}
if (!$have_external_conn) {
    // عدّل هذه القيم عند الحاجة
    $db_host = 'localhost';
    $db_user = 'acesaudi_site';
    $db_pass = 'tabfyv-6xiFry-noczak';
    $db_name = 'acesaudi_site';
    $db_port = 3306;

    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name, $db_port);
}
if ($conn->connect_error) {
    die('<h3 style="color:red">فشل الاتصال بقاعدة البيانات: ' . htmlspecialchars($conn->connect_error) . '</h3>');
}
$conn->set_charset('utf8mb4');

// ===== دوال مساعدة =====
function norm_key($s) {
    $s = trim((string)$s);
    $s = str_replace(["\xC2\xA0"], ' ', $s); // non-breaking space
    $s = strtolower($s);
    $s = preg_replace('/\s+/', '_', $s);
    $s = str_replace(['-'], '_', $s);
    return $s;
}
function arabic_to_english_digits($str) {
    $ar = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩','٫','٬','،'];
    $en = ['0','1','2','3','4','5','6','7','8','9','.','',','];
    return str_replace($ar, $en, (string)$str);
}
function clean_price($v) {
    $v = arabic_to_english_digits($v);
    $v = trim((string)$v);
    // أزل فواصل الآلاف والمسافات
    $v = str_replace([',', ' '], '', $v);
    // أبقِ على الأرقام وعلامة النقطة/السالب فقط
    $v = preg_replace('/[^0-9\.\-]/', '', $v);
    return $v === '' ? '' : $v;
}
function val_or_null($v) {
    $v = is_string($v) ? trim($v) : $v;
    return ($v === '' || $v === null) ? null : $v;
}

// عناوين الأعمدة المقبولة (aliases)
$aliases = [
    'insurancecompanyid'   => ['insurancecompanyid','company_id','insurance_company_id'],
    'insurancecompanyname' => ['insurancecompanyname','company_name','insurance_company_name'],
    'service_code'         => ['service_code','servicecode','code'],
    'non_standard_code'    => ['non_standard_code','nonstandardcode','non_standard'],
    'service_type'         => ['service_type','servicetype','type'],
    'service_name_ar'      => ['service_name_ar','servicenamear','arabic_name','name_ar'],
    'service_name_en'      => ['service_name_en','servicenameen','english_name','name_en'],
    'non_standard_desc'    => ['non_standard_desc','nonstandarddesc','desc','description'],
    'unit_price'           => ['unit_price','unitprice','price','amount'],
    'specialty'            => ['specialty','speciality','department'],
    'factor'               => ['factor','status']
];
$required_min = ['insurancecompanyid','insurancecompanyname','service_code']; // أعمدة مطلوبة كحد أدنى

// ===== عرض نموذج الرفع عند GET =====
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    ?>

    <h2 style="text-align: center;"> <code>insuranceservices الخدمات التأمينية</code> استيراد خدمات التأمين إلى جدول </h2>
        <form method="post" enctype="multipart/form-data" style="text-align: center;">
            <label>اختر ملف (XLSX / XLS / CSV):
                <input type="file" name="excel" accept=".xlsx,.xls,.csv" required>
            </label>
            <label>
                وضع التشغيل:
                <select name="mode">
                    <option value="insert" <?= $MODE === 'insert' ? 'selected' : '' ?>>إدراج فقط</option>
                    <option value="upsert" <?= $MODE === 'upsert' ? 'selected' : '' ?>>تحديث إن وجد (insurancecompanyid + SERVICE_CODE)</option>
                </select>
            </label>
            <button type="submit" style="background-color: #c7254e;">بدء الاستيراد</button>
        </form>
        <div class="note">
            <b>عناوين الأعمدة المتوقعة (صف العناوين الأول):</b><br>
            insurancecompanyid, insurancecompanyname, SERVICE_CODE, NON_STANDARD_CODE, SERVICE_TYPE, service_name_ar, service_name_en, NON_STANDARD_DESC, UNIT_PRICE, specialty, FACTOR
            <br><span class="hint">FACTOR: active / inactive (الافتراضي: active). يمكن ترك الحقول الاختيارية فارغة.</span>
        </div>
        <div class="note hint">
            تلميح: للحصول على عدم تكرار تلقائي، يُفضّل إضافة فهرس فريد:<br>
            <code>ALTER TABLE insuranceservices ADD UNIQUE KEY uniq_comp_code (insurancecompanyid, SERVICE_CODE);</code>
        </div>
    </div>
    </body>
    </html>
    <?php
    exit;
}

// ===== معالجة الرفع =====
if (!isset($_FILES['excel']) || $_FILES['excel']['error'] !== UPLOAD_ERR_OK) {
    die('<h3 class="err">لم يتم رفع الملف بشكل صحيح.</h3>');
}

$mode_from_post = isset($_POST['mode']) ? strtolower($_POST['mode']) : 'insert';
$MODE = in_array($mode_from_post, ['insert','upsert']) ? $mode_from_post : $MODE;

$fname = $_FILES['excel']['name'];
$ext = strtolower(pathinfo($fname, PATHINFO_EXTENSION));
if (!in_array($ext, $ALLOWED_EXTS)) {
    die('<h3 class="err">الامتداد غير مدعوم. المسموح: xlsx, xls, csv</h3>');
}

// احفظ الملف مؤقتًا
$tmpPath = $_FILES['excel']['tmp_name'];

// ===== قراءة الملف بـ PhpSpreadsheet =====
// بدّل أي require قديم بهذا المقطع
$vendorCandidates = [
    __DIR__ . 'import-excel/vendor/autoload.php',
    __DIR__ . 'import-excel/vendor/autoload.php',
    $_SERVER['DOCUMENT_ROOT'] . 'import-excel/vendor/autoload.php',
];
$autoloadFound = false;
foreach ($vendorCandidates as $v) {
    if (file_exists($v)) { require $v; $autoloadFound = true; break; }
}
if (!$autoloadFound) {
    die('لم يتم العثور على vendor/autoload.php — ثبّت داخل مجلد المشروع.');
}

try {
    if ($ext === 'csv') {
        $reader = new Csv();
        $reader->setInputEncoding('UTF-8');
        $reader->setDelimiter(',');
        $reader->setEnclosure('"');
        $reader->setSheetIndex(0);
    } else {
        $reader = IOFactory::createReaderForFile($tmpPath);
    }
    $reader->setReadDataOnly(true);
    $spreadsheet = $reader->load($tmpPath);
    $sheet = $spreadsheet->getActiveSheet();
    $rows = $sheet->toArray(null, true, true, true); // مفاتيح الأعمدة: A,B,C...
} catch (Throwable $e) {
    die('<h3 class="err">تعذّر قراءة الملف: ' . htmlspecialchars($e->getMessage()) . '</h3>');
}
if (!$rows || count($rows) < 2) {
    die('<h3 class="err">الملف لا يحتوي بيانات كافية.</h3>');
}

// ===== بناء خريطة العناوين =====
$headerRow = $rows[1];
$colKeyByLetter = []; // مثل: 'A' => 'insurancecompanyid'
foreach ($headerRow as $colLetter => $title) {
    $nk = norm_key($title);
    // طابق مع aliases
    $matched = null;
    foreach ($aliases as $canon => $alts) {
        if (in_array($nk, $alts, true)) { $matched = $canon; break; }
    }
    if ($matched) {
        $colKeyByLetter[$colLetter] = $matched;
    } else {
        // لو العنوان أصلاً مطابق (norm_key يساويه)
        foreach ($aliases as $canon => $alts) {
            if ($nk === $canon) { $colKeyByLetter[$colLetter] = $canon; break; }
        }
    }
}

// تحقق من الأعمدة المطلوبة
$found = array_values(array_unique(array_values($colKeyByLetter)));
$missing = array_diff($required_min, $found);
if ($missing) {
    die('<h3 class="err">الأعمدة المطلوبة مفقودة: ' . htmlspecialchars(implode(', ', $missing)) . '</h3>');
}

// ===== تجهيز عبارات SQL =====
$sqlInsert = "INSERT INTO insuranceservices
(insurancecompanyid, insurancecompanyname, SERVICE_CODE, NON_STANDARD_CODE, SERVICE_TYPE, service_name_ar, service_name_en, NON_STANDARD_DESC, UNIT_PRICE, specialty, FACTOR)
VALUES (?,?,?,?,?,?,?,?, NULLIF(?,''), ?, ?)";
$stmtIns = $conn->prepare($sqlInsert);
if (!$stmtIns) {
    die('<h3 class="err">خطأ في تحضير استعلام الإدراج: ' . htmlspecialchars($conn->error) . '</h3>');
}

$sqlUpdate = "UPDATE insuranceservices SET
insurancecompanyname=?, NON_STANDARD_CODE=?, SERVICE_TYPE=?, service_name_ar=?, service_name_en=?, NON_STANDARD_DESC=?, UNIT_PRICE=NULLIF(?,''), specialty=?, FACTOR=?
WHERE insurancecompanyid=? AND SERVICE_CODE=?";
$stmtUpd = $conn->prepare($sqlUpdate);
if (!$stmtUpd) {
    die('<h3 class="err">خطأ في تحضير استعلام التحديث: ' . htmlspecialchars($conn->error) . '</h3>');
}

$sqlCheck = "SELECT service_id FROM insuranceservices WHERE insurancecompanyid=? AND SERVICE_CODE=? LIMIT 1";
$stmtCheck = $conn->prepare($sqlCheck);
if (!$stmtCheck) {
    die('<h3 class="err">خطأ في تحضير استعلام الفحص: ' . htmlspecialchars($conn->error) . '</h3>');
}

// ===== تنفيذ الاستيراد داخل معاملة =====
$conn->begin_transaction();
$inserted = 0; $updated = 0; $skipped = 0;
$errors = [];

try {
    // مرّ على الصفوف من الصف الثاني
    $rowNum = 1;
    foreach ($rows as $rIdx => $row) {
        if ($rIdx === 1) continue; // العناوين
        $rowNum++;

        // اجلب القيم بحسب الخريطة
        $data = [
            'insurancecompanyid'   => null,
            'insurancecompanyname' => null,
            'service_code'         => null,
            'non_standard_code'    => null,
            'service_type'         => null,
            'service_name_ar'      => null,
            'service_name_en'      => null,
            'non_standard_desc'    => null,
            'unit_price'           => null,
            'specialty'            => null,
            'factor'               => null,
        ];
        foreach ($colKeyByLetter as $colLetter => $canonKey) {
            $val = isset($row[$colLetter]) ? $row[$colLetter] : null;
            if ($canonKey === 'unit_price') {
                $val = clean_price($val);
            } else {
                $val = is_null($val) ? null : trim((string)$val);
            }
            $data[$canonKey] = $val;
        }

        // تحقق من الحد الأدنى المطلوب
        if (!$data['insurancecompanyid'] || !$data['insurancecompanyname'] || !$data['service_code']) {
            $skipped++;
            $errors[] = "سطر $rowNum: بيانات ناقصة (insurancecompanyid/insurancecompanyname/SERVICE_CODE).";
            continue;
        }

        // عامل الحالة FACTOR
        $factor = strtolower((string)$data['factor']);
        if ($factor !== 'inactive') $factor = 'active';

        // بحسب الوضع: insert أو upsert
        if ($MODE === 'upsert') {
            // تحقق هل السجل موجود
            $icid = $data['insurancecompanyid'];
            $scode = $data['service_code'];
            $stmtCheck->bind_param('ss', $icid, $scode);
            $stmtCheck->execute();
            $stmtCheck->store_result();

            if ($stmtCheck->num_rows > 0) {
                // تحديث
                $stmtUpd->bind_param(
                    'sssssssss' . 'ss', // 9 قيم set + 2 where = 11
                    $data['insurancecompanyname'],
                    $data['non_standard_code'],
                    $data['service_type'],
                    $data['service_name_ar'],
                    $data['service_name_en'],
                    $data['non_standard_desc'],
                    $data['unit_price'],
                    $data['specialty'],
                    $factor,
                    $icid,
                    $scode
                );
                if (!$stmtUpd->execute()) {
                    $skipped++;
                    $errors[] = "سطر $rowNum: فشل التحديث - " . $stmtUpd->error;
                } else {
                    $updated += $stmtUpd->affected_rows >= 0 ? 1 : 0;
                }
            } else {
                // إدراج
                $stmtIns->bind_param(
                    'sssssssssss', // 11
                    $data['insurancecompanyid'],
                    $data['insurancecompanyname'],
                    $data['service_code'],
                    $data['non_standard_code'],
                    $data['service_type'],
                    $data['service_name_ar'],
                    $data['service_name_en'],
                    $data['non_standard_desc'],
                    $data['unit_price'],
                    $data['specialty'],
                    $factor
                );
                if (!$stmtIns->execute()) {
                    $skipped++;
                    $errors[] = "سطر $rowNum: فشل الإدراج - " . $stmtIns->error;
                } else {
                    $inserted++;
                }
            }
        } else {
            // إدراج فقط
            $stmtIns->bind_param(
                'sssssssssss',
                $data['insurancecompanyid'],
                $data['insurancecompanyname'],
                $data['service_code'],
                $data['non_standard_code'],
                $data['service_type'],
                $data['service_name_ar'],
                $data['service_name_en'],
                $data['non_standard_desc'],
                $data['unit_price'],
                $data['specialty'],
                $factor
            );
            if (!$stmtIns->execute()) {
                $skipped++;
                $errors[] = "سطر $rowNum: فشل الإدراج - " . $stmtIns->error;
            } else {
                $inserted++;
            }
        }
    }

    $conn->commit();
} catch (Throwable $e) {
    $conn->rollback();
    die('<h3 class="err">تم التراجع عن العملية بسبب خطأ: ' . htmlspecialchars($e->getMessage()) . '</h3>');
}

// ===== إخراج الملخص =====
?>

<h2>نتيجة الاستيراد (وضع: <?= htmlspecialchars($MODE) ?>)</h2>
    <ul>
        <li class="ok">تم الإدراج: <?= (int)$inserted ?></li>
        <li class="ok">تم التحديث: <?= (int)$updated ?></li>
        <li class="err">تم التخطي: <?= (int)$skipped ?></li>
    </ul>

    <?php if ($errors): ?>
        <h3 class="err">تفاصيل السطور المتخطّاة (أول 50):</h3>
        <ol>
            <?php foreach (array_slice($errors, 0, 50) as $msg): ?>
                <li class="err"><?= htmlspecialchars($msg) ?></li>
            <?php endforeach; ?>
        </ol>
    <?php endif; ?>

    <p class="hint">
        ملاحظة: إذا رغبت بمنع التكرار تلقائيًا على مستوى القاعدة، أضف الفهرس الفريد التالي مرة واحدة:<br>
        <code>ALTER TABLE insuranceservices ADD UNIQUE KEY uniq_comp_code (insurancecompanyid, SERVICE_CODE);</code>
    </p>

    <p><a href="?">رجوع لصفحة الرفع</a></p>
</div>

           

          
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usrole_id
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
