<?php
// الاتصال بقاعدة البيانات
$pdo = new PDO("mysql:host=localhost:3306;dbname=acesaudi_site;charset=utf8", "acesaudi_usr", 'tabfyv-6xiFry-noczak');
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// استقبال الفلاتر
$fromDate = $_GET['from_date'] ?? '';
$toDate = $_GET['to_date'] ?? '';
$status = $_GET['status'] ?? '';

// بناء شرط الفلترة
$where = "WHERE 1";
$params = [];

if ($fromDate && $toDate) {
    $where .= " AND DATE(created_at) BETWEEN ? AND ?";
    $params[] = $fromDate;
    $params[] = $toDate;
}

if ($status && in_array($status, ['مرسل', 'فشل'])) {
    $where .= " AND status = ?";
    $params[] = $status;
}

// تنفيذ الاستعلام
$stmt = $pdo->prepare("SELECT * FROM notifications_log $where ORDER BY created_at DESC");
$stmt->execute($params);
$logs = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>سجل الإشعارات</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
            background-color: #f9f9f9;
            padding: 30px;
        }
        h2 {
            text-align: center;
            margin-bottom: 25px;
        }
        .status-success { color: green; font-weight: bold; }
        .status-fail { color: red; font-weight: bold; }
    </style>
</head>
<body>

    <h2>📋 سجل الإشعارات المرسلة</h2>

    <form method="GET" class="row g-3 mb-4">
        <div class="col-md-3">
            <label>من تاريخ:</label>
            <input type="date" class="form-control" name="from_date" value="<?= htmlspecialchars($fromDate) ?>">
        </div>
        <div class="col-md-3">
            <label>إلى تاريخ:</label>
            <input type="date" class="form-control" name="to_date" value="<?= htmlspecialchars($toDate) ?>">
        </div>
        <div class="col-md-3">
            <label>الحالة:</label>
            <select class="form-control" name="status">
                <option value="">الكل</option>
                <option value="مرسل" <?= $status == 'مرسل' ? 'selected' : '' ?>>مرسل ✅</option>
                <option value="فشل" <?= $status == 'فشل' ? 'selected' : '' ?>>فشل ❌</option>
            </select>
        </div>
        <div class="col-md-3 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">🔍 تصفية النتائج</button>
        </div>
    </form>

    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover">
            <thead class="table-dark">
                <tr>
                    <th>الهوية</th>
                    <th>الاسم</th>
                    <th>البريد</th>
                    <th>التاريخ</th>
                    <th>الوقت</th>
                    <th>الخدمة</th>
                    <th>الغرفة</th>
                    <th>الفترة</th>
                    <th>الحالة</th>
                    <th>ملاحظة</th>
                    <th>تاريخ الإرسال</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($logs) > 0): ?>
                    <?php foreach ($logs as $log): ?>
                    <tr>
                        <td><?= htmlspecialchars($log['customerid']) ?></td>
                        <td><?= htmlspecialchars($log['patientname']) ?></td>
                        <td><?= htmlspecialchars($log['email']) ?></td>
                        <td><?= htmlspecialchars($log['bookingdate']) ?></td>
                        <td><?= htmlspecialchars($log['time']) ?></td>
                        <td><?= htmlspecialchars($log['typeservice']) ?></td>
                        <td><?= htmlspecialchars($log['roomid']) ?></td>
                        <td><?= htmlspecialchars($log['period']) ?></td>
                        <td class="<?= $log['status'] === 'مرسل' ? 'status-success' : 'status-fail' ?>">
                            <?= $log['status'] ?>
                        </td>
                        <td><?= htmlspecialchars($log['error_message']) ?></td>
                        <td><?= $log['created_at'] ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="11" class="text-center text-danger">لا توجد سجلات مطابقة.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</body>
</html>
