<? require_once __DIR__ . '/bootstrap_session.php'; ?>
<?php
/******************************************************
 * فلترة مواعيد مستفيد حسب رقم الهوية + service_id (Dropdown ثابت)
 * + دعم تعبئة patient_id من الرابط ?patient_id=...
 * + فلترة تاريخ (من/إلى)
 * + إحصائيات: إجمالي / مكتمل / محجوز / ملغي / المتبقي
 ******************************************************/

mb_internal_encoding('UTF-8');
header('Content-Type: text/html; charset=utf-8');

// ====== قائمة الخدمات الثابتة (عدّلها بما يناسبك) ======
$SERVICE_OPTIONS = [
   '1' => 'التأهيل المهني المكثف',
    '2' => 'برنامج تدريب الوالدين عن بعد',
    '3' => 'خدمة تقييم التخصص الواحد - علاج سلوكي',
    '4' => 'التقييم المتعدد التخصصات',
    '5' => 'خدمة باقة جلسات علاجية في التخصص الواحد',
    '6' => 'البرنامج السلوكي المكثف',
    '7' => 'خدمة البرنامج التأهيلي المكثف',
    '8' => 'خدمة إستشرنا',
    '9' => 'برنامج علاج الانتقائية في الطعام',
    '10' => 'أنا أدرب طفلي',
    '11' => 'الرعاية المنزلية',
    '12' => 'خدمة الظل',
    '13' => 'خدمة جلسة استشارية مع طبيب استشاري',
    '14' => 'خدمة التشخيص',
    '15' => 'خدمة اختبار الذكاء',
    '16' => 'برنامج التميز التأهيلي',
    '17' => 'برنامج التهيئة الأكاديمية',
    '18' => 'برنامج التميز التأهيلي',
    '19' => 'برنامج التأهيل المهني غير المكثف',
    '20' => 'التميز التأهيلي',
    '21' => 'التهيئة الأكاديمية',
];

// ====== إعداد اتصال PDO (عدّل القيم حسب بيئتك) ======
$dbHost = 'localhost';     // أو localhost:3306
$dbName = 'acesaudi_site';
$dbUser = 'acesaudi_usr';
$dbPass = 'tabfyv-6xiFry-noczak';

$dsn = "mysql:host={$dbHost};dbname={$dbName};charset=utf8mb4";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];
try {
    $pdo = new PDO($dsn, $dbUser, $dbPass, $options);
    $pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_general_ci");
} catch (Exception $e) {
    die("فشل الاتصال بقاعدة البيانات: " . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8'));
}

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

// ====== قراءة مدخلات النموذج ======
// 1) من POST (النموذج)
$patientId = isset($_POST['patient_id']) ? trim($_POST['patient_id']) : '';
$serviceId = isset($_POST['service_id']) ? trim($_POST['service_id']) : '';
$fromDate  = isset($_POST['from_date'])  ? trim($_POST['from_date'])  : '';
$toDate    = isset($_POST['to_date'])    ? trim($_POST['to_date'])    : '';

// 2) من GET (الرابط) — إذا موجود، نعتمده ونجعل الحقل Readonly
$patientIdFromGet = isset($_GET['patient_id']) ? trim($_GET['patient_id']) : '';
if ($patientIdFromGet !== '') {
    $patientId = $patientIdFromGet;
}
$readonlyAttr = ($patientIdFromGet !== '') ? 'readonly' : '';

$rows = [];
$stats = ['total'=>0, 'مكتمل'=>0, 'محجوز'=>0, 'ملغي'=>0];
$errorMsg = '';
$didSubmit = ($_SERVER['REQUEST_METHOD'] === 'POST');

// تصحيح تلقائي إذا كان من > إلى
if ($fromDate !== '' && $toDate !== '' && $fromDate > $toDate) {
    $tmp = $fromDate; $fromDate = $toDate; $toDate = $tmp;
}

if ($didSubmit) {
    if ($patientId === '' || $serviceId === '') {
        $errorMsg = "رجاءً أدخل رقم هوية المستفيد واختر رقم الخدمة.";
    } elseif (!array_key_exists($serviceId, $SERVICE_OPTIONS)) {
        $errorMsg = "رقم الخدمة غير موجود في القائمة الثابتة.";
    } else {
        try {
            // شرط WHERE ديناميكي لفلترة التاريخ
            $where = "patient_id = :pid AND service_id = :sid";
            $params = [':pid'=>$patientId, ':sid'=>$serviceId];

            if ($fromDate !== '') {
                $where .= " AND booking_date >= :fromDate";
                $params[':fromDate'] = $fromDate;
            }
            if ($toDate !== '') {
                $where .= " AND booking_date <= :toDate";
                $params[':toDate']   = $toDate;
            }

            // التفاصيل (الأحدث أولاً)
            $sqlDetails = "
                SELECT 
                    id,
                    booking_date,
                    dayname,
                    time_slot,
                    end_time,
                    period,
                    bookingstatus,
                    room_id,
                    spclistsname,
                    service_id,
                    typeservice,
                    patient_name,
                    notes
                FROM bookings
                WHERE $where
                ORDER BY booking_date DESC, time_slot DESC
            ";
            $stmt = $pdo->prepare($sqlDetails);
            $stmt->execute($params);
            $rows = $stmt->fetchAll();

            // إجمالي
            $sqlTotal = "SELECT COUNT(*) FROM bookings WHERE $where";
            $stmtT = $pdo->prepare($sqlTotal);
            $stmtT->execute($params);
            $stats['total'] = (int)$stmtT->fetchColumn();

            // حسب الحالة
            $sqlByStatus = "
                SELECT bookingstatus, COUNT(*) AS c
                FROM bookings
                WHERE $where
                GROUP BY bookingstatus
            ";
            $stmtS = $pdo->prepare($sqlByStatus);
            $stmtS->execute($params);
            foreach ($stmtS as $r) {
                $st = (string)($r['bookingstatus'] ?? '');
                $stats[$st] = (int)($r['c'] ?? 0);
            }

        } catch (Exception $e) {
            $errorMsg = "حدث خطأ أثناء جلب البيانات: " . h($e->getMessage());
        }
    }
}

// المتبقي = إجمالي المواعيد − المواعيد المكتملة
$completed = (int)($stats['مكتمل'] ?? 0);
$remaining = max(0, (int)$stats['total'] - $completed);
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>فلترة مواعيد المستفيد حسب الخدمة</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">
<style>
 body{font-family:"Tajawal",system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial}
 .card{border-radius:1rem}
 .table thead th{white-space:nowrap}
 .badge{font-size:.95rem}
 .small-muted{font-size:.875rem;color:#6c757d}
</style>
</head>
<body class="bg-light">
<div class="container py-4">

    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h1 class="h4 mb-3">فلترة مواعيد المستفيد حسب الخدمة</h1>
            <form method="post" class="row gy-3">
                <!-- رقم الهوية: يُملأ تلقائيًا من ?patient_id=... لو وُجد ويصبح Readonly -->
                <div class="col-md-3">
                    <label class="form-label">رقم هوية المستفيد</label>
                    <input type="text" name="patient_id" class="form-control" required
                           value="<?= h($patientId) ?>" <?= $readonlyAttr ?>
                           placeholder="مثال: 1234567890">
                    <?php if ($patientIdFromGet !== ''): ?>
                        <div class="small-muted mt-1">تم تعبئة رقم الهوية من الرابط</div>
                    <?php endif; ?>
                </div>

                <div class="col-md-3">
                    <label class="form-label"> الخدمة </label>
                    <select name="service_id" class="form-select" required>
                        <option value="">اختر الخدمة...</option>
                        <?php foreach ($SERVICE_OPTIONS as $sid=>$label): ?>
                            <option value="<?= h($sid) ?>" <?= ($sid === $serviceId ? 'selected' : '') ?>>
                                <?= h($sid . ' — ' . $label) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- فلترة التاريخ -->
                <div class="col-md-3">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" name="from_date" class="form-control"
                           value="<?= h($fromDate) ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" name="to_date" class="form-control"
                           value="<?= h($toDate) ?>">
                </div>

                <div class="col-12 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary ms-auto">عرض النتائج</button>
                </div>
            </form>

            <?php if ($errorMsg): ?>
                <div class="alert alert-danger mt-3"><?= $errorMsg ?></div>
            <?php endif; ?>
        </div>
    </div>

    <?php if ($didSubmit && !$errorMsg): ?>
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex flex-wrap justify-content-between align-items-center mb-3">
                    <div>
                        <div class="fw-bold">نتائج البحث:</div>
                        <div class="small-muted">
                            رقم الهوية: <span class="fw-semibold"><?= h($patientId) ?></span>
                            &nbsp;|&nbsp; service_id: <span class="fw-semibold"><?= h($serviceId) ?></span>
                            &nbsp;|&nbsp; الخدمة: <span class="fw-semibold"><?= h($SERVICE_OPTIONS[$serviceId] ?? '') ?></span>
                            <?php if ($fromDate || $toDate): ?>
                                &nbsp;|&nbsp; النطاق الزمني:
                                <span class="fw-semibold"><?= $fromDate ? h($fromDate) : '—' ?> إلى <?= $toDate ? h($toDate) : '—' ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="d-flex flex-wrap gap-2 mt-2 mt-md-0">
                        <span class="badge text-bg-secondary">الإجمالي: <?= (int)$stats['total'] ?></span>
                        <span class="badge text-bg-success">مكتمل: <?= (int)($stats['مكتمل'] ?? 0) ?></span>
                        <span class="badge text-bg-warning">محجوز: <?= (int)($stats['محجوز'] ?? 0) ?></span>
                        <span class="badge text-bg-danger">ملغي: <?= (int)($stats['ملغي'] ?? 0) ?></span>
                        <span class="badge text-bg-info">المتبقي من الجلسات: <?= $remaining ?></span>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-striped table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>اسم المستفيد</th>
                                <th>التاريخ</th>
                                <th>اليوم</th>
                                <th>الوقت</th>
                                <th>نهاية</th>
                                <th>الفترة</th>
                                <th>الحالة</th>
                                <th>الغرفة</th>
                                <th>الأخصائي</th>
                                <th>service_id</th>
                                <th>اسم الخدمة (من الجدول)</th>
                                <th>ملاحظات</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if (!$rows): ?>
                            <tr><td colspan="13" class="text-center text-muted">لا توجد مواعيد مطابقة.</td></tr>
                        <?php else: ?>
                            <?php foreach ($rows as $i=>$r): ?>
                                <tr>
                                    <td><?= $i+1 ?></td>
                                    <td><?= h($r['patient_name']) ?></td>
                                    <td><?= h($r['booking_date']) ?></td>
                                    <td><?= h($r['dayname']) ?></td>
                                    <td><?= h($r['time_slot']) ?></td>
                                    <td><?= h($r['end_time']) ?></td>
                                    <td><?= h($r['period']) ?></td>
                                    <td>
                                        <?php
                                            $status = (string)$r['bookingstatus'];
                                            $class  = 'text-bg-secondary';
                                            if     ($status === 'مكتمل') $class = 'text-bg-success';
                                            elseif ($status === 'محجوز') $class = 'text-bg-warning';
                                            elseif ($status === 'ملغي')  $class = 'text-bg-danger';
                                        ?>
                                        <span class="badge <?= $class ?>"><?= h($status) ?></span>
                                    </td>
                                    <td><?= h($r['room_id']) ?></td>
                                    <td><?= h($r['spclistsname']) ?></td>
                                    <td><?= h($r['service_id']) ?></td>
                                    <td><?= h($r['typeservice']) ?></td>
                                    <td><?= h($r['notes']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="mt-3 small-muted">
                    * الترتيب: الأحدث أولًا (حسب التاريخ ثم الوقت).<br>
                    * المتبقي = إجمالي المواعيد − المواعيد المكتملة.<br>
                    * فلترة التاريخ تشمل الطرفين (من/إلى) بشكل شامل.
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
</body>
</html>
