<?php
// بدء الجلسة
session_start();

// التحقق مما إذا كان المستخدم مسجلاً للدخول
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: superadminlogin.php");
    exit;
}
// جلب معرف المستخدم من الجلسة
$iduser = $_SESSION["iduser"];
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Supervisor ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
<?php include 'superadminheader.php'; ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
      <?php include 'supersidepanle.php'; ?>
      <!-- search form -->
     <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
        <?php include 'navemenusuper.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Weekly KPIS Of Our Team </a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Weekly KPIS Team Details</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
  <!-- #region -->

<br>
  <div class="col-md-12">
     
  <?php
/********* DB *********/
$host     = 'localhost:3306';
$dbname   = 'acesaudi_site';
$username = 'acesaudi_usr';
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username, $password, [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
} catch (PDOException $e) { die("فشل الاتصال: " . $e->getMessage()); }

function h($v){ return htmlspecialchars((string)($v ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

/********* Inputs *********/
// الفترة: افتراضيًا الأسبوع الحالي (الإثنين-الأحد)، غيّر كما تريد
$today      = new DateTime();
$isoDay     = (int)$today->format('N'); // 1=Mon..7=Sun
$monday     = (clone $today)->modify('-'.($isoDay-1).' days');
$sunday     = (clone $monday)->modify('+6 days');

$date_from  = $_GET['date_from'] ?? $monday->format('Y-m-d');
$date_to    = $_GET['date_to']   ?? $sunday->format('Y-m-d');

$specialist_ids_raw = trim($_GET['specialist_ids'] ?? ''); // مثال: "324,173,201"
$export    = isset($_GET['export']); // Excel

// الهدف الأسبوعي بالساعات حسب طلبك
$weeklyTargetHours = 42.5;

// عدد أيام الفترة (شامل الطرفين)
$fromDT = new DateTime($date_from);
$toDT   = new DateTime($date_to);
$days   = max(1, (int)$fromDT->diff($toDT)->format('%a') + 1);

// الهدف حسب طول الفترة
$periodTargetHours = $weeklyTargetHours * ($days / 7.0);
$periodTargetMinutes = max(1, $periodTargetHours * 60); // لتجنّب القسمة على صفر

/********* WHERE *********/
$where  = [];
$params = [];

$where[]  = "b.`booking_date` BETWEEN ? AND ?";
$params[] = $date_from;
$params[] = $date_to;

$where[]  = "TRIM(COALESCE(b.`bookingstatus`, '')) IN ('مكتمل','محجوز')";

// فلترة بقائمة أخصائيين (اختياري)
$idList = [];
if ($specialist_ids_raw !== '') {
    foreach (explode(',', $specialist_ids_raw) as $id) {
        $id = trim($id);
        if ($id !== '' && ctype_digit($id)) { $idList[] = (int)$id; }
    }
    if ($idList) {
        $in = implode(',', array_fill(0, count($idList), '?'));
        $where[] = "b.`spesilstid` IN ($in)";
        $params = array_merge($params, $idList);
    }
}

$whereSql = 'WHERE ' . implode(' AND ', $where);

/********* Query: إجماليات لكل أخصائي *********
  minutes_total: مجموع الدقائق المنجزة للفترة
  sessions_count: عدد الجلسات المحتسبة
************************************************/
$sql = "
SELECT
  b.`spesilstid`                    AS specialist_id,
  COALESCE(NULLIF(b.`spclistsname`,''), 'غير محدد') AS specialist_name,
  COUNT(*)                          AS sessions_count,
  SUM(
    CASE
      WHEN b.`session_duration` IS NOT NULL AND b.`session_duration` > 0
        THEN b.`session_duration`
      WHEN b.`end_time` IS NOT NULL AND b.`time_slot` IS NOT NULL
        THEN TIMESTAMPDIFF(MINUTE, CONCAT(b.`booking_date`,' ',b.`time_slot`), CONCAT(b.`booking_date`,' ',b.`end_time`))
      ELSE 45
    END
  )                                  AS minutes_total
FROM `bookings` b
{$whereSql}
GROUP BY b.`spesilstid`, b.`spclistsname`
ORDER BY minutes_total DESC, specialist_name ASC
";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

/********* حسابات نهائية *********/
$data = [];
$tot_minutes = 0;
$tot_sessions = 0;

foreach ($rows as $r) {
    $minutes = (int)$r['minutes_total'];
    $hours   = $minutes / 60;
    $kpi     = ($periodTargetHours > 0) ? ($hours / $periodTargetHours) * 100.0 : 0.0;

    $data[] = [
        'id'              => $r['specialist_id'],
        'name'            => $r['specialist_name'],
        'sessions'        => (int)$r['sessions_count'],
        'minutes'         => $minutes,
        'hours'           => $hours,
        'kpi'             => $kpi
    ];
    $tot_minutes  += $minutes;
    $tot_sessions += (int)$r['sessions_count'];
}

// ترتيب بحسب KPI تنازليًا
usort($data, fn($a,$b) => ($b['kpi'] <=> $a['kpi']));

/********* Export: Excel *********/
if ($export) {
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header('Content-Disposition: attachment; filename="kpi_fulltime_specialists.xls"');
    echo "<table border='1' style='text-align:center; font-family:Tahoma;' class='table table-hover table-striped'>";
    echo "<tr>
            <th>#</th>
            <th>رقم معرّف الأخصائي</th>
            <th>اسم الأخصائي</th>
            <th>عدد الجلسات</th>
            <th>الدقائق المنجزة</th>
            <th>الساعات المنجزة</th>
            <th>الهدف (ساعات)</th>
            <th>KPI %</th>
          </tr>";
    $i=1;
    foreach ($data as $row) {
        echo "<tr>
                <td>".($i++)."</td>
                <td>".h($row['id'])."</td>
                <td>".h($row['name'])."</td>
                <td>".h($row['sessions'])."</td>
                <td>".h($row['minutes'])."</td>
                <td>".number_format($row['hours'], 2)."</td>
                <td>".number_format($periodTargetHours, 2)."</td>
                <td>".number_format($row['kpi'], 2)."%</td>
              </tr>";
    }
    echo "<tr style='font-weight:bold;background:#f3f5fb'>
            <td colspan='3'>الإجمالي</td>
            <td>".h($tot_sessions)."</td>
            <td>".h($tot_minutes)."</td>
            <td>".number_format($tot_minutes/60, 2)."</td>
            <td>".number_format($periodTargetHours, 2)."</td>
            <td></td>
          </tr>";
    echo "</table>";
    exit;
}
?>

<form method="get" class="form">
     <div class="form-row">

     <div class="col-md-6">
     <label for="exampleInputEmail1">من</label>
     <input type="date" name="date_from" value="<?= h($date_from) ?>" class="form-control">
     </div>

     <div class="col-md-6">
     <label for="exampleInputEmail1">إلى </label>
    <input type="date" name="date_to"   value="<?= h($date_to) ?>" class="form-control">

     </div>

     <div class="col-md-12">

     <label for="exampleInputEmail1">  الأخصائيين (اختياري، مفصولة بفواصل) </label>
   
    <input type="text" name="specialist_ids" value="<?= h($specialist_ids_raw) ?>" placeholder="مثل: 324,173,201" class="form-control">
    <br>
    <button type="submit" class="btn btn-primary">فلترة</button>
    <button type="submit" name="export" value="1" class="btn btn-success">تصدير أكسل</button>

     </div>
    
     <div class="col-md-12"><br></div>

     </div>
     
  </div>
 
  <div class="col-md-12" style="text-align: center;">
          <div class="box box-info collapsed-box box-solid">
            <div class="box-header with-border">
              <h3 class="box-title">الهدف للفترة = <?= number_format($periodTargetHours,2) ?> ساعة</h3>

              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i>
                </button>
              </div>
              <!-- /.box-tools -->
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              (اعتمادًا على 42.5 ساعة لكل 7 أيام × عدد أيام الفترة <?= (int)$days ?>)
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>

 
</form>

<table class='table table-hover table-striped' style="text-align: center;">
  <thead>
    <tr>
      <th style="text-align: center;">#</th>
      <th style="text-align: center;">معرّف</th>
      <th style="text-align: center;">الأخصائي</th>
      <th style="text-align: center;">الجلسات المحتسبة</th>
      <th style="text-align: center;">الدقائق</th>
      <th style="text-align: center;">الساعات</th>
      <th style="text-align: center;">KPI % (ساعات منجزة / <?= number_format($periodTargetHours,2) ?> × 100)</th>
    </tr>
  </thead>
  <tbody>
  <?php if(!$data): ?>
    <tr><td colspan="7" style="text-align: center;">لا توجد بيانات ضمن الفترة المحددة</td></tr>
  <?php else: $i=1; foreach($data as $row): 
      $pct = max(0, min(100, $row['kpi']));
  ?>
    <tr>
      <td><?= $i++ ?></td>
      <td style="text-align: center;"><?= h($row['id']) ?></td>
      <td style="text-align: center;"><?= h($row['name']) ?></td>
      <td style="text-align: center;"><?= h($row['sessions']) ?></td>
      <td style="text-align: center;"><?= h($row['minutes']) ?></td>
      <td style="text-align: center;"><?= number_format($row['hours'], 2) ?></td>
      <td style="text-align: center;">
        <?= number_format($row['kpi'], 2) ?>%
        <div class="kpi-bar" style="text-align: center;"><div class="kpi-fill" style="width:<?= $pct ?>%"></div></div>
      </td>
    </tr>
  <?php endforeach; endif; ?>
  </tbody>
  <tfoot>
    <tr style="font-weight:bold;background:#f3f5fb">
      <td colspan="3" style="text-align: center;">الإجمالي</td>
      <td style="text-align: center;"><?= h($tot_sessions) ?></td>
      <td style="text-align: center;"><?= h($tot_minutes) ?></td>
      <td style="text-align: center;"><?= number_format($tot_minutes/60, 2) ?></td>
      <td></td>
    </tr>
  </tfoot>
</table>


 

            </div>
            <!-- /.box-body -->
          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
