<?php 
 
// Load the database configuration file 
include_once 'dbConfig.php'; 
 
// Include XLSX generator library 
require_once 'PhpXlsxGenerator.php'; 
 
// Excel file name for download 
$fileName = "members-data_" . date('Y-m-d') . ".xlsx"; 
 
// Define column names 
$excelData[] = array('رقم الطلب','الأسم كاملا', 'الخدمة', 'الأيميل', 'الجوال', 'الفئة العمرية', 'نوع الدفع', 'تاريخ التسجيل', 'STATUS'); 
 
// Fetch records from database and store in an array 
$query = $db->query("SELECT * FROM photo ORDER BY photoid ASC"); 
if($query->num_rows > 0){ 
    while($row = $query->fetch_assoc()){ 
        $status = ($row['status'] == 1)?'Active':'Inactive'; 
        $lineData = array($row['photoid'], $row['fullname'], $row['typeservice'], $row['emailcustomer'], $row['mobilecustomer'], $row['age'], $row['paymethode'], $row['creatdate'], $status);  
        $excelData[] = $lineData; 
    } 
} 
 
// Export data to excel and download as xlsx file 
$xlsx = CodexWorld\PhpXlsxGenerator::fromArray( $excelData ); 
$xlsx->downloadAs($fileName); 
$xlsx->saveAs('customers-data.xlsx');
exit; 
 
?>